/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class Delete
extends ACreate {
    public Delete(String target) {
        super(514, target);
    }

    @Override
    protected boolean run() {
        Data data = this.context.data();
        String target = this.args[0];
        IntList docs = data.docs(target);
        Delete.delete(this.context, docs);
        TokenList raw = Delete.files(data, target);
        Delete.delete(data, raw);
        return this.info(Text.PATHDELETED, docs.size() + raw.size(), this.perf);
    }

    public static void delete(Context ctx, IntList docs) {
        if (docs.size() == 0) {
            return;
        }
        Data data = ctx.data();
        int d = docs.size() - 1;
        while (d >= 0) {
            data.delete(docs.get(d));
            --d;
        }
        ctx.update();
        data.flush();
    }

    public static byte[] delete(Data data, TokenList res) {
        for (byte[] key : res) {
            IOFile file = data.meta.binary(Token.string(key));
            if (file != null && file.delete()) continue;
            return key;
        }
        return null;
    }

    public static TokenList files(Data data, String res) {
        TokenList tl = data.files(res);
        IOFile bin = data.meta.binary(res);
        if (bin != null && bin.isDir()) {
            tl.add(res);
        }
        return tl;
    }
}

