/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class Rename
extends ACreate {
    public Rename(String source, String target) {
        super(514, source, target);
    }

    @Override
    protected boolean run() {
        Data data = this.context.data();
        String src = MetaData.normPath(this.args[0]);
        if (src == null) {
            return this.error(Text.NAMEINVALID, this.args[0]);
        }
        String trg = MetaData.normPath(this.args[1]);
        if (trg == null) {
            return this.error(Text.NAMEINVALID, this.args[1]);
        }
        boolean ok = true;
        int c = 0;
        IntList docs = data.docs(src);
        int i = 0;
        int ds = docs.size();
        while (i < ds) {
            int pre = docs.get(i);
            String target = Rename.target(data, pre, src, trg);
            if (target.isEmpty()) {
                this.info(Text.NAMEINVALID, target);
                ok = false;
            } else {
                data.update(pre, 0, Token.token(target));
                ++c;
            }
            ++i;
        }
        if (c != 0) {
            data.flush();
        }
        IOFile file = data.meta.binary(src);
        IOFile target = data.meta.binary(trg);
        IOFile trgdir = new IOFile(target.dir());
        if (file == null || !trgdir.exists() && !trgdir.md() || file.exists() && !file.rename(target)) {
            ok = false;
            this.info(Text.NAMEINVALID, trg);
        } else {
            ++c;
        }
        this.info(Text.PATHRENAMED, c, this.perf);
        return ok;
    }

    public static String target(Data data, int pre, String src, String trg) {
        String path = Token.string(data.text(pre, true));
        if (Prop.WIN ? path.equalsIgnoreCase(src) : path.equals(src)) {
            return trg;
        }
        String name = path.substring(src.length() + 1);
        return !trg.isEmpty() ? String.valueOf(trg) + '/' + name : name;
    }
}

