/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;

public final class Retrieve
extends ACreate {
    public Retrieve(String path) {
        super(512, path);
    }

    @Override
    protected boolean run() throws IOException {
        String path = MetaData.normPath(this.args[0]);
        if (path == null) {
            return this.error(Text.NAMEINVALID, this.args[0]);
        }
        IOFile bin = this.context.data().meta.binary(path);
        if (bin == null || !bin.exists() || bin.isDir()) {
            return this.error(Text.FILEWHICH, path);
        }
        try {
            BufferInput bi = bin.buffer();
            try {
                int b;
                while ((b = bi.read()) != -1) {
                    this.out.write(b);
                }
            }
            finally {
                bi.close();
            }
            return this.info(Text.QUERYEXEC, this.perf);
        }
        catch (IOException ex) {
            return this.error(Text.DBNOTSTORED, ex.getMessage());
        }
    }
}

