/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import java.util.Arrays;
import org.basex.core.Text;
import org.basex.data.Namespaces;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;

final class NSNode {
    NSNode[] ch;
    int size;
    NSNode par;
    int[] vals;
    int pre;

    NSNode(int p) {
        this.vals = new int[0];
        this.ch = new NSNode[0];
        this.pre = p;
    }

    NSNode(DataInput in, NSNode p) throws IOException {
        this.par = p;
        this.pre = in.readNum();
        this.vals = in.readNums();
        this.size = in.readNum();
        this.ch = new NSNode[this.size];
        int c = 0;
        while (c < this.size) {
            this.ch[c] = new NSNode(in, this);
            ++c;
        }
    }

    void write(DataOutput out) throws IOException {
        out.writeNum(this.pre);
        out.writeNums(this.vals);
        out.writeNum(this.size);
        int c = 0;
        while (c < this.size) {
            this.ch[c].write(out);
            ++c;
        }
    }

    NSNode add(NSNode n) {
        int s = this.size;
        if (s == this.ch.length) {
            NSNode[] tmp = new NSNode[Math.max(s << 1, 1)];
            System.arraycopy(this.ch, 0, tmp, 0, s);
            this.ch = tmp;
        }
        while (--s >= 0 && n.pre - this.ch[s].pre <= 0) {
        }
        System.arraycopy(this.ch, ++s, this.ch, s + 1, this.size++ - s);
        this.ch[s] = n;
        n.par = this;
        return n;
    }

    void add(int p, int u) {
        int s = this.vals.length;
        this.vals = Arrays.copyOf(this.vals, s + 2);
        this.vals[s] = p;
        this.vals[s + 1] = u;
    }

    void delete(int uri) {
        NSNode[] nSNodeArray = this.ch;
        int n = this.ch.length;
        int n2 = 0;
        while (n2 < n) {
            NSNode n3 = nSNodeArray[n2];
            n3.delete(uri);
            ++n2;
        }
        IntList il = new IntList(this.vals.length);
        int v = 0;
        while (v < this.vals.length) {
            if (this.vals[v + 1] != uri) {
                il.add(this.vals[v]);
                il.add(this.vals[v + 1]);
            }
            v += 2;
        }
        if (il.size() != this.vals.length) {
            this.vals = il.toArray();
        }
    }

    NSNode find(int p) {
        int s = this.fnd(p);
        return s == -1 ? this : (this.ch[s].pre == p ? this.ch[s] : this.ch[s].find(p));
    }

    int uri(int p) {
        int v = 0;
        while (v < this.vals.length) {
            if (this.vals[v] == p) {
                return this.vals[v + 1];
            }
            v += 2;
        }
        return 0;
    }

    void delete(int p, int sz) {
        int s = this.fnd(p);
        if (s == -1 || this.ch[s].pre != p) {
            ++s;
        }
        int upper = p + sz;
        int num = 0;
        int i = s;
        while (i < this.size && this.ch[i].pre < upper) {
            ++i;
            ++num;
        }
        this.size -= num;
        if (this.size == 0) {
            this.ch = new NSNode[0];
        } else if (num > 0) {
            System.arraycopy(this.ch, s + num, this.ch, s, this.size - s);
        }
    }

    int fnd(int p) {
        int l = 0;
        int h = this.size - 1;
        while (l <= h) {
            int m = l + h >>> 1;
            int v = this.ch[m].pre;
            if (v == p) {
                return m;
            }
            if (v < p) {
                l = m + 1;
                continue;
            }
            h = m - 1;
        }
        return l - 1;
    }

    String print(Namespaces ns, int s, int e) {
        TokenBuilder tb = new TokenBuilder();
        this.print(tb, 0, ns, s, e);
        return tb.toString();
    }

    private void print(TokenBuilder tb, int l, Namespaces ns, int s, int e) {
        if (this.pre >= s && this.pre <= e) {
            tb.add(Text.NL);
            int i = 0;
            while (i < l) {
                tb.add("  ");
                ++i;
            }
            tb.add("Pre[" + this.pre + "] ");
            i = 0;
            while (i < this.vals.length) {
                tb.add("xmlns");
                byte[] p = ns.pref(this.vals[i]);
                if (p.length != 0) {
                    tb.add(58);
                }
                tb.add(p);
                tb.add("=\"");
                tb.add(ns.uri(this.vals[i + 1]));
                tb.add("\" ");
                i += 2;
            }
        }
        int c = 0;
        while (c < this.size) {
            this.ch[c].print(tb, l + 1, ns, s, e);
            ++c;
        }
    }

    public String toString() {
        return "Pre[" + this.pre + "]";
    }
}

