/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;

public final class StatsKey {
    public Kind kind;
    public TokenSet cats;
    public double min;
    public double max;
    public int counter;
    public boolean leaf;
    private final int maxcats;
    private double len;

    public StatsKey(int c) {
        this.cats = new TokenSet();
        this.kind = Kind.INT;
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
        this.leaf = true;
        this.maxcats = c;
    }

    public StatsKey(DataInput in, int c) throws IOException {
        this.kind = Kind.values()[in.readNum()];
        if (this.kind == Kind.INT || this.kind == Kind.DBL) {
            this.min = in.readDouble();
            this.max = in.readDouble();
        } else if (this.kind == Kind.CAT) {
            this.cats = new TokenSet();
            int cl = in.readNum();
            int i = 0;
            while (i < cl) {
                this.cats.add(in.readToken());
                ++i;
            }
        }
        this.counter = in.readNum();
        this.leaf = in.readBool();
        this.len = in.readDouble();
        this.maxcats = c;
    }

    public void finish(DataOutput out) throws IOException {
        if (this.cats != null && this.cats.size() == 0) {
            this.kind = Kind.NONE;
            this.leaf = false;
        }
        out.writeNum(this.kind.ordinal());
        if (this.kind == Kind.INT || this.kind == Kind.DBL) {
            out.writeDouble(this.min);
            out.writeDouble(this.max);
        } else if (this.kind == Kind.CAT) {
            int cl = this.cats.size();
            out.writeNum(cl);
            for (byte[] k : this.cats) {
                out.writeToken(k);
            }
        }
        out.writeNum(this.counter);
        out.writeBool(this.leaf);
        out.writeDouble(this.len);
    }

    public void add(byte[] val) {
        int vl = val.length;
        if ((double)vl > this.len) {
            this.len = vl;
        }
        if (vl == 0 || this.kind == Kind.TEXT || Token.ws(val)) {
            return;
        }
        if (this.cats != null && this.cats.size() <= this.maxcats) {
            if (val.length > 96) {
                this.kind = Kind.TEXT;
                this.cats = null;
            } else {
                this.cats.add(val);
            }
        }
        if (this.kind == Kind.INT) {
            long d = Token.toLong(val);
            if (d == Long.MIN_VALUE) {
                this.kind = Kind.DBL;
            } else {
                if (this.min > (double)d) {
                    this.min = d;
                }
                if (this.max < (double)d) {
                    this.max = d;
                }
            }
        }
        if (this.kind == Kind.DBL) {
            double d = Token.toDouble(val);
            if (Double.isNaN(d)) {
                this.kind = this.cats.size() <= this.maxcats ? Kind.CAT : Kind.TEXT;
            } else {
                if (this.min > d) {
                    this.min = d;
                }
                if (this.max < d) {
                    this.max = d;
                }
            }
        } else if (this.kind == Kind.CAT && this.cats.size() > this.maxcats) {
            this.kind = Kind.TEXT;
            this.cats = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.counter) + "x");
        switch (this.kind) {
            case CAT: {
                sb.append(", " + this.cats.size() + " values");
                break;
            }
            case DBL: {
                sb.append(", numeric(" + this.min + " - " + this.max + ")");
                break;
            }
            case INT: {
                sb.append(", numeric(" + (int)this.min + " - " + (int)this.max + ")");
                break;
            }
            case TEXT: {
                sb.append(", strings");
                break;
            }
        }
        if (this.len != 0.0) {
            sb.append(", " + this.len + " max. length");
        }
        if (this.leaf) {
            sb.append(", leaf");
        }
        return sb.toString();
    }

    public static enum Kind {
        TEXT,
        CAT,
        INT,
        DBL,
        NONE;

    }
}

