/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.basex.core.Text;
import org.basex.core.cmd.InfoDB;
import org.basex.data.Data;
import org.basex.data.DiskData;
import org.basex.data.MetaData;
import org.basex.gui.GUI;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.dialog.DialogFT;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTabs;
import org.basex.index.IndexToken;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class DialogInfo
extends Dialog {
    private final BaseXCheckBox[] indexes = new BaseXCheckBox[4];
    private DialogFT ft;
    private final BaseXBack buttons;
    private final Object optimize;
    public boolean opt;

    public DialogInfo(GUI main) {
        super(main, Text.INFODB);
        BaseXBack tab1 = new BaseXBack(new BorderLayout());
        tab1.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(8, 8, 8, 8)));
        final Data data = this.gui.context.data();
        MetaData meta = data.meta;
        Font f = tab1.getFont();
        BaseXLabel doc = new BaseXLabel(meta.name).border(0, 0, 5, 0);
        doc.setFont(f.deriveFont(f.getSize2D() + 7.0f));
        tab1.add((Component)doc, "North");
        byte[] db = InfoDB.db(meta, true, false, true);
        TokenBuilder info = new TokenBuilder(db);
        if (data.ns.size() != 0) {
            info.bold().add(String.valueOf(Text.NL) + Text.INFONS + Text.NL).norm().add(data.ns.info());
        }
        BaseXEditor text = this.text(info.finish());
        text.setFont(f);
        tab1.add((Component)text, "Center");
        BaseXBack tab2 = new BaseXBack(new GridLayout(2, 1, 0, 8)).border(8);
        tab2.add(this.addIndex(true, data));
        tab2.add(this.addIndex(false, data));
        String[] cb = new String[]{Text.INFOPATHINDEX, Text.INFOTEXTINDEX, Text.INFOATTRINDEX, Text.INFOFTINDEX};
        boolean[] val = new boolean[]{data.meta.pathindex, data.meta.textindex, data.meta.attrindex, data.meta.ftindex};
        BaseXBack[] panels = new BaseXBack[this.indexes.length];
        int i = 0;
        while (i < this.indexes.length) {
            this.indexes[i] = new BaseXCheckBox(cb[i], val[i], 0, this);
            this.indexes[i].setEnabled(data instanceof DiskData);
            panels[i] = new BaseXBack(new BorderLayout());
            ++i;
        }
        BaseXBack tab3 = new BaseXBack(new GridLayout(1, 1)).border(8);
        JComponent north = this.indexes[0];
        if (val[0]) {
            north = new BaseXBack(new BorderLayout());
            north.add((Component)this.indexes[0], "West");
            BaseXButton export = new BaseXButton(Text.GUIEXPORT, this);
            export.setMnemonic();
            export.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block13: {
                        IO file = DialogInfo.save(DialogInfo.this.gui, true);
                        if (file != null) {
                            PrintOutput po = null;
                            try {
                                try {
                                    po = new PrintOutput(file.path());
                                    data.pthindex.plan(Serializer.get(po));
                                }
                                catch (IOException ex) {
                                    Dialog.error(DialogInfo.this.gui, Text.NOTSAVED);
                                    if (po == null) break block13;
                                    try {
                                        po.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                            finally {
                                if (po != null) {
                                    try {
                                        po.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                    }
                }
            });
            north.add((Component)export, "East");
        }
        panels[0].add((Component)north, "North");
        panels[0].add((Component)this.text(val[0] ? data.info(IndexToken.IndexType.PATH) : Token.token(Text.PATHINDEXINFO)), "Center");
        tab3.add(panels[0]);
        BaseXBack tab4 = new BaseXBack(new GridLayout(2, 1)).border(8);
        panels[1].add((Component)this.indexes[1], "North");
        panels[1].add((Component)this.text(val[1] ? data.info(IndexToken.IndexType.TEXT) : Token.token(Text.TXTINDEXINFO)), "Center");
        tab4.add(panels[1]);
        panels[2].add((Component)this.indexes[2], "North");
        panels[2].add((Component)this.text(val[2] ? data.info(IndexToken.IndexType.ATTRIBUTE) : Token.token(Text.ATTINDEXINFO)), "Center");
        tab4.add(panels[2]);
        BaseXBack tab5 = new BaseXBack(new GridLayout(1, 1)).border(8);
        panels[3].add((Component)this.indexes[3], "North");
        if (!val[3]) {
            this.ft = new DialogFT(this, false);
        }
        panels[3].add((Component)(val[3] ? this.text(data.info(IndexToken.IndexType.FULLTEXT)) : this.ft), "Center");
        tab5.add(panels[3]);
        BaseXTabs tabs = new BaseXTabs(this);
        tabs.addTab(Text.GENERALINFO, tab1);
        tabs.addTab(Text.NAMESINFO, tab2);
        tabs.addTab(Text.INFOPATHINDEX, tab3);
        tabs.addTab(Text.INDEXINFO, tab4);
        tabs.addTab(Text.FTINFO, tab5);
        this.set(tabs, "Center");
        this.optimize = new BaseXButton(Text.BUTTONOPT, this);
        this.buttons = DialogInfo.newButtons(this, this.optimize, Text.BUTTONOK, Text.BUTTONCANCEL);
        this.set(this.buttons, "South");
        this.action(null);
        this.setResizable(true);
        this.setMinimumSize(this.getPreferredSize());
        this.finish(null);
    }

    static IO save(GUI gui, boolean single) {
        BaseXFileChooser fc = new BaseXFileChooser(Text.GUISAVEAS, gui.gprop.get(GUIProp.SAVEPATH), gui);
        fc.addFilter("XML Documents", ".xml");
        IOFile file = fc.select(single ? BaseXFileChooser.Mode.FSAVE : BaseXFileChooser.Mode.DSAVE);
        if (file != null) {
            gui.gprop.set(GUIProp.SAVEPATH, file.path());
        }
        return file;
    }

    private BaseXBack addIndex(boolean tag, Data data) {
        String lbl;
        BaseXBack p = new BaseXBack(new BorderLayout());
        String string = lbl = tag ? Text.INFOTAGS : Text.INFOATTS;
        if (!data.meta.uptodate) {
            lbl = String.valueOf(lbl) + " (" + Text.INFOOUTOFDATED + ")";
        }
        p.add((Component)new BaseXLabel(lbl, false, true), "North");
        IndexToken.IndexType index = tag ? IndexToken.IndexType.TAG : IndexToken.IndexType.ATTNAME;
        p.add((Component)this.text(data.info(index)), "Center");
        return p;
    }

    private BaseXEditor text(byte[] txt) {
        BaseXEditor text = new BaseXEditor(false, (Window)this);
        text.setText(txt);
        text.setPreferredSize(new Dimension(550, 160));
        return text;
    }

    public boolean[] indexes() {
        boolean[] in = new boolean[this.indexes.length];
        int i = 0;
        while (i < this.indexes.length) {
            in[i] = this.indexes[i].isSelected();
            ++i;
        }
        return in;
    }

    @Override
    public void action(Object cmp) {
        boolean bl = this.opt = cmp == this.optimize;
        if (this.opt) {
            this.close();
        }
        if (this.ft != null) {
            this.ft.action(this.indexes[3].isSelected());
        }
        DialogInfo.enableOK(this.buttons, Text.BUTTONOPT, !this.gui.context.data().meta.uptodate);
    }

    @Override
    public void close() {
        super.close();
        if (this.ft != null) {
            this.ft.close();
        }
    }
}

