/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.basex.core.Text;
import org.basex.core.cmd.List;
import org.basex.data.MetaData;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class DialogInput
extends Dialog {
    private final BaseXTextField input;
    private final String old;
    private final BaseXBack buttons;
    private final BaseXLabel info;
    private final StringList db;
    private final int type;

    public DialogInput(String o, String tit, GUI main, int t) {
        super(main, tit);
        this.old = o;
        this.db = List.list(main.context);
        this.type = t;
        String title = "";
        if (this.type == 0) {
            title = Text.CREATETARGET;
        } else if (this.type == 1) {
            title = Text.CREATENAME;
        } else if (this.type == 2) {
            title = Text.CREATENAMEC;
        }
        this.set(new BaseXLabel(title, false, true).border(0, 0, 4, 0), "North");
        this.input = new BaseXTextField(o, this);
        this.input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!BaseXKeys.modifier(e)) {
                    DialogInput.this.action(BaseXKeys.ENTER.is(e) ? e.getSource() : null);
                }
            }
        });
        this.info = new BaseXLabel(" ");
        BaseXBack p = new BaseXBack(new BorderLayout(0, 8));
        p.add((Component)this.input, "North");
        p.add((Component)this.info, "Center");
        this.set(p, "Center");
        this.buttons = DialogInput.newButtons(this, Text.BUTTONOK, Text.BUTTONCANCEL);
        this.set(this.buttons, "South");
        this.action(null);
        this.finish(null);
    }

    public String input() {
        return this.input.getText().trim();
    }

    @Override
    public void action(Object cmp) {
        String in = this.input();
        String msg = null;
        if (this.type > 0) {
            boolean bl = this.ok = this.db.contains(in) || in.equals(this.old);
            if (this.ok) {
                msg = Util.info(Text.DBEXIST, in);
            }
            if (!this.ok) {
                this.ok = MetaData.validName(in, false);
                if (!this.ok) {
                    msg = in.isEmpty() ? Text.DBWHICH : Util.info(Text.INVALID, Text.EDITNAME);
                }
            }
        } else {
            int docs = in.isEmpty() ? 0 : this.gui.context.data().docs(in).size();
            msg = Util.info(Text.DELETEPATH, docs);
            this.ok = docs != 0;
        }
        this.info.setText(msg, this.type == 1 || this.type == 2 ? GUIConstants.Msg.ERROR : GUIConstants.Msg.WARN);
        DialogInput.enableOK(this.buttons, Text.BUTTONOK, this.ok);
    }

    @Override
    public void close() {
        if (this.ok) {
            super.close();
        }
    }
}

