/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.basex.core.Lang;
import org.basex.core.MainProp;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IOFile;

public final class DialogPrefs
extends Dialog {
    private static final String[][] LANGS = Lang.parse();
    private final BaseXLabel creds;
    private final BaseXCombo lang;
    private final BaseXCheckBox focus;
    private final BaseXCheckBox names;
    private final BaseXCheckBox simpfd;
    private final BaseXCheckBox javalook;
    private final BaseXBack buttons;
    final BaseXTextField path;

    public DialogPrefs(GUI main) {
        super(main, Text.PREFSTITLE);
        BaseXBack pp = new BaseXBack(new TableLayout(11, 1));
        pp.add(new BaseXLabel(Text.DATABASEPATH, true, true));
        BaseXBack p = new BaseXBack(new TableLayout(1, 2, 8, 0));
        MainProp mprop = this.gui.context.mprop;
        GUIProp gprop = this.gui.gprop;
        this.path = new BaseXTextField(mprop.dbpath().path(), this);
        this.path.addKeyListener(this.keys);
        BaseXButton button = new BaseXButton(Text.BUTTONBROWSE, this);
        button.setMnemonic();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IOFile file = new BaseXFileChooser(Text.DIALOGFC, DialogPrefs.this.path.getText(), DialogPrefs.this.gui).select(BaseXFileChooser.Mode.DOPEN);
                if (file != null) {
                    DialogPrefs.this.path.setText(file.dir());
                }
            }
        });
        p.add(this.path);
        p.add(button);
        pp.add(p);
        pp.add(new BaseXLabel(Text.PREFINTER, true, true).border(10, 0, 8, 0));
        this.javalook = new BaseXCheckBox(Text.PREFLF, gprop.is(GUIProp.JAVALOOK), this);
        pp.add(this.javalook);
        this.focus = new BaseXCheckBox(Text.PREFFOCUS, gprop.is(GUIProp.MOUSEFOCUS), this);
        pp.add(this.focus);
        this.simpfd = new BaseXCheckBox(Text.SIMPLEFILE, gprop.is(GUIProp.SIMPLEFD), this);
        pp.add(this.simpfd);
        this.names = new BaseXCheckBox(Text.PREFNAME, gprop.is(GUIProp.SHOWNAME), 12, this);
        Data data = this.gui.context.data();
        this.names.setEnabled(data != null && data.nameID != 0);
        pp.add(this.names);
        pp.add(new BaseXLabel(Text.PREFLANG, true, true));
        p = new BaseXBack(new TableLayout(1, 2, 12, 0));
        this.lang = new BaseXCombo(this, LANGS[0]);
        this.lang.setSelectedItem(mprop.get(MainProp.LANG));
        p.add(this.lang);
        this.creds = new BaseXLabel(" ");
        p.add(this.creds);
        this.creds.setText(String.valueOf(Text.TRANSLATION) + DialogPrefs.creds(this.lang.getSelectedItem().toString()));
        pp.add(p);
        this.buttons = DialogPrefs.okCancel(this);
        this.set(this.buttons, "South");
        this.set(pp, "Center");
        this.finish(null);
    }

    @Override
    public void action(Object cmp) {
        this.creds.setText(String.valueOf(Text.TRANSLATION) + DialogPrefs.creds(this.lang.getSelectedItem().toString()));
        this.gui.notify.layout();
    }

    @Override
    public void close() {
        MainProp mprop = this.gui.context.mprop;
        mprop.set(MainProp.LANG, this.lang.getSelectedItem().toString());
        String dbpath = this.path.getText().trim();
        if (!mprop.get(MainProp.DBPATH).equals(dbpath)) {
            this.gui.execute(new Close());
        }
        mprop.set(MainProp.DBPATH, dbpath);
        mprop.write();
        GUIProp gprop = this.gui.gprop;
        gprop.set(GUIProp.MOUSEFOCUS, this.focus.isSelected());
        gprop.set(GUIProp.SHOWNAME, this.names.isSelected());
        gprop.set(GUIProp.SIMPLEFD, this.simpfd.isSelected());
        gprop.set(GUIProp.JAVALOOK, this.javalook.isSelected());
        gprop.write();
        this.dispose();
    }

    static String creds(String lng) {
        int i = 0;
        while (i < LANGS[0].length) {
            if (LANGS[0][i].equals(lng)) {
                return LANGS[1][i];
            }
            ++i;
        }
        return "";
    }
}

