/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import org.basex.core.Commands;
import org.basex.core.Text;
import org.basex.core.cmd.AlterUser;
import org.basex.core.cmd.CreateUser;
import org.basex.core.cmd.DropUser;
import org.basex.core.cmd.Grant;
import org.basex.core.cmd.List;
import org.basex.core.cmd.ShowUsers;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.dialog.DialogPass;
import org.basex.gui.dialog.DialogServer;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPassword;
import org.basex.gui.layout.BaseXTable;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.server.Session;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

final class DialogUser
extends BaseXBack {
    private Session sess;
    private Table users = new Table();
    private final BaseXButton create;
    private final BaseXButton alter;
    private final BaseXButton drop;
    private final BaseXButton add;
    private final BaseXTextField user;
    private final BaseXPassword pass;
    private final BaseXCombo addUser;
    private final BaseXCombo databases;
    private final BaseXTable table;
    private final BaseXLabel info;
    private final boolean global;
    private final DialogServer dia;
    private final BaseXBack tablePanel;

    DialogUser(boolean g, DialogServer d) {
        AbstractButton[] abstractButtonArray;
        this.global = g;
        this.dia = d;
        this.layout(new TableLayout(7, 1, 0, 4)).border(8);
        this.user = new BaseXTextField("", this.dia);
        this.user.addKeyListener(this.dia.keys);
        BaseXLayout.setWidth(this.user, 100);
        this.create = new BaseXButton(Text.BUTTONCREATE, this.dia);
        this.pass = new BaseXPassword(this.dia.gui);
        this.pass.addKeyListener(this.dia.keys);
        BaseXLayout.setWidth(this.pass, 100);
        this.alter = new BaseXButton(Text.BUTTONALTER, this.dia);
        this.drop = new BaseXButton(Text.BUTTONDROP, this.dia);
        this.info = new BaseXLabel(" ");
        this.add(new BaseXLabel(String.valueOf(Text.CREATEU) + ": ", false, true));
        BaseXBack p = new BaseXBack(new TableLayout(1, 5, 8, 0)).border(0, 0, 5, 0);
        p.add(new BaseXLabel(String.valueOf(Text.SERVERUSER) + ": "));
        p.add(this.user);
        p.add(new BaseXLabel(String.valueOf(Text.SERVERPW) + ": "));
        p.add(this.pass);
        p.add(this.create);
        this.add(p);
        this.tablePanel = new BaseXBack(new BorderLayout(0, 5));
        this.databases = new BaseXCombo(this.dia, new String[0]);
        BaseXLayout.setWidth(this.databases, 210);
        this.addUser = new BaseXCombo(this.dia, new String[0]);
        this.add = new BaseXButton(Text.BUTTONADD, this.dia);
        BaseXLayout.setWidth(this.addUser, 131);
        if (!this.global) {
            p = new BaseXBack(new TableLayout(2, 3, 8, 2));
            p.add(new BaseXLabel(String.valueOf(Text.DATABASES) + ":", false, true));
            p.add(new BaseXLabel(String.valueOf(Text.BUTTONADD) + ":", false, true));
            p.add(new BaseXLabel());
            p.add(this.databases);
            p.add(this.addUser);
            p.add(this.add);
            this.tablePanel.add((Component)p, "North");
        }
        p = new BaseXBack(new TableLayout(2, 2, 8, 5));
        p.add(new BaseXLabel(this.global ? Text.GLOBPERM : Text.LOCPERM, false, true));
        p.add(new BaseXLabel());
        this.table = new BaseXTable(this.users, this.dia);
        JScrollPane sp = new JScrollPane(this.table);
        BaseXLayout.setHeight(sp, 220);
        BaseXLayout.setWidth(sp, 350);
        p.add(sp);
        BaseXBack pp = new BaseXBack(new TableLayout(2, 1, 0, 5));
        if (this.global) {
            pp.add(this.alter);
        }
        pp.add(this.drop);
        p.add(pp);
        this.tablePanel.add((Component)p, "Center");
        this.tablePanel.add((Component)this.info, "South");
        this.add(this.tablePanel);
        if (this.global) {
            BaseXButton[] baseXButtonArray = new BaseXButton[3];
            baseXButtonArray[0] = this.create;
            baseXButtonArray[1] = this.alter;
            abstractButtonArray = baseXButtonArray;
            baseXButtonArray[2] = this.drop;
        } else {
            AbstractButton[] abstractButtonArray2 = new BaseXButton[2];
            abstractButtonArray2[0] = this.add;
            abstractButtonArray = abstractButtonArray2;
            abstractButtonArray2[1] = this.drop;
        }
        BaseXButton.setMnemonics(abstractButtonArray);
        this.action(null);
    }

    void action(Object cmp) {
        GUIConstants.Msg icon;
        int n;
        int[] nArray;
        boolean ok = true;
        String msg = null;
        try {
            String db;
            Object di = this.databases.getSelectedItem();
            String string = db = di == null ? null : di.toString();
            if (cmp instanceof Object[]) {
                boolean confirm;
                Object[] o = (Object[])cmp;
                boolean g = o[0] == Boolean.TRUE;
                Commands.CmdPerm perm = Commands.CmdPerm.values()[(Integer)o[2] - (g ? 0 : 1)];
                String uname = this.table.getModel().getValueAt((Integer)o[1], 0).toString();
                boolean bl = confirm = !g && uname.equals(this.dia.loguser.getText());
                if (confirm && !Dialog.confirm(this.dia.gui, Util.info(Text.DBREVOKE, new Object[0]))) {
                    return;
                }
                this.sess.execute(new Grant((Object)perm, uname, db));
                msg = this.sess.info();
                if (confirm) {
                    if (perm == Commands.CmdPerm.ADMIN) {
                        this.dia.tabs.setSelectedIndex(0);
                        this.dia.action(this.dia.disconnect);
                    } else {
                        this.setSess(this.sess);
                    }
                } else {
                    this.setData();
                }
            } else if (cmp == this) {
                this.setSess(this.sess);
            } else if (cmp == this.databases) {
                this.setData();
            } else if (cmp == this.create || cmp == this.user || cmp == this.pass) {
                String u = this.user.getText();
                String p = Token.md5(new String(this.pass.getPassword()));
                this.sess.execute(new CreateUser(u, p));
                msg = this.sess.info();
                this.setData();
                this.user.setText("");
                this.pass.setText("");
                this.user.requestFocusInWindow();
            } else if (cmp == this.drop) {
                String msg2 = "";
                int[] rows = this.table.getSelectedRows();
                if (Dialog.confirm(this.dia.gui, Util.info(Text.DRQUESTION, rows.length))) {
                    nArray = rows;
                    n = rows.length;
                    int uname = 0;
                    while (uname < n) {
                        int r = nArray[uname];
                        this.sess.execute(new DropUser(this.table.data.value(r, 0), db));
                        if (msg == null) {
                            msg = this.sess.info();
                        } else if (msg2.isEmpty()) {
                            msg2 = " (...)";
                        }
                        if (!ok) break;
                        ++uname;
                    }
                    msg = String.valueOf(msg) + msg2;
                    this.setData();
                }
            } else if (cmp == this.alter) {
                DialogPass dp = new DialogPass(this.dia.gui);
                if (dp.ok()) {
                    this.sess.execute(new AlterUser(this.table.getValueAt(this.table.getSelectedRow(), 0).toString(), Token.md5(dp.pass())));
                    msg = this.sess.info();
                }
            } else if (cmp == this.add) {
                String us = this.addUser.getSelectedItem().toString();
                int r = 0;
                while (r < this.users.contents.size()) {
                    if (this.users.value(r, 0).equals(us)) {
                        int c = 3;
                        while (--c >= 0 && this.users.value(r, c).isEmpty()) {
                        }
                        String perm = Commands.CmdPerm.values()[c].toString();
                        this.sess.execute(new Grant((Object)perm, us, db));
                        msg = this.sess.info();
                        if (!ok) break;
                    }
                    ++r;
                }
                this.setData();
                this.addUser.requestFocusInWindow();
            }
        }
        catch (IOException ex) {
            msg = Util.message(ex);
            ok = false;
        }
        boolean valname = this.user.getText().matches("[\\w]*");
        boolean valpass = new String(this.pass.getPassword()).matches("[^ ;'\\\"]*");
        boolean newname = true;
        int r = 0;
        while (r < this.users.contents.size()) {
            newname &= !this.users.value(r, 0).equals(this.user.getText());
            ++r;
        }
        this.alter.setEnabled(this.table.getSelectedRows().length == 1);
        this.create.setEnabled(valname && valpass && newname && !this.user.getText().isEmpty() && this.pass.getPassword().length != 0);
        this.add.setEnabled(this.addUser.getSelectedIndex() > 0);
        this.addUser.setEnabled(this.addUser.getSelectedIndex() > -1);
        boolean valdrop = true;
        nArray = this.table.getSelectedRows();
        n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int r2 = nArray[n2];
            valdrop &= !this.table.data.value(r2, 0).equals("admin");
            ++n2;
        }
        this.drop.setEnabled(valdrop && this.table.getSelectedRows().length > 0);
        GUIConstants.Msg msg2 = icon = ok ? GUIConstants.Msg.SUCCESS : GUIConstants.Msg.ERROR;
        if (!(msg != null || valname && valpass && newname && (valdrop |= this.table.getSelectedRows().length == 1))) {
            msg = !newname ? Util.info(Text.USERKNOWN, this.user.getText()) : (!valdrop ? Text.USERADMIN : Util.info(Text.INVALID, !valname ? Text.SERVERUSER : Text.SERVERPW));
            icon = GUIConstants.Msg.WARN;
        }
        this.info.setText(msg, icon);
    }

    public void setData() throws IOException {
        this.users = this.table(null);
        if (this.global) {
            this.table.update(this.users);
        } else {
            this.addUser.removeAllItems();
            int i = this.databases.getSelectedIndex();
            if (i == 0) {
                this.table.update(new Table());
            }
            if (i <= 0) {
                return;
            }
            Table data = this.table(this.databases.getSelectedItem().toString());
            this.table.update(data);
            StringList added = new StringList();
            for (TokenList l : data.contents) {
                added.add(Token.string(l.get(0)));
            }
            StringList adding = new StringList();
            for (TokenList l : this.users.contents) {
                String s = Token.string(l.get(0));
                if (s.equals("admin") || added.contains(s)) continue;
                adding.add(s);
            }
            this.addUser.addItem(this.numberof(Text.USERS, adding.size()));
            for (String s : adding) {
                this.addUser.addItem(s);
            }
            this.addUser.setSelectedIndex(0);
        }
    }

    private Table table(String db) throws IOException {
        return new Table(this.sess.execute(new ShowUsers(db)));
    }

    public void setSess(Session s) throws IOException {
        this.sess = s;
        if (!this.global) {
            Table dbs = new Table(this.sess.execute(new List()));
            this.databases.removeAllItems();
            this.databases.addItem(this.numberof(Text.DATABASES, dbs.contents.size()));
            for (TokenList l : dbs.contents) {
                this.databases.addItem(Token.string(l.get(0)));
            }
            this.databases.setSelectedIndex(0);
        }
        this.setData();
    }

    private String numberof(String w, int n) {
        return "(" + n + " " + w + ")";
    }

    public BaseXBack getTablePanel() {
        return this.tablePanel;
    }
}

