/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.util.Performance;

public final class BaseXBar
extends BaseXPanel {
    public static final int SIZE = 16;
    private static final int MAXSTEP = 15;
    static final int[] STEPS;
    private static final int MINSIZE = 20;
    final BaseXPanel comp;
    final int ww;
    int step = STEPS.length / 2;
    boolean animated;
    int hh;
    int barPos;
    int barSize;
    int dragPos;
    boolean button;
    boolean up;
    boolean down;
    boolean sliding;
    boolean moving;
    int pos;
    int height;
    private int barOffset;
    private final boolean visible;

    static {
        int[] nArray = new int[22];
        nArray[0] = -15;
        nArray[1] = -14;
        nArray[2] = -11;
        nArray[3] = -8;
        nArray[4] = -6;
        nArray[5] = -4;
        nArray[6] = -3;
        nArray[7] = -2;
        nArray[8] = -1;
        nArray[9] = -1;
        nArray[12] = 1;
        nArray[13] = 1;
        nArray[14] = 2;
        nArray[15] = 3;
        nArray[16] = 4;
        nArray[17] = 6;
        nArray[18] = 8;
        nArray[19] = 11;
        nArray[20] = 14;
        nArray[21] = 15;
        STEPS = nArray;
    }

    public BaseXBar(BaseXPanel cmp) {
        this(cmp, false);
    }

    private BaseXBar(BaseXPanel cmp, boolean vis) {
        super(cmp.gui);
        this.comp = cmp;
        this.visible = vis;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.mode(GUIConstants.Fill.NONE);
        BaseXLayout.setWidth(this, 16);
        this.ww = 16;
    }

    public void pos(int p) {
        int pp = Math.max(0, Math.min(this.height - this.getHeight(), p));
        if (this.pos != pp) {
            this.pos = pp;
            this.repaint();
        }
    }

    public int pos() {
        return this.pos;
    }

    public void height(int h) {
        if (this.height != h) {
            this.height = h;
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.hh = this.getHeight();
        super.paintComponent(g);
        if (!this.visible && this.hh >= this.height) {
            return;
        }
        int barH = this.hh - this.ww * 2 + 4;
        float factor = (float)(barH - this.barOffset) / (float)this.height;
        int size = (int)((float)this.hh * factor);
        this.barOffset = size < 20 ? 20 - size : 0;
        this.barSize = Math.min(size += this.barOffset, barH - 1);
        this.barPos = (int)Math.max(0.0f, Math.min((float)this.pos * factor, (float)(barH - this.barSize)));
        g.setColor(GUIConstants.LGRAY);
        g.fillRect(0, 0, this.ww, this.hh);
        int bh = this.ww - 2 + this.barPos;
        BaseXLayout.drawCell(g, 0, this.ww, bh, bh + this.barSize, false);
        g.setColor(GUIConstants.DGRAY);
        g.drawLine(5, bh += this.barSize >> 1, this.ww - 6, bh);
        g.drawLine(5, bh - 2, this.ww - 6, bh - 2);
        g.drawLine(5, bh + 2, this.ww - 6, bh + 2);
        this.smooth(g);
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[3];
        nArray[1] = 6;
        nArray[2] = 3;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 6;
        nArray2[1] = 6;
        nArrayArray[1] = nArray2;
        this.drawButton(g, nArrayArray, 0, this.button && this.up);
        int[][] nArrayArray2 = new int[2][];
        int[] nArray3 = new int[3];
        nArray3[1] = 6;
        nArray3[2] = 3;
        nArrayArray2[0] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[2] = 6;
        nArrayArray2[1] = nArray4;
        this.drawButton(g, nArrayArray2, Math.max(16, this.hh - this.ww), this.button && this.down);
        g.setColor(GUIConstants.GRAY);
        g.drawLine(0, 0, 0, this.hh);
        g.drawLine(this.ww - 1, 0, this.ww - 1, this.hh);
    }

    private void drawButton(Graphics g, int[][] pol, int y, boolean focus) {
        BaseXLayout.drawCell(g, 0, this.ww, y, y + this.ww, focus);
        int i = 0;
        while (i < pol[0].length) {
            int[] nArray = pol[0];
            int n = i;
            nArray[n] = nArray[n] + 5;
            int[] nArray2 = pol[1];
            int n2 = i++;
            nArray2[n2] = nArray2[n2] + (y + 8 - 3);
        }
        g.setColor(focus ? Color.black : GUIConstants.DGRAY);
        g.fillPolygon(pol[0], pol[1], 3);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        final int y = e.getY();
        this.sliding = y > this.ww + this.barPos && y < this.ww + this.barPos + this.barSize;
        this.moving = !this.sliding;
        this.up = y < this.ww + this.barPos;
        this.down = y > this.ww + this.barPos + this.barSize;
        boolean bl = this.button = y < this.ww || y > this.hh - this.ww;
        if (this.sliding) {
            this.dragPos = this.barPos - y;
        }
        if (this.sliding || this.animated) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                BaseXBar.this.animated = BaseXBar.this.moving;
                while (BaseXBar.this.animated) {
                    BaseXBar.this.step = BaseXBar.this.moving ? Math.max(0, Math.min(STEPS.length - 1, BaseXBar.this.step + (BaseXBar.this.down ? 1 : -1))) : BaseXBar.this.step + (BaseXBar.this.step < STEPS.length / 2 ? 1 : -1);
                    int offset = STEPS[BaseXBar.this.step];
                    if (!BaseXBar.this.button) {
                        offset = offset * BaseXBar.this.hh / 15 / 4;
                    }
                    BaseXBar.this.pos = Math.max(0, Math.min(BaseXBar.this.height - BaseXBar.this.hh, BaseXBar.this.pos + offset));
                    BaseXBar.this.comp.repaint();
                    Performance.sleep(25L);
                    boolean bl = BaseXBar.this.animated = BaseXBar.this.step != STEPS.length / 2;
                    if (y <= BaseXBar.this.ww + BaseXBar.this.barPos || y >= BaseXBar.this.ww + BaseXBar.this.barPos + BaseXBar.this.barSize) continue;
                    BaseXBar.this.dragPos = BaseXBar.this.barPos - y;
                    BaseXBar.this.animated = false;
                    BaseXBar.this.sliding = true;
                    BaseXBar.this.step = STEPS.length / 2;
                }
            }
        }.start();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.up = false;
        this.down = false;
        this.moving = false;
        this.sliding = false;
        this.comp.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.sliding) {
            return;
        }
        this.pos = (int)((long)(e.getY() + this.dragPos) * (long)this.height / (long)(this.hh - this.ww * 2));
        this.pos = Math.max(0, Math.min(this.height - this.hh, this.pos));
        this.comp.repaint();
    }
}

