/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.util.Token;

public class BaseXButton
extends JButton {
    public BaseXButton(String l, Window win) {
        super(l);
        BaseXLayout.addInteraction(this, win);
        if (!(win instanceof Dialog)) {
            return;
        }
        final Dialog d = (Dialog)win;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = BaseXButton.this.getText();
                if (text.equals(Text.BUTTONCANCEL)) {
                    d.cancel();
                } else if (text.equals(Text.BUTTONOK)) {
                    d.close();
                } else {
                    d.action(e.getSource());
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseXKeys.ESCAPE.is(e)) {
                    d.cancel();
                }
            }
        });
    }

    public BaseXButton(Window gui, String img, byte[] hlp) {
        super(BaseXLayout.icon("cmd-" + img));
        BaseXLayout.addInteraction(this, gui, hlp);
        if (hlp != null) {
            this.setToolTipText(Token.string(hlp));
        }
        Insets in = this.getMargin();
        in.left /= 4;
        in.right /= 4;
        if (in.top < in.left) {
            this.setMargin(in);
        }
    }

    public BaseXButton border(int t, int l, int b, int r) {
        this.setBorder(new EmptyBorder(t, l, b, r));
        return this;
    }

    public static BaseXButton command(final GUICommand cmd, final GUI gui) {
        BaseXButton button = new BaseXButton(gui, cmd.toString().toLowerCase(), Token.token(cmd.help()));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cmd.execute(gui);
            }
        });
        return button;
    }

    public void setMnemonic() {
        BaseXButton.setMnemonics(this);
    }

    public static void setMnemonics(AbstractButton ... buttons) {
        BaseXButton.setMnemonics(new StringBuilder(), buttons);
    }

    public static void setMnemonics(StringBuilder mnem, AbstractButton ... buttons) {
        AbstractButton[] abstractButtonArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractButton b = abstractButtonArray[n2];
            String label = b.getText();
            int l = 0;
            while (l < label.length()) {
                char ch = Character.toLowerCase(label.charAt(l));
                if (ch != ' ' && mnem.indexOf(Character.toString(ch)) == -1) {
                    b.setMnemonic(ch);
                    mnem.append(ch);
                    break;
                }
                ++l;
            }
            ++n2;
        }
    }

    @Override
    public void setEnabled(boolean flag) {
        if (flag != this.isEnabled()) {
            super.setEnabled(flag);
        }
    }
}

