/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.MatteBorder;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXBar;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.layout.BaseXSyntax;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.BaseXTextRenderer;
import org.basex.gui.layout.BaseXTextTokens;
import org.basex.gui.layout.JSONSyntax;
import org.basex.gui.layout.XMLSyntax;
import org.basex.gui.layout.XQuerySyntax;
import org.basex.io.IO;
import org.basex.util.Token;
import org.basex.util.Undo;

public class BaseXEditor
extends BaseXPanel {
    protected transient BaseXTextTokens text = new BaseXTextTokens(Token.EMPTY);
    protected final BaseXTextRenderer rend;
    private final BaseXBar scroll;
    protected final transient Undo undo;
    private BaseXTextField find;
    private int lastCol = -1;
    final Timer cursor = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BaseXEditor.this.rend.cursor(!BaseXEditor.this.rend.cursor());
            BaseXEditor.this.rend.repaint();
        }
    });
    private final transient Thread calc = new Thread(){

        @Override
        public void run() {
            BaseXEditor.this.rend.calc();
            BaseXEditor.this.rend.repaint();
        }
    };

    public BaseXEditor(boolean edit, Window win) {
        super(win);
        GUICommand[] gUICommandArray;
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(!edit);
        BaseXLayout.addInteraction(this, win);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (BaseXEditor.this.isEnabled()) {
                    BaseXEditor.this.cursor(true);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                BaseXEditor.this.cursor(false);
                BaseXEditor.this.rend.cursor(false);
                BaseXEditor.this.rend.repaint();
            }
        });
        this.layout(new BorderLayout(4, 0));
        this.scroll = new BaseXBar(this);
        this.rend = new BaseXTextRenderer(this.text, this.scroll);
        this.add((Component)this.rend, "Center");
        this.add((Component)this.scroll, "East");
        Undo un = null;
        if (edit) {
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 0, 0, GUIConstants.color(6)));
            un = new Undo();
        } else {
            this.mode(GUIConstants.Fill.NONE);
        }
        this.undo = un;
        if (edit) {
            GUICommand[] gUICommandArray2 = new GUICommand[9];
            gUICommandArray2[0] = new UndoCmd();
            gUICommandArray2[1] = new RedoCmd();
            gUICommandArray2[3] = new CutCmd();
            gUICommandArray2[4] = new CopyCmd();
            gUICommandArray2[5] = new PasteCmd();
            gUICommandArray2[6] = new DelCmd();
            gUICommandArray = gUICommandArray2;
            gUICommandArray2[8] = new AllCmd();
        } else {
            GUICommand[] gUICommandArray3 = new GUICommand[3];
            gUICommandArray3[0] = new CopyCmd();
            gUICommandArray = gUICommandArray3;
            gUICommandArray3[2] = new AllCmd();
        }
        new BaseXPopup(this, gUICommandArray);
    }

    public void setText(byte[] t) {
        this.setText(t, t.length);
        if (this.undo != null) {
            this.undo.reset(t);
        }
    }

    public final void setSearch(BaseXTextField f) {
        f.setSearch(this);
        this.find = f;
    }

    public final String pos() {
        int[] pos = this.rend.pos();
        return String.valueOf(pos[0]) + " : " + pos[1];
    }

    final void find(String t, boolean b) {
        this.scroll(this.rend.find(t, b));
    }

    final void scroll(int y) {
        int p = this.scroll.pos();
        int m = y + this.rend.fontH() * 3 - this.getHeight();
        if (y != 0 && (p < m || p > y)) {
            this.scroll.pos(y - this.getHeight() / 2);
        }
        this.repaint();
    }

    public final void setText(byte[] t, int s) {
        int ns = 0;
        int ts = this.text.size();
        byte[] tt = this.text.text;
        boolean eq = true;
        int r = 0;
        while (r < s) {
            byte b = t[r];
            if (b >= 32 || b <= 4 || b == 9 || b == 10) {
                t[ns++] = t[r];
            }
            eq &= ns < ts && ns < s && t[ns] == tt[ns];
            ++r;
        }
        if (!(eq &= ns == ts)) {
            this.text = new BaseXTextTokens(t, ns);
            this.rend.setText(this.text);
            this.scroll.pos(0);
        }
        if (this.undo != null) {
            this.undo.store(t.length != ns ? Arrays.copyOf(t, ns) : t, 0);
        }
        SwingUtilities.invokeLater(this.calc);
    }

    public final void setSyntax(IO file) {
        this.setSyntax(file.name().endsWith(".json") ? new JSONSyntax() : (file.isXML() ? new XMLSyntax() : new XQuerySyntax()));
    }

    public final void setSyntax(BaseXSyntax s) {
        this.rend.setSyntax(s);
    }

    public final void setCaret(int p) {
        this.text.setCaret(p);
        this.showCursor(1);
        this.cursor(true);
    }

    public final void scrollToEnd() {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                BaseXEditor.this.text.pos(BaseXEditor.this.text.size());
                BaseXEditor.this.text.setCaret();
                BaseXEditor.this.showCursor(2);
            }
        });
    }

    public final byte[] getText() {
        return this.text.toArray();
    }

    @Override
    public final void setFont(Font f) {
        super.setFont(f);
        if (this.rend != null) {
            this.rend.setFont(f);
            this.rend.repaint();
        }
    }

    public final void error(int s) {
        this.text.error(s);
        this.rend.repaint();
    }

    @Override
    public final void setEnabled(boolean e) {
        super.setEnabled(e);
        this.rend.setEnabled(e);
        this.scroll.setEnabled(e);
        this.cursor(e);
    }

    final void selectAll() {
        this.text.pos(0);
        this.text.startMark();
        this.text.pos(this.text.size());
        this.text.endMark();
        this.rend.repaint();
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
        this.gui.cursor(GUIConstants.CURSORTEXT);
    }

    @Override
    public final void mouseExited(MouseEvent e) {
        this.gui.cursor(GUIConstants.CURSORARROW);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.rend.stopSelect();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!SwingUtilities.isMiddleMouseButton(e)) {
            return;
        }
        if (!this.paste()) {
            return;
        }
        this.finish();
        this.repaint();
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this.rend.select(this.scroll.pos(), e.getPoint(), true);
        int y = Math.max(20, Math.min(e.getY(), this.getHeight() - 20));
        if (y != e.getY()) {
            this.scroll.pos(this.scroll.pos() + e.getY() - y);
        }
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        if (!this.isEnabled() || !this.isFocusable()) {
            return;
        }
        this.requestFocusInWindow();
        this.cursor(true);
        if (SwingUtilities.isMiddleMouseButton(e)) {
            this.copy();
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            int c = e.getClickCount();
            if (c == 1) {
                this.rend.select(this.scroll.pos(), e.getPoint(), false);
            } else if (c == 2) {
                this.selectWord();
            } else {
                this.selectLine();
            }
        } else if (!this.text.marked()) {
            this.rend.select(this.scroll.pos(), e.getPoint(), false);
        }
    }

    private void selectWord() {
        int c;
        this.text.pos(this.text.cursor());
        boolean ch = Token.ftChar(this.text.prev(true));
        while (this.text.pos() > 0) {
            c = this.text.prev(true);
            if (c == 10 || ch != Token.ftChar(c)) break;
        }
        if (this.text.pos() != 0) {
            this.text.next(true);
        }
        this.text.startMark();
        while (this.text.pos() < this.text.size()) {
            c = this.text.curr();
            if (c == 10 || ch != Token.ftChar(c)) break;
            this.text.next(true);
        }
        this.text.endMark();
    }

    private void selectLine() {
        this.text.pos(this.text.cursor());
        this.text.bol(true);
        this.text.startMark();
        this.text.forward(Integer.MAX_VALUE, true);
        this.text.endMark();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean nomark;
        if (BaseXKeys.modifier(e)) {
            return;
        }
        if (BaseXKeys.PREVTAB.is(e)) {
            this.transferFocusBackward();
            return;
        }
        if (BaseXKeys.NEXTTAB.is(e)) {
            this.transferFocus();
            return;
        }
        if (BaseXKeys.FIND.is(e)) {
            if (this.find != null) {
                this.find.requestFocusInWindow();
            }
            return;
        }
        this.cursor(true);
        int fh = this.rend.fontH();
        if (BaseXKeys.SCROLLDOWN.is(e)) {
            this.scroll.pos(this.scroll.pos() + fh);
            return;
        }
        if (BaseXKeys.SCROLLUP.is(e)) {
            this.scroll.pos(this.scroll.pos() - fh);
            return;
        }
        if (BaseXKeys.COPY1.is(e) || BaseXKeys.COPY2.is(e)) {
            this.copy();
            return;
        }
        this.text.pos(this.text.cursor());
        if (!BaseXKeys.PREVLINE.is(e) && !BaseXKeys.NEXTLINE.is(e)) {
            this.lastCol = -1;
        }
        if (BaseXKeys.FINDNEXT.is(e) || BaseXKeys.FINDPREV.is(e) || BaseXKeys.FINDNEXT2.is(e) || BaseXKeys.FINDPREV2.is(e)) {
            this.scroll(this.rend.find(BaseXKeys.FINDPREV.is(e) || BaseXKeys.FINDPREV2.is(e), true));
            return;
        }
        if (BaseXKeys.SELECTALL.is(e)) {
            this.selectAll();
            this.text.setCaret();
            return;
        }
        boolean marking = e.isShiftDown() && !BaseXKeys.DELNEXT.is(e) && !BaseXKeys.DELPREV.is(e) && !BaseXKeys.PASTE2.is(e) && !BaseXKeys.COMMENT.is(e);
        boolean bl = nomark = !this.text.marked();
        if (marking && nomark) {
            this.text.startMark();
        }
        boolean down = true;
        boolean consumed = true;
        byte[] txt = this.text.text;
        if (BaseXKeys.NEXTWORD.is(e)) {
            this.text.nextToken(marking);
        } else if (BaseXKeys.PREVWORD.is(e)) {
            this.text.prevToken(marking);
            down = false;
        } else if (BaseXKeys.TEXTSTART.is(e)) {
            if (!marking) {
                this.text.noMark();
            }
            this.text.pos(0);
            down = false;
        } else if (BaseXKeys.TEXTEND.is(e)) {
            if (!marking) {
                this.text.noMark();
            }
            this.text.pos(this.text.size());
        } else if (BaseXKeys.LINESTART.is(e)) {
            this.text.bol(marking);
            down = false;
        } else if (BaseXKeys.LINEEND.is(e)) {
            this.text.forward(Integer.MAX_VALUE, marking);
        } else if (BaseXKeys.NEXTPAGE.is(e)) {
            this.down(this.getHeight() / fh, marking);
        } else if (BaseXKeys.PREVPAGE.is(e)) {
            this.up(this.getHeight() / fh, marking);
            down = false;
        } else if (BaseXKeys.NEXT.is(e)) {
            this.text.next(marking);
        } else if (BaseXKeys.PREV.is(e)) {
            this.text.prev(marking);
            down = false;
        } else if (BaseXKeys.PREVLINE.is(e)) {
            this.up(1, marking);
            down = false;
        } else if (BaseXKeys.NEXTLINE.is(e)) {
            this.down(1, marking);
        } else {
            consumed = false;
        }
        if (marking) {
            this.text.endMark();
            this.text.checkMark();
        } else if (this.undo != null) {
            if (BaseXKeys.CUT1.is(e) || BaseXKeys.CUT2.is(e)) {
                this.cut();
            } else if (BaseXKeys.PASTE1.is(e) || BaseXKeys.PASTE2.is(e)) {
                this.paste();
            } else if (BaseXKeys.UNDO.is(e)) {
                this.undo();
            } else if (BaseXKeys.REDO.is(e)) {
                this.redo();
            } else if (BaseXKeys.COMMENT.is(e)) {
                this.text.comment(this.rend.getSyntax());
            } else if (BaseXKeys.DELLINEEND.is(e) || BaseXKeys.DELNEXTWORD.is(e) || BaseXKeys.DELNEXT.is(e)) {
                if (nomark) {
                    if (this.text.pos() == this.text.size()) {
                        return;
                    }
                    this.text.startMark();
                    if (BaseXKeys.DELNEXTWORD.is(e)) {
                        this.text.nextToken(true);
                    } else if (BaseXKeys.DELLINEEND.is(e)) {
                        this.text.forward(Integer.MAX_VALUE, true);
                    } else {
                        this.text.next(true);
                    }
                    this.text.endMark();
                }
                this.undo.cursor(this.text.cursor());
                this.text.delete();
            } else if (BaseXKeys.DELLINESTART.is(e) || BaseXKeys.DELPREVWORD.is(e) || BaseXKeys.DELPREV.is(e)) {
                if (nomark) {
                    if (this.text.pos() == 0) {
                        return;
                    }
                    this.text.startMark();
                    if (BaseXKeys.DELPREVWORD.is(e)) {
                        this.text.prevToken(true);
                    } else if (BaseXKeys.DELLINESTART.is(e)) {
                        this.text.bol(true);
                    } else {
                        this.text.prev();
                    }
                    this.text.endMark();
                }
                this.undo.cursor(this.text.cursor());
                this.text.delete();
                down = false;
            } else {
                consumed = false;
            }
        }
        if (consumed) {
            e.consume();
        }
        this.text.setCaret();
        if (txt != this.text.text) {
            this.rend.calc();
        }
        this.showCursor(down ? 2 : 0);
    }

    final void showCursor(int align) {
        int y;
        int m;
        int p = this.scroll.pos();
        if (p < (m = (y = this.rend.cursorY()) + this.rend.fontH() * 3 - this.getHeight()) || p > y) {
            this.scroll.pos(align == 0 ? y : (align == 1 ? y - this.getHeight() / 2 : m));
            this.rend.repaint();
        }
    }

    private void down(int l, boolean mark) {
        if (!mark) {
            this.text.noMark();
        }
        int x = this.text.bol(mark);
        if (this.lastCol == -1) {
            this.lastCol = x;
        }
        int i = 0;
        while (i < l) {
            this.text.forward(Integer.MAX_VALUE, mark);
            this.text.next(mark);
            ++i;
        }
        this.text.forward(this.lastCol, mark);
        if (this.text.pos() == this.text.size()) {
            this.lastCol = -1;
        }
    }

    private void up(int l, boolean mark) {
        if (!mark) {
            this.text.noMark();
        }
        int x = this.text.bol(mark);
        if (this.lastCol == -1) {
            this.lastCol = x;
        }
        if (this.text.pos() == 0) {
            this.lastCol = -1;
            return;
        }
        int i = 0;
        while (i < l) {
            this.text.prev(mark);
            this.text.bol(mark);
            ++i;
        }
        this.text.forward(this.lastCol, mark);
    }

    @Override
    public final void keyTyped(KeyEvent e) {
        if (this.undo == null || BaseXKeys.control(e) || BaseXKeys.DELNEXT.is(e) || BaseXKeys.DELPREV.is(e) || BaseXKeys.ESCAPE.is(e)) {
            return;
        }
        this.text.pos(this.text.cursor());
        boolean indent = false;
        if (this.text.marked()) {
            if (BaseXKeys.TAB.is(e)) {
                int s = Math.min(this.text.pos(), this.text.start());
                int l = Math.max(this.text.pos(), this.text.start()) - 1;
                int p = s;
                while (p <= l && p < this.text.size()) {
                    indent |= this.text.text[p] == 10;
                    ++p;
                }
                if (indent) {
                    this.text.indent(s, l, e.isShiftDown());
                }
            }
            if (!indent) {
                this.text.delete();
            }
        }
        if (BaseXKeys.ENTER.is(e)) {
            StringBuilder sb = new StringBuilder().append(e.getKeyChar());
            int s = 0;
            int t = 0;
            int p = this.text.pos() - 1;
            while (p >= 0) {
                byte b = this.text.text[p];
                if (b == 10) break;
                if (b == 9) {
                    ++t;
                } else if (b == 32) {
                    ++s;
                } else {
                    t = 0;
                    s = 0;
                }
                --p;
            }
            p = 0;
            while (p < t) {
                sb.append('\t');
                ++p;
            }
            p = 0;
            while (p < s) {
                sb.append(' ');
                ++p;
            }
            this.text.add(sb.toString());
        } else if (!indent) {
            this.text.add(String.valueOf(e.getKeyChar()));
        }
        this.text.setCaret();
        this.rend.calc();
        this.showCursor(2);
        e.consume();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.undo != null) {
            this.undo.store(this.text.toArray(), this.text.cursor());
        }
    }

    protected void release(boolean force) {
    }

    protected final void undo() {
        if (this.undo == null) {
            return;
        }
        this.text = new BaseXTextTokens(this.undo.prev());
        this.rend.setText(this.text);
        this.text.pos(this.undo.cursor());
        this.text.setCaret();
    }

    protected final void redo() {
        if (this.undo == null) {
            return;
        }
        this.text = new BaseXTextTokens(this.undo.next());
        this.rend.setText(this.text);
        this.text.pos(this.undo.cursor());
        this.text.setCaret();
    }

    protected final void cut() {
        this.text.pos(this.text.cursor());
        if (this.copy()) {
            this.delete();
        }
    }

    protected final boolean copy() {
        String txt = this.text.copy();
        if (txt.isEmpty()) {
            this.text.noMark();
            return false;
        }
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        clip.setContents(new StringSelection(txt), null);
        return true;
    }

    protected final boolean paste() {
        return this.paste(this.clip());
    }

    protected final boolean paste(String txt) {
        if (txt == null || this.undo == null) {
            return false;
        }
        this.text.pos(this.text.cursor());
        this.undo.cursor(this.text.cursor());
        if (this.text.marked()) {
            this.text.delete();
        }
        this.text.add(txt);
        this.undo.store(this.text.toArray(), this.text.cursor());
        return true;
    }

    protected final void delete() {
        if (this.undo == null) {
            return;
        }
        this.text.pos(this.text.cursor());
        this.undo.cursor(this.text.cursor());
        this.text.delete();
        this.undo.store(this.text.toArray(), this.text.cursor());
        this.text.setCaret();
    }

    final String clip() {
        Iterator<Object> iterator;
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable tr = clip.getContents(null);
        if (tr != null && (iterator = BaseXLayout.contents(tr).iterator()).hasNext()) {
            Object o = iterator.next();
            return o.toString();
        }
        return "";
    }

    public void finish() {
        this.text.setCaret();
        this.rend.calc();
        this.showCursor(2);
        this.release(false);
    }

    protected final void cursor(boolean start) {
        this.cursor.stop();
        if (start) {
            this.cursor.start();
        }
        this.rend.cursor(start);
        this.rend.repaint();
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent e) {
        this.scroll.pos(this.scroll.pos() + e.getUnitsToScroll() * 20);
        this.rend.repaint();
    }

    @Override
    public final void componentResized(ComponentEvent e) {
        this.scroll.pos(0);
        SwingUtilities.invokeLater(this.calc);
    }

    class AllCmd
    extends TextCmd {
        AllCmd() {
        }

        @Override
        public void execute(GUI main) {
            BaseXEditor.this.selectAll();
        }

        @Override
        public void refresh(GUI main, AbstractButton button) {
        }

        @Override
        public String label() {
            return Text.GUIALL;
        }
    }

    class CopyCmd
    extends TextCmd {
        CopyCmd() {
        }

        @Override
        public void execute(GUI main) {
            BaseXEditor.this.copy();
        }

        @Override
        public void refresh(GUI main, AbstractButton button) {
            button.setEnabled(BaseXEditor.this.text.marked());
        }

        @Override
        public String label() {
            return Text.GUICOPY;
        }
    }

    class CutCmd
    extends TextCmd {
        CutCmd() {
        }

        @Override
        public void execute(GUI main) {
            BaseXEditor.this.cut();
            BaseXEditor.this.finish();
        }

        @Override
        public void refresh(GUI main, AbstractButton button) {
            button.setEnabled(BaseXEditor.this.text.marked());
        }

        @Override
        public String label() {
            return Text.GUICUT;
        }
    }

    class DelCmd
    extends TextCmd {
        DelCmd() {
        }

        @Override
        public void execute(GUI main) {
            BaseXEditor.this.delete();
            BaseXEditor.this.finish();
        }

        @Override
        public void refresh(GUI main, AbstractButton button) {
            button.setEnabled(BaseXEditor.this.text.marked());
        }

        @Override
        public String label() {
            return Text.GUIDELETE;
        }
    }

    class PasteCmd
    extends TextCmd {
        PasteCmd() {
        }

        @Override
        public void execute(GUI main) {
            if (BaseXEditor.this.paste()) {
                BaseXEditor.this.finish();
            }
        }

        @Override
        public void refresh(GUI main, AbstractButton button) {
            button.setEnabled(BaseXEditor.this.clip() != null);
        }

        @Override
        public String label() {
            return Text.GUIPASTE;
        }
    }

    class RedoCmd
    extends TextCmd {
        RedoCmd() {
        }

        @Override
        public void execute(GUI main) {
            BaseXEditor.this.redo();
            BaseXEditor.this.finish();
        }

        @Override
        public void refresh(GUI main, AbstractButton button) {
            button.setEnabled(!BaseXEditor.this.undo.last());
        }

        @Override
        public String label() {
            return Text.GUIREDO;
        }
    }

    abstract class TextCmd
    implements GUICommand {
        TextCmd() {
        }

        @Override
        public boolean checked() {
            return false;
        }

        @Override
        public String help() {
            return null;
        }

        @Override
        public String key() {
            return null;
        }
    }

    class UndoCmd
    extends TextCmd {
        UndoCmd() {
        }

        @Override
        public void execute(GUI main) {
            BaseXEditor.this.undo();
            BaseXEditor.this.finish();
        }

        @Override
        public void refresh(GUI main, AbstractButton button) {
            button.setEnabled(!BaseXEditor.this.undo.first());
        }

        @Override
        public String label() {
            return Text.GUIUNDO;
        }
    }
}

