/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseEvent;
import org.basex.core.Text;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.util.Performance;

public final class BaseXMem
extends BaseXPanel {
    private static final int DWIDTH = 70;

    public BaseXMem(Window win, boolean mouse) {
        super(win);
        BaseXLayout.setWidth(this, 70);
        BaseXLayout.setHeight(this, this.getFont().getSize() + 6);
        if (mouse) {
            this.setCursor(GUIConstants.CURSORHAND);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Runtime rt = Runtime.getRuntime();
        long max = rt.maxMemory();
        long used = rt.totalMemory() - rt.freeMemory();
        int ww = this.getWidth();
        int hh = this.getHeight();
        g.setColor(Color.white);
        g.fillRect(0, 0, ww - 3, hh - 3);
        g.setColor(GUIConstants.GRAY);
        g.drawLine(0, 0, ww - 4, 0);
        g.drawLine(0, 0, 0, hh - 4);
        g.drawLine(ww - 3, 0, ww - 3, hh - 3);
        g.drawLine(0, hh - 3, ww - 3, hh - 3);
        boolean full = used * 6L / 5L > max;
        g.setColor(full ? GUIConstants.colormark4 : GUIConstants.color2);
        g.fillRect(2, 2, Math.max(1, (int)(used * (long)(ww - 6) / max)), hh - 6);
        FontMetrics fm = g.getFontMetrics();
        String mem = Performance.format(used, true);
        int fw = (ww - fm.stringWidth(mem)) / 2;
        int h = fm.getHeight() - 3;
        g.setColor(full ? GUIConstants.colormark3 : GUIConstants.DGRAY);
        g.drawString(mem, fw, h);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Performance.gc(3);
        this.repaint();
        Runtime rt = Runtime.getRuntime();
        long occ = rt.totalMemory();
        long max = rt.maxMemory();
        long used = occ - rt.freeMemory();
        String inf = String.valueOf(Text.MEMTOTAL) + Performance.format(max, true) + Text.NL + Text.MEMRESERVED + Performance.format(occ, true) + Text.NL + Text.MEMUSED + Performance.format(used, true) + Text.NL + Text.NL + Text.MEMHELP;
        Dialog.info(this.gui, inf);
    }
}

