/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Box;
import org.basex.core.Command;
import org.basex.core.Text;
import org.basex.data.Nodes;
import org.basex.gui.GUICommands;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.layout.XMLSyntax;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.util.Token;
import org.basex.util.Util;

public final class TextView
extends View
implements ActionListener {
    private final BaseXTextField find;
    private final BaseXLabel header;
    private final BaseXButton home;
    private final BaseXEditor area;
    private Command cmd;
    private Nodes ns;
    private boolean refresh;

    public TextView(ViewNotifier man) {
        super("text", Text.HELPTEXT, man);
        this.border(6, 6, 6, 6).layout(new BorderLayout(0, 4)).setFocusable(false);
        BaseXBack b = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout());
        this.home = BaseXButton.command(GUICommands.HOME, this.gui);
        this.home.setEnabled(false);
        BaseXBack sp = new BaseXBack(GUIConstants.Fill.NONE).layout(new TableLayout(1, 2));
        sp.add(this.home);
        sp.add(Box.createHorizontalStrut(8));
        b.add((Component)sp, "West");
        this.header = new BaseXLabel(Text.TEXTTIT, true, false);
        b.add((Component)this.header, "Center");
        BaseXButton save = new BaseXButton(this.gui, "save", Text.HELPSAVE);
        save.addActionListener(this);
        this.find = new BaseXTextField(this.gui);
        BaseXLayout.setHeight(this.find, (int)save.getPreferredSize().getHeight());
        sp = new BaseXBack(GUIConstants.Fill.NONE).layout(new TableLayout(1, 3));
        sp.add(this.find);
        sp.add(Box.createHorizontalStrut(5));
        sp.add(save);
        b.add((Component)sp, "East");
        this.add((Component)b, "North");
        this.area = new BaseXEditor(false, (Window)this.gui);
        this.area.setSyntax(new XMLSyntax());
        this.area.setSearch(this.find);
        this.add((Component)this.area, "Center");
        this.refreshLayout();
    }

    @Override
    public void refreshInit() {
        this.refreshContext(true, true);
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
        if (this.refresh) {
            this.refresh = false;
        } else {
            this.setText(this.gui.context.marked);
        }
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
        this.setText(this.gui.context.current());
    }

    @Override
    public void refreshLayout() {
        this.header.setFont(GUIConstants.lfont);
        this.area.setFont(GUIConstants.mfont);
    }

    @Override
    public void refreshUpdate() {
        this.refreshContext(true, true);
    }

    @Override
    public boolean visible() {
        return this.gui.gprop.is(GUIProp.SHOWTEXT);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gprop.set(GUIProp.SHOWTEXT, v);
    }

    @Override
    protected boolean db() {
        return false;
    }

    private void setText(Nodes n) {
        this.ns = n;
        if (!this.visible()) {
            return;
        }
        try {
            ArrayOutput ao = new ArrayOutput().max(this.gui.gprop.num(GUIProp.MAXTEXT));
            if (n != null) {
                n.serialize(Serializer.get(ao));
            }
            this.setText(ao, null);
            this.refresh = false;
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
    }

    public void setText(ArrayOutput out, Command c) {
        byte[] buf = out.buffer();
        int size = out.size();
        byte[] chop = Token.token("...");
        if (out.finished() && size >= chop.length) {
            System.arraycopy(chop, 0, buf, size - chop.length, chop.length);
        }
        this.area.setText(buf, size);
        this.header.setText(String.valueOf(Text.TEXTTIT) + (out.finished() ? Text.RESULTCHOP : ""));
        this.home.setEnabled(this.gui.context.data() != null);
        this.refresh = true;
        if (!out.finished()) {
            this.cmd = null;
            this.ns = null;
        } else {
            this.cmd = c;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block19: {
            BaseXFileChooser fc = new BaseXFileChooser(Text.GUISAVEAS, this.gui.gprop.get(GUIProp.SAVEPATH), this.gui);
            IOFile file = fc.select(BaseXFileChooser.Mode.FSAVE);
            if (file == null) {
                return;
            }
            this.gui.gprop.set(GUIProp.SAVEPATH, file.path());
            PrintOutput out = null;
            try {
                try {
                    out = new PrintOutput(file.toString());
                    if (this.cmd != null) {
                        this.cmd.execute(this.gui.context, out);
                    } else if (this.ns != null) {
                        this.ns.serialize(Serializer.get(out));
                    } else {
                        byte[] txt;
                        byte[] byArray = txt = this.area.getText();
                        int n = txt.length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte t = byArray[n2];
                            if (t < 0 || t > 32 || Token.ws(t)) {
                                out.write(t);
                            }
                            ++n2;
                        }
                    }
                }
                catch (IOException ex) {
                    Dialog.error(this.gui, Text.NOTSAVED);
                    if (out == null) break block19;
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

