/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import java.io.IOException;
import org.basex.core.BaseXException;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.index.IndexBuilder;
import org.basex.index.ft.FTFuzzyBuilder;
import org.basex.index.ft.FTList;
import org.basex.index.ft.FTTrieBuilder;
import org.basex.io.out.DataOutput;
import org.basex.util.Num;
import org.basex.util.Performance;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.Language;
import org.basex.util.ft.Scoring;
import org.basex.util.ft.Stemmer;
import org.basex.util.ft.StopWords;
import org.basex.util.ft.Tokenizer;
import org.basex.util.list.IntList;

public abstract class FTBuilder
extends IndexBuilder {
    protected final FTLexer lex;
    protected int pos;
    protected final int scm;
    protected long ntok;
    private final IntList unit = new IntList();
    private final IntList freq = new IntList();
    private int[] maxfreq;
    private int[] ntoken;
    private int max;
    private int min;
    private int token;
    private int fc;

    public static FTBuilder get(Data d) throws IOException {
        return d.meta.wildcards ? new FTTrieBuilder(d) : new FTFuzzyBuilder(d);
    }

    protected FTBuilder(Data d) throws IOException {
        super(d);
        Prop prop = d.meta.prop;
        FTOpt fto = new FTOpt();
        fto.set(FTFlag.DC, prop.is(Prop.DIACRITICS));
        fto.set(FTFlag.CS, prop.is(Prop.CASESENS));
        fto.set(FTFlag.ST, prop.is(Prop.STEMMING));
        fto.sw = new StopWords(d, prop.get(Prop.STOPWORDS));
        fto.ln = Language.get(prop);
        if (!Tokenizer.supportFor(fto.ln)) {
            throw new BaseXException(Text.NOTOK, fto.ln);
        }
        if (prop.is(Prop.STEMMING) && !Stemmer.supportFor(fto.ln)) {
            throw new BaseXException(Text.NOSTEM, fto.ln);
        }
        this.scm = d.meta.scoring;
        this.max = -1;
        this.min = Integer.MAX_VALUE;
        this.lex = new FTLexer(fto);
    }

    protected final void index() throws IOException {
        this.abort();
        Performance perf = Util.debug ? new Performance() : null;
        Util.debug(this.det(), new Object[0]);
        this.pre = 0;
        while (this.pre < this.size) {
            int k;
            if ((this.pre & 0xFFFF) == 0) {
                this.check();
            }
            if ((k = this.data.kind(this.pre)) != 2) {
                if (this.scm == 1 && k == 0) {
                    this.unit.add(this.pre);
                }
            } else {
                if (this.scm == 2) {
                    this.unit.add(this.pre);
                }
                this.pos = -1;
                StopWords sw = this.lex.ftOpt().sw;
                this.lex.init(this.data.text(this.pre, true));
                while (this.lex.hasNext()) {
                    byte[] tok = this.lex.nextToken();
                    ++this.pos;
                    if (tok.length > 96 || sw.size() != 0 && sw.id(tok) != 0) continue;
                    if ((this.ntok++ & 0xFFFL) == 0L && this.scm == 0 && this.memFull()) {
                        this.writeIndex(this.csize++);
                        Performance.gc(2);
                    }
                    this.index(tok);
                }
            }
            ++this.pre;
        }
        if (this.scm > 0) {
            this.maxfreq = new int[this.unit.size() + 1];
            this.ntoken = new int[this.nrTokens()];
            this.token = 0;
            this.calcFreq();
        }
        this.token = 0;
        this.write();
        if (this.scm > 0) {
            this.data.meta.maxscore = this.max;
            this.data.meta.minscore = this.min;
        }
        this.data.meta.ftindex = true;
        Util.gc(perf);
    }

    protected final void calcFreq(byte[] vpre) {
        int np = 4;
        int nl = Num.length(vpre, np);
        int p = Num.get(vpre, np);
        int ns = Num.size(vpre);
        while (np < ns) {
            int u = this.unit.sortedIndexOf(p);
            if (u < 0) {
                u = -u - 1;
            }
            int fr = 0;
            do {
                ++fr;
                if ((np += nl) >= ns) break;
                p = Num.get(vpre, np);
                nl = Num.length(vpre, np);
            } while (this.scm == 1 && (u == this.unit.size() || p < this.unit.get(u)) || this.scm == 2 && p == this.unit.get(u));
            this.freq.add(fr);
            if (this.maxfreq[u] < fr) {
                this.maxfreq[u] = fr;
            }
            int n = this.token;
            this.ntoken[n] = this.ntoken[n] + 1;
        }
        ++this.token;
    }

    protected abstract void writeIndex(int var1) throws IOException;

    protected final int merge(DataOutput out, IntList il, FTList[] v) throws IOException {
        int s = 0;
        TokenBuilder tbp = new TokenBuilder();
        TokenBuilder tbo = new TokenBuilder();
        tbp.add(new byte[4]);
        tbo.add(new byte[4]);
        int j = 0;
        while (j < il.size()) {
            int p;
            int m = il.get(j);
            int[] nArray = v[m].prv;
            int n = v[m].prv.length;
            int n2 = 0;
            while (n2 < n) {
                p = nArray[n2];
                tbp.add(Num.num(p));
                ++n2;
            }
            nArray = v[m].pov;
            n = v[m].pov.length;
            n2 = 0;
            while (n2 < n) {
                p = nArray[n2];
                tbo.add(Num.num(p));
                ++n2;
            }
            s += v[m].size;
            v[m].next();
            ++j;
        }
        byte[] pr = tbp.finish();
        Num.size(pr, pr.length);
        byte[] po = tbo.finish();
        Num.size(po, po.length);
        this.writeFTData(out, pr, po);
        return s;
    }

    protected final void writeFTData(DataOutput out, byte[] vpre, byte[] vpos) throws IOException {
        int np = 4;
        int pp = 4;
        int lp = -1;
        int lu = -1;
        int ns = Num.size(vpre);
        while (np < ns) {
            int p;
            if (this.scm > 0 && lp != (p = Num.get(vpre, np))) {
                int u = this.unit.sortedIndexOf(p);
                if (u < 0) {
                    u = -u - 1;
                }
                if (lu != u) {
                    int s;
                    if (this.max < (s = Scoring.tfIDF(this.freq.get(this.fc++), this.maxfreq[u], this.unit.size(), this.ntoken[this.token]))) {
                        this.max = s;
                    }
                    if (this.min > s) {
                        this.min = s;
                    }
                    if (np != 4) {
                        out.write(0);
                    }
                    out.writeNum(s);
                    lu = u;
                }
                lp = p;
            }
            int l = np + Num.length(vpre, np);
            while (np < l) {
                out.write(vpre[np]);
                ++np;
            }
            l = pp + Num.length(vpos, pp);
            while (pp < l) {
                out.write(vpos[pp]);
                ++pp;
            }
        }
        ++this.token;
    }

    protected final boolean check(FTList[] lists) {
        FTList[] fTListArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            FTList l = fTListArray[n2];
            if (l.tok.length > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    abstract void index(byte[] var1) throws IOException;

    abstract int nrTokens();

    abstract void calcFreq();

    abstract void write() throws IOException;

    @Override
    public final void abort() {
        this.data.meta.drop("ftx.*");
        this.data.meta.ftindex = false;
    }

    @Override
    public final String det() {
        return Text.INDEXFTX;
    }
}

