/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import java.io.IOException;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.index.IndexIterator;
import org.basex.index.IndexStats;
import org.basex.index.IndexToken;
import org.basex.index.ft.FTIndex;
import org.basex.index.ft.FTIndexIterator;
import org.basex.io.random.DataAccess;
import org.basex.util.Levenshtein;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;

final class FTFuzzy
extends FTIndex {
    private static final int ENTRY = 9;
    private final int[] tp = new int[99];
    private final Levenshtein ls = new Levenshtein();
    private final DataAccess inX;
    private final DataAccess inY;
    private final DataAccess inZ;

    protected FTFuzzy(Data d) throws IOException {
        super(d);
        this.inY = new DataAccess(d.meta.dbfile("ftxy"));
        this.inZ = new DataAccess(d.meta.dbfile("ftxz"));
        this.inX = new DataAccess(d.meta.dbfile("ftxx"));
        int i = 0;
        while (i < this.tp.length) {
            this.tp[i] = -1;
            ++i;
        }
        int is = this.inX.read1();
        while (--is >= 0) {
            byte p = this.inX.read1();
            this.tp[p] = this.inX.read4();
        }
        this.tp[this.tp.length - 1] = (int)this.inY.length();
    }

    @Override
    public synchronized int count(IndexToken ind) {
        if (ind.get().length > 96) {
            return Integer.MAX_VALUE;
        }
        FTLexer lex = (FTLexer)ind;
        if (lex.ftOpt().is(FTFlag.FZ)) {
            return Math.max(1, this.data.meta.size / 10);
        }
        byte[] tok = lex.get();
        int id = this.cache.id(tok);
        if (id > 0) {
            return this.cache.size(id);
        }
        int s = 0;
        long poi = 0L;
        long p = this.token(tok);
        if (p > -1L) {
            s = this.size(p, tok.length);
            poi = this.pointer(p, tok.length);
        }
        this.cache.add(tok, s, poi);
        return s;
    }

    @Override
    public synchronized IndexIterator iter(IndexToken ind) {
        byte[] tok = ind.get();
        if (((FTLexer)ind).ftOpt().is(FTFlag.FZ)) {
            int k = this.data.meta.prop.num(Prop.LSERROR);
            if (k == 0) {
                k = tok.length >> 2;
            }
            return this.fuzzy(tok, k, false);
        }
        int id = this.cache.id(tok);
        if (id == 0) {
            int p = this.token(tok);
            return p > -1 ? this.iter(this.pointer(p, tok.length), this.size(p, tok.length), this.inZ, false) : FTIndexIterator.FTEMPTY;
        }
        return this.iter(this.cache.pointer(id), this.cache.size(id), this.inZ, false);
    }

    @Override
    public byte[] info() {
        TokenBuilder tb = new TokenBuilder();
        tb.add("- Structure: Fuzzy" + Text.NL);
        tb.addExt("- %: %" + Text.NL, Text.CREATEST, Util.flag(this.data.meta.stemming));
        tb.addExt("- %: %" + Text.NL, Text.CREATECS, Util.flag(this.data.meta.casesens));
        tb.addExt("- %: %" + Text.NL, Text.CREATEDC, Util.flag(this.data.meta.diacritics));
        if (this.data.meta.language != null) {
            tb.addExt("- %: %" + Text.NL, Text.CREATELN, this.data.meta.language);
        }
        long l = this.inX.length() + this.inY.length() + this.inZ.length();
        tb.add("- Size: " + Performance.format(l, true) + Text.NL);
        IndexStats stats = new IndexStats(this.data);
        this.addOccs(stats);
        stats.print(tb);
        return tb.finish();
    }

    @Override
    public synchronized void close() throws IOException {
        this.inX.close();
        this.inY.close();
        this.inZ.close();
    }

    private int token(byte[] tok) {
        int r;
        int tl = tok.length;
        int l = this.tp[tl];
        if (l == -1) {
            return -1;
        }
        int i = 1;
        while ((r = this.tp[tl + i++]) == -1) {
        }
        int x = r;
        int o = tl + 9;
        while (l < r) {
            int m = l + (r - l >> 1) / o * o;
            int c = Token.diff(this.inY.readBytes(m, tl), tok);
            if (c == 0) {
                return m;
            }
            if (c < 0) {
                l = m + o;
                continue;
            }
            r = m - o;
        }
        return r != x && l == r && Token.eq(this.inY.readBytes(l, tl), tok) ? l : -1;
    }

    private void addOccs(IndexStats stats) {
        int i = 0;
        while (i < this.tp.length && this.tp[i] == -1) {
            ++i;
        }
        int p = this.tp[i];
        int j = i + 1;
        while (j < this.tp.length && this.tp[j] == -1) {
            ++j;
        }
        while (p < this.tp[this.tp.length - 1]) {
            if (stats.adding(this.size(p, i))) {
                stats.add(this.inY.readBytes(p, i));
            }
            if ((p += i + 9) != this.tp[j]) continue;
            i = j;
            while (j + 1 < this.tp.length && this.tp[++j] == -1) {
            }
        }
    }

    private long pointer(long pt, int lt) {
        return this.inY.read5(pt + (long)lt);
    }

    private int size(long pt, int lt) {
        return this.inY.read4(pt + (long)lt + 5L);
    }

    private IndexIterator fuzzy(byte[] tok, int k, boolean f) {
        FTIndexIterator it = FTIndexIterator.FTEMPTY;
        int tl = tok.length;
        int e = Math.min(this.tp.length, tl + k);
        int s = Math.max(1, tl - k) - 1;
        int err = this.data.meta.prop.num(Prop.LSERROR);
        while (++s <= e) {
            int p = this.tp[s];
            if (p == -1) continue;
            int i = s + 1;
            int r = -1;
            while ((r = this.tp[i++]) == -1) {
            }
            while (p < r) {
                if (this.ls.similar(this.inY.readBytes(p, s), tok, err)) {
                    it = FTIndexIterator.union(this.iter(this.pointer(p, s), this.size(p, s), this.inZ, f), it);
                }
                p += s + 9;
            }
        }
        return it;
    }
}

