/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import java.io.File;
import java.io.IOException;
import org.basex.data.Data;
import org.basex.index.ft.FTList;
import org.basex.io.random.DataAccess;
import org.basex.util.Token;

final class FTFuzzyList
extends FTList {
    private final File sizes;
    private final int[] tp = new int[99];
    private int ctl;
    private int ntl;
    private int ptok;

    protected FTFuzzyList(Data d, int cf) throws IOException {
        super(d, cf, 'y', 'z');
        int i = 0;
        while (i < this.tp.length) {
            this.tp[i] = -1;
            ++i;
        }
        this.sizes = d.meta.dbfile("ftx" + cf + 'x');
        DataAccess li = new DataAccess(this.sizes);
        int is = li.read1();
        while (--is >= 0) {
            byte p = li.read1();
            this.tp[p] = li.read4();
        }
        this.tp[this.tp.length - 1] = (int)this.str.length();
        li.close();
        this.next();
    }

    @Override
    void close() throws IOException {
        super.close();
        this.sizes.delete();
    }

    @Override
    protected byte[] token() {
        if (this.tp[this.tp.length - 1] == this.ptok) {
            return Token.EMPTY;
        }
        if (this.tp[this.ntl] == this.ptok || this.ntl == 0) {
            ++this.ctl;
            while (this.tp[this.ctl] == -1) {
                ++this.ctl;
            }
            this.ntl = this.ctl + 1;
            while (this.tp[this.ntl] == -1) {
                ++this.ntl;
            }
        }
        if (this.ctl == this.tp.length) {
            return Token.EMPTY;
        }
        byte[] t = this.str.readBytes(this.ptok, this.ctl);
        this.size = this.str.read4(this.str.cursor() + 5L);
        this.ptok = (int)this.str.cursor();
        return t;
    }
}

