/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.path;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.index.Index;
import org.basex.index.IndexIterator;
import org.basex.index.IndexToken;
import org.basex.index.path.PathNode;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.io.serial.Serializer;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.ObjList;
import org.basex.util.list.TokenList;

public final class PathSummary
implements Index {
    private final ObjList<PathNode> stack = new ObjList();
    private Data data;
    private PathNode root;

    public PathSummary(Data d) {
        this.data = d;
    }

    public PathSummary(Data d, DataInput in) throws IOException {
        if (in.readBool()) {
            this.root = new PathNode(in, null);
        }
        this.data = d;
    }

    public void write(DataOutput out) throws IOException {
        out.writeBool(this.root != null);
        if (this.root != null) {
            this.root.write(out);
        }
    }

    public void finish(Data d) {
        this.data = d;
    }

    @Override
    public void close() {
        this.root = null;
    }

    public void index(int n, byte k, int l) {
        if (this.root == null) {
            this.root = new PathNode(n, k, null);
            this.stack.add(this.root);
        } else {
            this.stack.set(l, this.stack.get(l - 1).index(n, k));
        }
    }

    public ObjList<PathNode> root() {
        ObjList<PathNode> out = new ObjList<PathNode>();
        out.add(this.root);
        return out;
    }

    public ObjList<PathNode> parent(ObjList<PathNode> in) {
        ObjList<PathNode> out = new ObjList<PathNode>();
        for (PathNode n : in) {
            if (out.contains(n.par)) continue;
            out.add(n.par);
        }
        return out;
    }

    public ObjList<PathNode> desc(ObjList<PathNode> in, boolean desc) {
        ObjList<PathNode> out = new ObjList<PathNode>();
        for (PathNode n : in) {
            PathNode[] pathNodeArray = n.ch;
            int n2 = n.ch.length;
            int n3 = 0;
            while (n3 < n2) {
                PathNode c = pathNodeArray[n3];
                if (desc) {
                    c.addDesc(out);
                } else if (!out.contains(c)) {
                    out.add(c);
                }
                ++n3;
            }
        }
        return out;
    }

    public ObjList<PathNode> desc(int n, int k) {
        ObjList<PathNode> out = new ObjList<PathNode>();
        PathNode[] pathNodeArray = this.root.ch;
        int n2 = this.root.ch.length;
        int n3 = 0;
        while (n3 < n2) {
            PathNode c = pathNodeArray[n3];
            c.addDesc(out, n, k);
            ++n3;
        }
        return out;
    }

    public TokenList desc(byte[] k, boolean d, boolean o) {
        TokenList tl = new TokenList();
        if (k.length != 0) {
            tl.add(k);
        }
        return this.desc(tl, d, o);
    }

    public TokenList desc(TokenList tl, boolean d, boolean o) {
        ObjList<PathNode> in = this.desc(this.root(), true);
        for (byte[] i : tl) {
            boolean att = Token.startsWith(i, 64);
            byte kind = att ? (byte)3 : 1;
            int id = att ? this.data.atnindex.id(Token.substring(i, 1)) : this.data.tagindex.id(i);
            ObjList<PathNode> out = new ObjList<PathNode>();
            for (PathNode n : in) {
                if (n.name != id || n.kind != kind) continue;
                PathNode[] pathNodeArray = n.ch;
                int n2 = n.ch.length;
                int n3 = 0;
                while (n3 < n2) {
                    PathNode c = pathNodeArray[n3];
                    if (d) {
                        c.addDesc(out);
                    } else {
                        out.add(c);
                    }
                    ++n3;
                }
            }
            in = out;
        }
        double[] tmp = new double[in.size()];
        int i = 0;
        while (i < in.size()) {
            tmp[i] = in.get((int)i).size;
            ++i;
        }
        int[] occ = Array.createOrder(tmp, false);
        TokenList out = new TokenList();
        int i2 = 0;
        while (i2 < in.size()) {
            PathNode r = in.get(o ? occ[i2] : i2);
            byte[] name = r.token(this.data);
            if (name.length != 0 && !out.contains(name) && !Token.contains(name, 40)) {
                out.add(name);
            }
            ++i2;
        }
        if (!o) {
            out.sort(false);
        }
        return out;
    }

    public void add(PathNode in, ObjList<PathNode> out, int t, int k, boolean desc) {
        PathNode[] pathNodeArray = in.ch;
        int n = in.ch.length;
        int n2 = 0;
        while (n2 < n) {
            PathNode n3 = pathNodeArray[n2];
            if (desc) {
                this.add(n3, out, t, k, desc);
            }
            if (k == -1 && n3.kind != 3 || k == n3.kind && (t == 0 || t == n3.name)) {
                out.add(n3);
            }
            ++n2;
        }
    }

    @Override
    public byte[] info() {
        return this.root != null ? Token.chop(this.root.info(this.data, 0), 0x100000) : Token.EMPTY;
    }

    public void plan(Serializer ser) throws IOException {
        ser.openElement(DataText.PATH, (byte[][])new byte[0][]);
        this.root.plan(this.data, ser);
        ser.closeElement();
    }

    @Override
    public IndexIterator iter(IndexToken token) {
        throw Util.notexpected(new Object[0]);
    }

    @Override
    public int count(IndexToken token) {
        throw Util.notexpected(new Object[0]);
    }
}

