/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.util.Arrays;
import org.basex.index.Index;
import org.basex.index.IndexIterator;
import org.basex.index.IndexToken;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;

public final class MemValues
extends TokenSet
implements Index {
    int[][] ids = new int[8][];
    int[] len = new int[8];

    public int index(byte[] key, int id) {
        int i = this.add(key);
        if (i > 0) {
            this.ids[i] = new int[]{id};
        } else {
            int l = this.len[i = -i];
            if (l == this.ids[i].length) {
                this.ids[i] = Arrays.copyOf(this.ids[i], l << 1);
            }
            this.ids[i][l] = id;
        }
        int n = i;
        this.len[n] = this.len[n] + 1;
        return i;
    }

    @Override
    public IndexIterator iter(IndexToken tok) {
        final int i = this.id(tok.get());
        if (i == 0) {
            return IndexIterator.EMPTY;
        }
        return new IndexIterator(){
            int p = -1;

            @Override
            public boolean more() {
                return ++this.p < MemValues.this.len[i];
            }

            @Override
            public int next() {
                return MemValues.this.ids[i][this.p];
            }

            @Override
            public double score() {
                return -1.0;
            }

            @Override
            public int size() {
                return MemValues.this.len[i];
            }
        };
    }

    @Override
    public int count(IndexToken it) {
        int i = this.id(it.get());
        return i == 0 ? 0 : this.len[i];
    }

    @Override
    public byte[] info() {
        return Token.token(Util.name(this));
    }

    @Override
    public void close() {
    }

    @Override
    public void rehash() {
        super.rehash();
        int s = this.size << 1;
        this.ids = Array.copyOf(this.ids, s);
        this.len = Arrays.copyOf(this.len, s);
    }
}

