/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.io.IOException;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.index.IndexBuilder;
import org.basex.index.IndexTree;
import org.basex.index.value.DiskValues;
import org.basex.index.value.ValueMerger;
import org.basex.io.out.DataOutput;
import org.basex.io.random.DataAccess;
import org.basex.util.Num;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class ValueBuilder
extends IndexBuilder {
    private IndexTree index = new IndexTree();
    private final boolean text;

    public ValueBuilder(Data d, boolean txt) {
        super(d);
        this.text = txt;
    }

    @Override
    public DiskValues build() throws IOException {
        this.abort();
        Performance perf = Util.debug ? new Performance() : null;
        Util.debug(this.det(), new Object[0]);
        String f = this.text ? "txt" : "atv";
        int k = this.text ? 2 : 3;
        this.pre = 0;
        while (this.pre < this.size) {
            if ((this.pre & 0xFFF) == 0) {
                this.check();
                if (this.memFull()) {
                    this.write(String.valueOf(f) + this.csize++, false);
                    this.index = new IndexTree();
                    Performance.gc(2);
                }
            }
            if (this.data.kind(this.pre) == k && this.data.textLen(this.pre, this.text) <= 96) {
                this.index.index(this.data.text(this.pre, this.text), this.pre);
            }
            ++this.pre;
        }
        if (this.merge) {
            this.write(String.valueOf(f) + this.csize++, false);
            this.index = null;
            Performance.gc(1);
            this.merge();
        } else {
            this.write(f, true);
        }
        if (this.text) {
            this.data.meta.textindex = true;
        } else {
            this.data.meta.attrindex = true;
        }
        Util.gc(perf);
        return new DiskValues(this.data, this.text);
    }

    private void merge() throws IOException {
        String f = this.text ? "txt" : "atv";
        DataOutput outL = new DataOutput(this.data.meta.dbfile(String.valueOf(f) + 'l'));
        DataOutput outR = new DataOutput(this.data.meta.dbfile(String.valueOf(f) + 'r'));
        outL.write4(0);
        IntList ml = new IntList();
        IntList il = new IntList();
        ValueMerger[] vm = new ValueMerger[this.csize];
        int i = 0;
        while (i < this.csize) {
            vm[i] = new ValueMerger(this.data, this.text, i);
            ++i;
        }
        int sz = 0;
        while (true) {
            this.checkStop();
            int min = -1;
            while (++min < this.csize && vm[min].values.length == 0) {
            }
            if (min == this.csize) break;
            ml.reset();
            int i2 = min;
            while (i2 < this.csize) {
                int d;
                if (vm[i2].values.length != 0 && (d = Token.diff(vm[min].key, vm[i2].key)) >= 0) {
                    if (d > 0) {
                        min = i2;
                        ml.reset();
                    }
                    ml.add(i2);
                }
                ++i2;
            }
            int ms = ml.size();
            int m = 0;
            while (m < ms) {
                ValueMerger t = vm[ml.get(m)];
                int vl = t.values.length;
                int l = 4;
                while (l < vl) {
                    int v = Num.get(t.values, l);
                    il.add(v);
                    l += Num.length(v);
                }
                t.next();
                ++m;
            }
            this.write(outL, outR, il);
            ++sz;
        }
        outR.close();
        outL.close();
        DataAccess da = new DataAccess(this.data.meta.dbfile(String.valueOf(f) + 'l'));
        da.write4(sz);
        da.close();
    }

    private void write(String name, boolean all) throws IOException {
        DataOutput outL = new DataOutput(this.data.meta.dbfile(String.valueOf(name) + 'l'));
        DataOutput outR = new DataOutput(this.data.meta.dbfile(String.valueOf(name) + 'r'));
        outL.write4(this.index.size());
        IntList il = new IntList();
        this.index.init();
        while (this.index.more()) {
            byte[] values = this.index.values.get(this.index.next());
            int vs = Num.size(values);
            if (all) {
                int ip = 4;
                while (ip < vs) {
                    il.add(Num.get(values, ip));
                    ip += Num.length(values, ip);
                }
                this.write(outL, outR, il);
                continue;
            }
            outR.write5(outL.size());
            outL.write(values, 0, vs);
        }
        outL.close();
        outR.close();
        if (!all) {
            DataOutput outT = new DataOutput(this.data.meta.dbfile(String.valueOf(name) + 't'));
            this.index.init();
            while (this.index.more()) {
                outT.writeToken(this.index.keys.get(this.index.next()));
            }
            outT.close();
        }
    }

    private void write(DataOutput outL, DataOutput outR, IntList il) throws IOException {
        il.sort();
        int is = il.size();
        outR.write5(outL.size());
        outL.writeNum(is);
        int i = 0;
        int o = 0;
        while (i < is) {
            int v = il.get(i);
            outL.writeNum(v - o);
            o = v;
            ++i;
        }
        il.reset();
    }

    @Override
    public void abort() {
        this.data.meta.drop(String.valueOf(this.text ? "txt" : "atv") + ".+");
        if (this.text) {
            this.data.meta.textindex = false;
        } else {
            this.data.meta.attrindex = false;
        }
    }

    @Override
    public String det() {
        return this.text ? Text.INDEXTXT : Text.INDEXATT;
    }
}

