/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.util.Arrays;
import org.basex.io.out.PrintOutput;
import org.basex.util.Token;

public final class ArrayOutput
extends PrintOutput {
    private byte[] buf = new byte[8];

    public ArrayOutput max(int m) {
        this.max = m;
        return this;
    }

    @Override
    public void write(int b) {
        if (this.size == this.max) {
            return;
        }
        if (this.size == this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, this.size << 1);
        }
        this.buf[this.size++] = (byte)b;
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.buf, this.size);
    }

    @Override
    public boolean finished() {
        return this.size == this.max;
    }

    public byte[] buffer() {
        return this.buf;
    }

    public void reset() {
        this.size = 0;
    }

    public String toString() {
        return Token.string(this.buf, 0, this.size);
    }
}

