/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.Prop;
import org.basex.io.out.ArrayOutput;
import org.basex.io.out.BufferOutput;
import org.basex.util.Token;

public class PrintOutput
extends OutputStream {
    private final OutputStream os;
    protected int max = Integer.MAX_VALUE;
    protected int size;

    protected PrintOutput() {
        this((OutputStream)null);
    }

    public PrintOutput(String fn) throws IOException {
        this(new BufferOutput(new FileOutputStream(fn)));
    }

    private PrintOutput(OutputStream out) {
        this.os = out;
    }

    public static PrintOutput get(OutputStream out) {
        return out instanceof PrintOutput ? (PrintOutput)out : new PrintOutput(out instanceof ByteArrayOutputStream || out instanceof BufferedOutputStream || out instanceof BufferOutput || out instanceof ArrayOutput ? out : new BufferOutput(out));
    }

    @Override
    public void write(int b) throws IOException {
        if (this.size++ < this.max && this.os != null) {
            this.os.write(b);
        }
    }

    public void utf8(int ch) throws IOException {
        if (ch <= 127) {
            this.write(ch);
        } else if (ch <= 2047) {
            this.write(ch >> 6 & 0x1F | 0xC0);
            this.write(ch >> 0 & 0x3F | 0x80);
        } else if (ch <= 65535) {
            this.write(ch >> 12 & 0xF | 0xE0);
            this.write(ch >> 6 & 0x3F | 0x80);
            this.write(ch >> 0 & 0x3F | 0x80);
        } else {
            this.write(ch >> 18 & 7 | 0xF0);
            this.write(ch >> 12 & 0x3F | 0x80);
            this.write(ch >> 6 & 0x3F | 0x80);
            this.write(ch >> 0 & 0x3F | 0x80);
        }
    }

    public final void writeString(String str) throws IOException {
        this.print(Token.token(str));
        this.write(0);
    }

    public final void print(String str) throws IOException {
        this.print(Token.token(str));
    }

    public final void println(String str) throws IOException {
        this.print(str);
        this.print(Prop.NL);
    }

    public final void print(byte[] token) throws IOException {
        byte[] byArray = token;
        int n = token.length;
        int n2 = 0;
        while (n2 < n) {
            byte t = byArray[n2];
            this.write(t);
            ++n2;
        }
    }

    public final void println(byte[] token) throws IOException {
        this.print(token);
        this.print(Prop.NL);
    }

    public final int size() {
        return this.size;
    }

    @Override
    public final void flush() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.os != null) {
            if (this.os == System.out || this.os == System.err) {
                this.os.flush();
            } else {
                this.os.close();
            }
        }
    }

    public boolean finished() {
        return false;
    }
}

