/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.random;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.basex.io.random.Buffer;
import org.basex.io.random.Buffers;
import org.basex.util.Util;

public final class DataAccess {
    private final Buffers bm = new Buffers();
    private final RandomAccessFile file;
    private long len;
    private boolean changed;
    private int off;

    public DataAccess(File f) throws IOException {
        this.file = new RandomAccessFile(f, "rw");
        this.len = this.file.length();
        this.cursor(0L);
    }

    public synchronized void flush() throws IOException {
        Buffer[] bufferArray = this.bm.all();
        int n = bufferArray.length;
        int n2 = 0;
        while (n2 < n) {
            Buffer b = bufferArray[n2];
            if (b.dirty) {
                this.writeBlock(b);
            }
            ++n2;
        }
        if (this.changed) {
            this.file.setLength(this.len);
            this.changed = false;
        }
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.file.close();
    }

    public long cursor() {
        return this.buffer((boolean)false).pos + (long)this.off;
    }

    public synchronized void length(long l) {
        this.changed |= l != this.len;
        this.len = l;
    }

    public long length() {
        return this.len;
    }

    public boolean more() {
        return this.cursor() < this.len;
    }

    public synchronized byte read1() {
        return (byte)this.read();
    }

    public synchronized byte read1(long p) {
        this.cursor(p);
        return this.read1();
    }

    public synchronized int read4() {
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
    }

    public synchronized int read4(long p) {
        this.cursor(p);
        return this.read4();
    }

    public synchronized long read5(long p) {
        this.cursor(p);
        return this.read5();
    }

    public synchronized long read5() {
        return ((long)this.read() << 32) + ((long)this.read() << 24) + (long)(this.read() << 16) + (long)(this.read() << 8) + (long)this.read();
    }

    public synchronized int readNum(long p) {
        this.cursor(p);
        return this.readNum();
    }

    public synchronized byte[] readToken(long p) {
        this.cursor(p);
        return this.readToken();
    }

    public synchronized byte[] readToken() {
        int l = this.readNum();
        int ll = 4096 - this.off;
        byte[] b = new byte[l];
        System.arraycopy(this.buffer((boolean)false).data, this.off, b, 0, Math.min(l, ll));
        if (l > ll) {
            l -= ll;
            while (l > 4096) {
                System.arraycopy(this.buffer((boolean)true).data, 0, b, ll, 4096);
                ll += 4096;
                l -= 4096;
            }
            System.arraycopy(this.buffer((boolean)true).data, 0, b, ll, l);
        }
        this.off += l;
        return b;
    }

    public synchronized byte[] readBytes(long p, int l) {
        this.cursor(p);
        return this.readBytes(l);
    }

    public synchronized byte[] readBytes(int l) {
        byte[] b = new byte[l];
        int i = 0;
        while (i < b.length) {
            b[i] = this.read1();
            ++i;
        }
        return b;
    }

    public void cursor(long p) {
        this.off = (int)(p & 0xFFFL);
        long b = p - (long)this.off;
        if (!this.bm.cursor(b)) {
            return;
        }
        Buffer bf = this.bm.current();
        try {
            if (bf.dirty) {
                this.writeBlock(bf);
            }
            bf.pos = b;
            this.file.seek(bf.pos);
            this.file.readFully(bf.data, 0, (int)Math.min(this.len - b, 4096L));
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    public synchronized int readNum() {
        int v = this.read();
        switch (v & 0xC0) {
            case 0: {
                return v;
            }
            case 64: {
                return (v - 64 << 8) + this.read();
            }
            case 128: {
                return (v - 128 << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
            }
        }
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
    }

    public void write1(int v) {
        this.write(v);
    }

    public void write4(long p, int v) {
        this.cursor(p);
        this.write4(v);
    }

    public void write4(int v) {
        this.write(v >>> 24);
        this.write(v >>> 16);
        this.write(v >>> 8);
        this.write(v);
    }

    public void writeToken(long p, byte[] v) {
        this.cursor(p);
        this.writeNum(v.length);
        byte[] byArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            this.write(b);
            ++n2;
        }
    }

    public void writeNum(int v) {
        if (v < 0 || v > 0x3FFFFFFF) {
            this.write(192);
            this.write(v >>> 24);
            this.write(v >>> 16);
            this.write(v >>> 8);
            this.write(v);
        } else if (v > 16383) {
            this.write(v >>> 24 | 0x80);
            this.write(v >>> 16);
            this.write(v >>> 8);
            this.write(v);
        } else if (v > 63) {
            this.write(v >>> 8 | 0x40);
            this.write(v);
        } else {
            this.write(v);
        }
    }

    public long free(long pos, int size) {
        int os = this.readNum(pos) + (int)(this.cursor() - pos);
        this.cursor(pos + (long)os);
        while (pos + (long)os < this.len && os < size && this.read1() == 0) {
            ++os;
        }
        long o = pos;
        if (pos + (long)os == this.len) {
            this.length(pos);
        } else {
            int t = size;
            if (os < size) {
                this.cursor(pos);
                t = 0;
                o = this.len;
            } else {
                this.cursor(pos + (long)size);
            }
            while (t++ < os) {
                this.write1(0);
            }
        }
        return o;
    }

    private void writeBlock(Buffer bf) throws IOException {
        this.file.seek(bf.pos);
        this.file.write(bf.data);
        bf.dirty = false;
    }

    private int read() {
        Buffer bf = this.buffer(this.off == 4096);
        return bf.data[this.off++] & 0xFF;
    }

    private void write(int b) {
        Buffer bf = this.buffer(this.off == 4096);
        bf.dirty = true;
        bf.data[this.off++] = (byte)b;
        long nl = bf.pos + (long)this.off;
        if (nl > this.len) {
            this.length(nl);
        }
    }

    private Buffer buffer(boolean next) {
        if (next) {
            this.off = 0;
            this.cursor(this.bm.current().pos + 4096L);
        }
        return this.bm.current();
    }
}

