/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.DataText;
import org.basex.data.ExprInfo;
import org.basex.io.serial.DOTData;
import org.basex.io.serial.OutputSerializer;
import org.basex.query.item.Item;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.ObjList;

public final class DOTSerializer
extends OutputSerializer {
    private final boolean compact;
    private final ObjList<IntList> children = new ObjList();
    private final TokenBuilder tb = new TokenBuilder();
    private final IntList nodes = new IntList();
    private String color;
    private int count;

    public DOTSerializer(OutputStream os, boolean c) throws IOException {
        super(os, PROPS, new String[0]);
        this.compact = c;
        this.print(DOTData.HEADER);
    }

    @Override
    protected void startOpen(byte[] t) {
        this.tb.reset();
    }

    @Override
    public void attribute(byte[] n, byte[] v) {
        this.tb.addExt("\\n%: %", DOTData.name(Token.string(n)), v);
    }

    @Override
    public void finishOpen() throws IOException {
        byte[] attr = this.tb.finish();
        if (this.color == null) {
            this.color = DOTData.color(Token.string(this.tag));
        }
        if (this.color == null) {
            this.color = attr.length == 0 ? "303030" : "909090";
        }
        this.print(Token.concat(this.tag, attr), this.color);
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        this.finishClose();
    }

    @Override
    protected void finishClose() throws IOException {
        int c = this.nodes.get(this.level);
        IntList il = this.child(this.level);
        int is = il.size();
        int i = 0;
        while (i < is) {
            this.indent();
            this.print(Util.info("node% -> node%;", c, il.get(i)));
            ++i;
        }
        this.color = null;
        il.reset();
    }

    @Override
    public void finishText(byte[] t) throws IOException {
        this.print(Token.norm(t), "6666FF");
    }

    @Override
    public void finishComment(byte[] t) throws IOException {
        this.print(new TokenBuilder(DataText.COMM_O).add(Token.norm(t)).add(DataText.COMM_C).finish(), "3366FF");
    }

    @Override
    public void finishPi(byte[] n, byte[] v) throws IOException {
        this.print(new TokenBuilder(DataText.PI_O).add(n).add(Token.SPACE).add(v).add(DataText.PI_C).finish(), "3399FF");
    }

    @Override
    public void finishItem(Item it) throws IOException {
        this.print(Token.norm(this.atom(it)), "3366CC");
    }

    @Override
    public void close() throws IOException {
        this.indent();
        this.print("}");
    }

    private void print(byte[] t, String col) throws IOException {
        String txt = Token.string(Token.chop(t, 60)).replaceAll("\"|\\r|\\n", "'");
        if (this.compact) {
            txt = txt.replaceAll("\\\\n\\w+:", "\\\\n");
        }
        this.indent();
        this.print(Util.info("node% [label=\"%\" color=\"#%\"];", this.count, txt, col));
        this.nodes.set(this.level, this.count);
        if (this.level > 0) {
            this.child(this.level - 1).add(this.count);
        }
        ++this.count;
    }

    private IntList child(int i) {
        while (i >= this.children.size()) {
            this.children.add(new IntList());
        }
        return this.children.get(i);
    }

    @Override
    protected byte[] name(ExprInfo expr) {
        this.color = DOTData.color(expr);
        return Token.token(DOTData.name(expr));
    }
}

