/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.DataText;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryException;
import org.basex.query.item.Item;
import org.basex.query.util.Err;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.BoolList;
import org.basex.util.list.TokenList;

public final class JSONSerializer
extends OutputSerializer {
    private static final byte[] S = new byte[]{115};
    private static final byte[][] ATTRS = new byte[][]{Token.concat(DataText.BOOL, S), Token.concat(DataText.NUM, S), Token.concat(Token.NULL, S), Token.concat(DataText.ARR, S), Token.concat(DataText.OBJ, S), Token.concat(DataText.STR, S)};
    private static final byte[][] TYPES = new byte[][]{DataText.BOOL, DataText.NUM, Token.NULL, DataText.ARR, DataText.OBJ, DataText.STR};
    private final TokenSet[] typeCache = new TokenSet[TYPES.length];
    private final BoolList comma = new BoolList();
    private final TokenList types = new TokenList();

    public JSONSerializer(OutputStream os, SerializerProp props) throws IOException {
        super(os, props, new String[0]);
        int t = 0;
        while (t < this.typeCache.length) {
            this.typeCache[t] = new TokenMap();
            ++t;
        }
    }

    @Override
    protected void startOpen(byte[] name) throws IOException {
        if (this.level == 0 && !Token.eq(name, DataText.JSON)) {
            this.error("<%> expected as root node", new Object[]{DataText.JSON});
        }
        this.types.set(this.level, null);
        this.comma.set(this.level + 1, false);
    }

    @Override
    public void attribute(byte[] name, byte[] value) throws IOException {
        if (this.level == 0) {
            int tl = this.typeCache.length;
            int t = 0;
            while (t < tl) {
                if (Token.eq(name, ATTRS[t])) {
                    byte[][] byArray = Token.split(value, 32);
                    int n = byArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte[] b = byArray[n2];
                        this.typeCache[t].add(b);
                        ++n2;
                    }
                    return;
                }
                ++t;
            }
        }
        if (Token.eq(name, DataText.TYPE)) {
            this.types.set(this.level, value);
            if (!Token.eq(value, TYPES)) {
                this.error("Element <%> has invalid type \"%\"", this.tag, value);
            }
        } else {
            this.error("Element <%> has invalid attribute \"%\"", this.tag, name);
        }
    }

    @Override
    protected void finishOpen() throws IOException {
        byte[] type;
        if (this.comma.get(this.level)) {
            this.print(44);
        } else {
            this.comma.set(this.level, true);
        }
        if (this.level > 0) {
            this.indent(this.level);
            byte[] par = this.types.get(this.level - 1);
            if (Token.eq(par, DataText.OBJ)) {
                this.print(34);
                this.print(this.name(this.tag));
                this.print("\": ");
            } else if (!Token.eq(par, DataText.ARR)) {
                this.error("Element <%> is typed as \"%\" and cannot be nested", this.tags.get(this.level - 1), par);
            }
        }
        if ((type = this.types.get(this.level)) == null) {
            int t = -1;
            int tl = this.typeCache.length;
            while (++t < tl && this.typeCache[t].id(this.tag) == 0) {
            }
            type = t != tl ? TYPES[t] : DataText.STR;
            this.types.set(this.level, type);
        }
        if (Token.eq(type, DataText.OBJ)) {
            this.print(123);
        } else if (Token.eq(type, DataText.ARR)) {
            this.print(91);
        } else if (this.level == 0) {
            this.error("Element <%> must be typed as \"%\" or \"%\"", DataText.JSON, DataText.OBJ, DataText.ARR);
        }
    }

    @Override
    public void finishText(byte[] text) throws IOException {
        byte[] type = this.types.get(this.level - 1);
        if (Token.eq(type, DataText.STR)) {
            this.print(34);
            byte[] byArray = text;
            int n = text.length;
            int n2 = 0;
            while (n2 < n) {
                byte ch = byArray[n2];
                this.code(ch);
                ++n2;
            }
            this.print(34);
        } else if (Token.eq(type, DataText.BOOL, DataText.NUM)) {
            this.print(text);
        } else if (Token.trim(text).length != 0) {
            this.error("Element <%> is typed as \"%\" and cannot have a value", this.tags.get(this.level - 1), type);
        }
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        byte[] type = this.types.get(this.level);
        if (Token.eq(type, DataText.STR)) {
            this.print("\"\"");
        } else if (Token.eq(type, Token.NULL)) {
            this.print(Token.NULL);
        } else if (!Token.eq(type, DataText.OBJ, DataText.ARR)) {
            this.error("Value expected for type \"%\"", new Object[]{type});
        }
        this.finishClose();
    }

    @Override
    protected void finishClose() throws IOException {
        byte[] type = this.types.get(this.level);
        if (Token.eq(type, DataText.ARR)) {
            this.indent(this.level);
            this.print(93);
        } else if (Token.eq(type, DataText.OBJ)) {
            this.indent(this.level);
            this.print(125);
        }
    }

    @Override
    protected void code(int ch) throws IOException {
        switch (ch) {
            case 8: {
                this.print("\\b");
                break;
            }
            case 12: {
                this.print("\\f");
                break;
            }
            case 10: {
                this.print("\\n");
                break;
            }
            case 13: {
                this.print("\\r");
                break;
            }
            case 9: {
                this.print("\\t");
                break;
            }
            case 34: {
                this.print("\\\"");
                break;
            }
            case 47: {
                this.print("\\/");
                break;
            }
            case 92: {
                this.print("\\\\");
                break;
            }
            default: {
                this.print(ch);
            }
        }
    }

    @Override
    public void finishComment(byte[] value) throws IOException {
        this.error("Comments cannot be serialized", new Object[0]);
    }

    @Override
    public void finishPi(byte[] name, byte[] value) throws IOException {
        this.error("Processing instructions cannot be serialized", new Object[0]);
    }

    @Override
    public void finishItem(Item value) throws IOException {
        this.error("Items cannot be serialized", new Object[0]);
    }

    protected void indent(int lvl) throws IOException {
        this.print(this.nl);
        int ls = lvl * this.indents;
        int l = 0;
        while (l < ls) {
            this.print(this.tab);
            ++l;
        }
    }

    private byte[] name(byte[] name) {
        TokenBuilder tb = new TokenBuilder();
        int uc = 0;
        int mode = 0;
        int n = 0;
        while (n < name.length) {
            int cp = Token.cp(name, n);
            if (mode >= 3) {
                uc = (uc << 4) + cp - (cp >= 48 && cp <= 57 ? 48 : 55);
                if (++mode == 7) {
                    tb.add(uc);
                    mode = 0;
                }
            } else if (cp == 95) {
                if (++mode == 3) {
                    tb.add(95);
                    mode = 0;
                    continue;
                }
            } else {
                if (mode == 1) {
                    mode = 3;
                    continue;
                }
                if (mode == 2) {
                    tb.add(95);
                    mode = 0;
                    continue;
                }
                tb.add(cp);
                mode = 0;
            }
            n += Token.cl(name, n);
        }
        if (mode == 2) {
            tb.add(95);
        } else if (mode > 0 && tb.size() != 0) {
            tb.add(63);
        }
        return tb.finish();
    }

    private QueryException error(String msg, Object ... ext) throws IOException {
        throw Err.JSONSER.thrwSerial(new Object[]{Util.inf(msg, ext)});
    }
}

