/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.Data;
import org.basex.data.ExprInfo;
import org.basex.data.FTPos;
import org.basex.data.FTPosData;
import org.basex.io.serial.HTMLSerializer;
import org.basex.io.serial.JSONSerializer;
import org.basex.io.serial.JsonMLSerializer;
import org.basex.io.serial.RawSerializer;
import org.basex.io.serial.SerializerProp;
import org.basex.io.serial.TextSerializer;
import org.basex.io.serial.XHTMLSerializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.item.Item;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public abstract class Serializer {
    protected static final SerializerProp PROPS = new SerializerProp();
    protected final TokenList tags = new TokenList();
    protected int level;
    protected byte[] tag;
    protected boolean undecl;
    private final Atts ns = new Atts().add(Token.XML, QueryText.XMLURI).add(Token.EMPTY, Token.EMPTY);
    private final IntList nsl = new IntList();
    private boolean elem;

    public static XMLSerializer get(OutputStream os) throws IOException {
        return new XMLSerializer(os, PROPS);
    }

    public static Serializer get(OutputStream os, SerializerProp props) throws IOException {
        if (props == null) {
            return Serializer.get(os);
        }
        String m = props.check(SerializerProp.S_METHOD, "xml", "xhtml", "html", "text", "json", "jsonml", "raw");
        if ("xhtml".equals(m)) {
            return new XHTMLSerializer(os, props);
        }
        if ("html".equals(m)) {
            return new HTMLSerializer(os, props);
        }
        if ("text".equals(m)) {
            return new TextSerializer(os, props);
        }
        if ("json".equals(m)) {
            return new JSONSerializer(os, props);
        }
        if ("jsonml".equals(m)) {
            return new JsonMLSerializer(os, props);
        }
        if ("raw".equals(m)) {
            return new RawSerializer(os, props);
        }
        return new XMLSerializer(os, props);
    }

    public final void openElement(byte[] t, byte[] ... a) throws IOException {
        this.finishElement();
        this.nsl.push(this.ns.size);
        this.elem = true;
        this.tag = t;
        this.startOpen(t);
        int i = 0;
        while (i < a.length) {
            this.attribute(a[i], a[i + 1]);
            i += 2;
        }
    }

    public final void closeElement() throws IOException {
        this.ns.size = this.nsl.pop();
        if (this.elem) {
            this.finishEmpty();
            this.elem = false;
        } else {
            this.tag = this.tags.pop();
            --this.level;
            this.finishClose();
        }
    }

    public final void emptyElement(byte[] t, byte[] ... a) throws IOException {
        this.openElement(t, a);
        this.closeElement();
    }

    public final void text(byte[] b) throws IOException {
        this.finishElement();
        this.finishText(b);
    }

    public final void comment(byte[] b) throws IOException {
        this.finishElement();
        this.finishComment(b);
    }

    public final void pi(byte[] n, byte[] v) throws IOException {
        this.finishElement();
        this.finishPi(n, v);
    }

    public final void item(Item b) throws IOException {
        this.finishElement();
        this.finishItem(b);
    }

    public final int node(Data data, int pre) throws IOException {
        return this.node(data, pre, null);
    }

    public final int node(Data data, int pre, FTPosData ft) throws IOException {
        boolean doc = false;
        TokenList nsp = data.ns.size() != 0 ? new TokenList() : null;
        IntList pars = new IntList();
        TokenList names = new TokenList();
        names.set(0, this.ns(Token.EMPTY));
        int l = 0;
        int p = pre;
        int s = pre + data.size(pre, data.kind(p));
        while (p < s && !this.finished()) {
            int k = data.kind(p);
            int r = data.parent(p, k);
            while (l > 0 && pars.get(l - 1) >= r) {
                this.closeElement();
                --l;
            }
            if (k == 0) {
                if (doc) {
                    this.closeDoc();
                }
                this.openDoc(data.text(p++, true));
                doc = true;
                continue;
            }
            if (k == 2) {
                FTPos ftd;
                FTPos fTPos = ftd = ft != null ? ft.get(data, p) : null;
                if (ftd != null) {
                    this.text(data.text(p++, true), ftd);
                    continue;
                }
                this.text(data.text(p++, true));
                continue;
            }
            if (k == 4) {
                this.comment(data.text(p++, true));
                continue;
            }
            if (k == 3) {
                this.attribute(data.name(p, k), data.text(p++, false));
                continue;
            }
            if (k == 5) {
                this.pi(data.name(p, k), data.atom(p++));
                continue;
            }
            byte[] name = data.name(p, k);
            this.openElement(name, (byte[][])new byte[0][]);
            byte[] empty = names.get(l);
            if (nsp != null) {
                nsp.reset();
                int pp = p;
                do {
                    Atts atn = data.ns(pp);
                    int n = 0;
                    while (n < atn.size) {
                        byte[] key = atn.key[n];
                        byte[] val = atn.val[n];
                        if (!nsp.contains(key)) {
                            nsp.add(key);
                            this.namespace(key, val);
                            if (key.length == 0) {
                                empty = val;
                            }
                        }
                        ++n;
                    }
                } while ((pp = data.parent(pp, data.kind(pp))) >= 0 && data.kind(pp) == 1 && l == 0 && this.level == 0);
                byte[] key = Token.pref(name);
                byte[] val = data.ns.uri(data.uri(p, k));
                if (val == null) {
                    val = Token.EMPTY;
                }
                if (key.length != 0) {
                    if (this.ns.get(key) == -1) {
                        this.namespace(key, val);
                    }
                } else if (!Token.eq(val, empty)) {
                    this.namespace(key, val);
                    empty = val;
                }
            } else if (l == 0 && this.ns(Token.EMPTY) != Token.EMPTY) {
                this.namespace(Token.EMPTY, Token.EMPTY);
            }
            int as = p + data.attSize(p, k);
            while (++p != as) {
                this.attribute(data.name(p, 3), data.text(p, false));
            }
            pars.set(l++, r);
            names.set(l, empty);
        }
        while (--l >= 0) {
            this.closeElement();
        }
        if (doc) {
            this.closeDoc();
        }
        return s;
    }

    public final void openElement(ExprInfo expr, byte[] ... a) throws IOException {
        this.openElement(this.name(expr), a);
    }

    public final void emptyElement(ExprInfo expr, byte[] ... a) throws IOException {
        this.emptyElement(this.name(expr), a);
    }

    public final int level() {
        return this.tags.size();
    }

    public void openResult() throws IOException {
    }

    public void closeResult() throws IOException {
    }

    public void close() throws IOException {
    }

    public void namespace(byte[] n, byte[] v) throws IOException {
        if (!this.undecl && n.length != 0 && v.length == 0) {
            return;
        }
        byte[] uri = this.ns(n);
        if (uri == null || !Token.eq(uri, v)) {
            this.attribute(n.length == 0 ? Token.XMLNS : Token.concat(Token.XMLNSC, n), v);
            this.ns.add(n, v);
        }
    }

    public boolean finished() {
        return false;
    }

    public void reset() {
    }

    public abstract void attribute(byte[] var1, byte[] var2) throws IOException;

    protected abstract void startOpen(byte[] var1) throws IOException;

    protected abstract void finishOpen() throws IOException;

    protected abstract void finishEmpty() throws IOException;

    protected abstract void finishClose() throws IOException;

    protected abstract void finishText(byte[] var1) throws IOException;

    protected abstract void finishComment(byte[] var1) throws IOException;

    protected abstract void finishPi(byte[] var1, byte[] var2) throws IOException;

    protected abstract void finishItem(Item var1) throws IOException;

    protected void finishText(byte[] b, FTPos ftp) throws IOException {
        this.text(b);
    }

    protected void openDoc(byte[] name) throws IOException {
    }

    protected void closeDoc() throws IOException {
    }

    protected byte[] name(ExprInfo expr) {
        return Token.token(expr.name());
    }

    protected final byte[] atom(Item it) throws IOException {
        try {
            return it.atom(null);
        }
        catch (QueryException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    private byte[] ns(byte[] pre) {
        int i = this.ns.size - 1;
        while (i >= 0) {
            if (Token.eq(this.ns.key[i], pre)) {
                return this.ns.val[i];
            }
            --i;
        }
        return null;
    }

    private void text(byte[] b, FTPos ftp) throws IOException {
        this.finishElement();
        this.finishText(b, ftp);
    }

    private void finishElement() throws IOException {
        if (!this.elem) {
            return;
        }
        this.elem = false;
        this.finishOpen();
        this.tags.push(this.tag);
        ++this.level;
    }
}

