/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.DataText;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.SerializerProp;
import org.basex.util.Token;

public class XHTMLSerializer
extends OutputSerializer {
    XHTMLSerializer(OutputStream os, SerializerProp p) throws IOException {
        super(os, p, "1.0", "1.1");
    }

    @Override
    public void attribute(byte[] n, byte[] v) throws IOException {
        byte[] tagatt = Token.concat(Token.lc(this.tag), Token.COLON, Token.lc(n));
        byte[] val = this.escape && URIS.id(tagatt) != 0 ? Token.escape(v) : v;
        super.attribute(n, val);
    }

    @Override
    protected void startOpen(byte[] t) throws IOException {
        super.startOpen(t);
        if (this.content && Token.eq(Token.lc(this.tag), DataText.HEAD)) {
            ++this.ct;
        }
    }

    @Override
    protected void finishOpen() throws IOException {
        super.finishOpen();
        if (this.ct(false, false)) {
            return;
        }
    }

    @Override
    protected void finishEmpty() throws IOException {
        if (this.ct(true, false)) {
            return;
        }
        if (EMPTIES.contains(Token.lc(this.tag))) {
            this.print(32);
            this.print(DataText.ELEM_SC);
        } else {
            this.print(DataText.ELEM_C);
            this.ind = false;
            this.finishClose();
        }
    }
}

