/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.Stack;
import org.basex.data.Data;
import org.basex.index.path.PathNode;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.path.Axis;
import org.basex.query.path.Test;
import org.basex.query.util.Err;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.ObjList;
import org.basex.util.list.StringList;

public final class QuerySuggest
extends QueryParser {
    private final Data data;
    private Stack<ObjList<PathNode>> stack;
    private ObjList<PathNode> all;
    private ObjList<PathNode> curr;
    private boolean show;
    private byte[] tag;

    public QuerySuggest(String q, QueryContext c, Data d) throws QueryException {
        super(q, c);
        this.data = d;
        this.checkInit();
    }

    public StringList complete() {
        StringList sl = new StringList();
        if (this.show) {
            for (PathNode n : this.curr) {
                String nm = Token.string(n.token(this.data));
                if (nm.isEmpty() || sl.contains(nm)) continue;
                sl.add(nm);
            }
            sl.sort(true, true);
        }
        return sl;
    }

    @Override
    protected void checkInit() {
        if (this.stack != null && !this.stack.empty() || !this.data.meta.pathindex) {
            return;
        }
        this.all = this.data.pthindex.root();
        this.curr = this.all;
        this.stack = new Stack();
    }

    @Override
    protected void checkAxis(Axis axis) {
        this.all = axis != Axis.CHILD && axis != Axis.DESC || !this.data.meta.pathindex ? new ObjList() : this.data.pthindex.desc(this.curr, axis == Axis.DESC);
        this.curr = this.all;
        this.show = true;
    }

    @Override
    protected void checkTest(Test test, boolean attr) {
        TokenBuilder tb = new TokenBuilder();
        if (attr) {
            tb.add(64);
        }
        if (test != null) {
            tb.add(test.toString().replaceAll("\\*:", ""));
        }
        this.tag = tb.finish();
        this.checkTest(this.qp < this.ql);
    }

    private void checkTest(boolean eq) {
        if (this.tag == null) {
            return;
        }
        ObjList<PathNode> tmp = new ObjList<PathNode>();
        boolean s = false;
        for (PathNode p : this.all) {
            byte[] nm = p.token(this.data);
            if (!Token.startsWith(nm, this.tag)) continue;
            if (!eq || Token.eq(nm, this.tag)) {
                tmp.add(p);
            }
            s |= !Token.eq(this.tag, nm);
        }
        this.show = this.tag.length == 0 || s;
        this.curr = tmp;
    }

    @Override
    protected void checkPred(boolean open) {
        if (this.stack == null) {
            return;
        }
        if (open) {
            this.checkTest(true);
            ObjList<PathNode> tmp = new ObjList<PathNode>();
            for (PathNode p : this.curr) {
                tmp.add(p);
            }
            this.stack.add(tmp);
            this.checkAxis(Axis.CHILD);
        } else {
            this.curr = this.stack.pop();
            this.show = false;
            this.all = this.curr;
        }
    }

    @Override
    public QueryException error(Err err, Object ... arg) throws QueryException {
        QueryException qe = new QueryException(this.input(), err, arg);
        qe.complete(this, this.complete());
        throw qe;
    }
}

