/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IterFilter;
import org.basex.query.expr.IterPosFilter;
import org.basex.query.expr.Preds;
import org.basex.query.item.Item;
import org.basex.query.item.SeqType;
import org.basex.query.item.Value;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.query.path.AxisPath;
import org.basex.query.util.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;

public class Filter
extends Preds {
    Expr root;

    public Filter(InputInfo ii, Expr r, Expr ... p) {
        super(ii, p);
        this.root = r;
    }

    @Override
    public final Expr comp(QueryContext ctx) throws QueryException {
        this.root = this.checkUp(this.root, ctx).comp(ctx);
        if (this.root.empty()) {
            return this.optPre(null, ctx);
        }
        if (this.root instanceof AxisPath && !super.uses(Expr.Use.POS)) {
            return ((AxisPath)this.root).copy().addPreds(this.preds).comp(ctx);
        }
        Value cv = ctx.value;
        ctx.value = null;
        Expr e = super.comp(ctx);
        ctx.value = cv;
        if (e != this) {
            return e;
        }
        return this.preds.length == 0 ? this.root : this.comp2(ctx);
    }

    public final Expr comp2(QueryContext ctx) {
        SeqType t = this.root.type();
        long s = this.root.size();
        if (s != -1L) {
            if (this.pos != null) {
                this.size = Math.max(0L, s + 1L - this.pos.min) - Math.max(0L, s - this.pos.max);
            } else if (this.last) {
                this.size = s > 0L ? 1 : 0;
            }
            if (this.size == 0L) {
                return this.optPre(null, ctx);
            }
            this.type = SeqType.get(t.type, this.size);
        } else {
            this.type = SeqType.get(t.type, t.zeroOrOne() ? SeqType.Occ.ZO : SeqType.Occ.ZM);
        }
        if (!super.uses(Expr.Use.POS)) {
            return new IterFilter(this);
        }
        if (this.preds.length == 1 && (this.last || this.pos != null) && this.root.value() && t.one() && (this.last || this.pos.min == 1L && this.pos.max == 1L)) {
            return this.optPre(this.root, ctx);
        }
        boolean off = this.preds.length == 1 && this.preds[0].type().num() && !this.preds[0].uses(Expr.Use.CTX);
        boolean iter = !off && this.useIterator();
        return off || iter ? new IterPosFilter(this, off) : this;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Item i;
        Iter iter = ctx.iter(this.root);
        Value cv = ctx.value;
        long cs = ctx.size;
        long cp = ctx.pos;
        ItemCache ic = new ItemCache();
        while ((i = iter.next()) != null) {
            ic.add(i);
        }
        Expr[] exprArray = this.preds;
        int n = this.preds.length;
        int n2 = 0;
        while (n2 < n) {
            long is;
            Expr p = exprArray[n2];
            ctx.size = is = ic.size();
            ctx.pos = 1L;
            int c = 0;
            int s = 0;
            while ((long)s < is) {
                ctx.value = ic.get(s);
                if (p.test(ctx, this.input) != null) {
                    ic.set(ic.get(s), c++);
                }
                ++ctx.pos;
                ++s;
            }
            ic.size(c);
            ++n2;
        }
        ctx.value = cv;
        ctx.size = cs;
        ctx.pos = cp;
        return ic;
    }

    public final Filter addPred(Expr p) {
        this.preds = Array.add(this.preds, p);
        return this;
    }

    @Override
    public final boolean uses(Expr.Use u) {
        return this.root.uses(u) || u != Expr.Use.CTX && super.uses(u);
    }

    @Override
    public final int count(Var v) {
        return this.root.count(v) + super.count(v);
    }

    @Override
    public final boolean removable(Var v) {
        return this.root.removable(v) && super.removable(v);
    }

    @Override
    public final Expr remove(Var v) {
        this.root = this.root.remove(v);
        return super.remove(v);
    }

    @Override
    public final void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[0][]);
        this.root.plan(ser);
        super.plan(ser);
        ser.closeElement();
    }

    @Override
    public final String toString() {
        return "(" + this.root + ")" + super.toString();
    }
}

