/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.index.IndexIterator;
import org.basex.index.IndexToken;
import org.basex.index.RangeToken;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryText;
import org.basex.query.expr.Simple;
import org.basex.query.item.DBNode;
import org.basex.query.item.Item;
import org.basex.query.item.SeqType;
import org.basex.query.iter.Iter;
import org.basex.query.util.IndexContext;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class RangeAccess
extends Simple {
    final RangeToken ind;
    final IndexContext ictx;

    RangeAccess(InputInfo ii, RangeToken t, IndexContext ic) {
        super(ii);
        this.ind = t;
        this.ictx = ic;
        this.type = SeqType.NOD_ZM;
    }

    @Override
    public Iter iter(QueryContext ctx) {
        final Data data = this.ictx.data;
        final byte kind = this.ind.type() == IndexToken.IndexType.TEXT ? (byte)2 : 3;
        return new Iter(){
            final IndexIterator it;
            {
                this.it = data2.iter(RangeAccess.this.ind);
            }

            @Override
            public Item next() {
                return this.it.more() ? new DBNode(data, this.it.next(), kind) : null;
            }
        };
    }

    @Override
    public boolean iterable() {
        return this.ictx.iterable;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.emptyElement(this, (byte[][])new byte[][]{QueryText.DATA, Token.token(this.ictx.data.meta.name), QueryText.MIN, Token.token(this.ind.min), QueryText.MAX, Token.token(this.ind.max), QueryText.TYP, Token.token(this.ind.ind.toString())});
    }

    @Override
    public String toString() {
        return new TokenBuilder(QueryText.DB).add(58).addExt(this.ind.type().toString().toLowerCase(), new Object[0]).add("-range(").addExt(this.ind.min, new Object[0]).add(", ").addExt(this.ind.max, new Object[0]).add(41).toString();
    }
}

