/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import java.io.IOException;
import java.util.Arrays;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.Nodes;
import org.basex.io.IO;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public final class Thesaurus {
    private final TokenObjMap<ThesNode> nodes = new TokenObjMap();
    private static final TokenMap RSHIPS = new TokenMap();
    private final Context ctx;
    private final IO file;
    private final byte[] rel;
    private final long min;
    private final long max;

    static {
        RSHIPS.add(Token.token("NT"), Token.token("BT"));
        RSHIPS.add(Token.token("BT"), Token.token("BT"));
        RSHIPS.add(Token.token("BTG"), Token.token("NTG"));
        RSHIPS.add(Token.token("NTG"), Token.token("BTG"));
        RSHIPS.add(Token.token("BTP"), Token.token("NTP"));
        RSHIPS.add(Token.token("NTP"), Token.token("BTP"));
        RSHIPS.add(Token.token("USE"), Token.token("UF"));
        RSHIPS.add(Token.token("UF"), Token.token("USE"));
        RSHIPS.add(Token.token("RT"), Token.token("RT"));
    }

    public Thesaurus(IO fl, Context c) {
        this(fl, Token.EMPTY, 0L, Long.MAX_VALUE, c);
    }

    public Thesaurus(IO fl, byte[] rs, long mn, long mx, Context c) {
        this.file = fl;
        this.rel = rs;
        this.min = mn;
        this.max = mx;
        this.ctx = c;
    }

    private void init(InputInfo ii) throws QueryException {
        try {
            MemData data = MemBuilder.build(Parser.xmlParser(this.file, this.ctx.prop), this.ctx.prop);
            Nodes result = this.nodes("//*:entry", new Nodes(0, (Data)data));
            int n = 0;
            while ((long)n < result.size()) {
                this.build(new Nodes(result.list[n], (Data)data));
                ++n;
            }
        }
        catch (IOException ex) {
            Err.NOTHES.thrw(ii, this.file);
        }
    }

    private void build(Nodes in) throws QueryException {
        Nodes sub = this.nodes("*:synonym", in);
        if (sub.size() == 0L) {
            return;
        }
        ThesNode node = this.node(this.text("*:term", in));
        int n = 0;
        while ((long)n < sub.size()) {
            Nodes tmp = new Nodes(sub.list[n], sub.data);
            ThesNode snode = this.node(this.text("*:term", tmp));
            byte[] rs = this.text("*:relationship", tmp);
            node.add(snode, rs);
            byte[] srs = RSHIPS.get(rs);
            if (srs != null) {
                snode.add(node, srs);
            }
            this.build(sub);
            ++n;
        }
    }

    private ThesNode node(byte[] term) {
        ThesNode node = this.nodes.get(term);
        if (node == null) {
            node = new ThesNode();
            node.term = term;
            this.nodes.add(term, node);
        }
        return node;
    }

    private Nodes nodes(String query, Nodes in) throws QueryException {
        return new QueryProcessor(query, in, this.ctx).queryNodes();
    }

    private byte[] text(String query, Nodes in) throws QueryException {
        return new QueryProcessor(query, in, this.ctx).iter().next().atom(null);
    }

    void find(InputInfo ii, TokenList list, byte[] ft) throws QueryException {
        if (this.nodes.size() == 0) {
            this.init(ii);
        }
        this.find(list, this.nodes.get(ft), 1L);
    }

    private void find(TokenList list, ThesNode node, long lev) {
        if (lev > this.max || node == null) {
            return;
        }
        int n = 0;
        while (n < node.size) {
            byte[] term;
            if ((this.rel.length == 0 || Token.eq(node.rs[n], this.rel)) && !list.contains(term = node.nodes[n].term)) {
                list.add(term);
                this.find(list, node.nodes[n], lev + 1L);
            }
            ++n;
        }
    }

    boolean sameAs(Thesaurus th) {
        return this.file.eq(th.file) && this.min == th.min && this.max == th.max && Token.eq(this.rel, th.rel);
    }

    static class ThesNode {
        ThesNode[] nodes = new ThesNode[1];
        byte[][] rs = new byte[1][];
        byte[] term;
        int size;

        ThesNode() {
        }

        void add(ThesNode n, byte[] r) {
            if (this.size == this.nodes.length) {
                int s = this.size << 1;
                this.nodes = Arrays.copyOf(this.nodes, s);
                this.rs = (byte[][])Arrays.copyOf(this.rs, s);
            }
            this.nodes[this.size] = n;
            this.rs[this.size++] = r;
        }
    }
}

