/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.JSONSerializer;
import org.basex.io.serial.JsonMLSerializer;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerException;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.Item;
import org.basex.query.item.Str;
import org.basex.query.util.Err;
import org.basex.query.util.json.JSONConverter;
import org.basex.query.util.json.JsonMLConverter;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNJson
extends FuncCall {
    public FNJson(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case JSONPARSE: {
                return new JSONConverter(this.input).parse(this.checkStr(this.expr[0], ctx));
            }
            case JSONPARSEML: {
                return new JsonMLConverter(this.input).parse(this.checkStr(this.expr[0], ctx));
            }
            case JSONSER: {
                return this.serialize(false, ctx);
            }
            case JSONSERML: {
                return this.serialize(true, ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Str serialize(boolean ml, QueryContext ctx) throws QueryException {
        ANode node = this.checkNode(this.checkItem(this.expr[0], ctx));
        ArrayOutput ao = new ArrayOutput();
        try {
            SerializerProp props = ctx.serProp(false);
            OutputSerializer json = ml ? new JsonMLSerializer(ao, props) : new JSONSerializer(ao, props);
            node.serialize(json);
            ((Serializer)json).close();
        }
        catch (SerializerException ex) {
            throw new QueryException(this.input, ex);
        }
        catch (IOException ex) {
            Err.SERANY.thrw(this.input, ex);
        }
        return Str.get(Token.delete(ao.toArray(), 13));
    }
}

