/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.Bln;
import org.basex.query.item.FAttr;
import org.basex.query.item.FElem;
import org.basex.query.item.FTxt;
import org.basex.query.item.Item;
import org.basex.query.item.QNm;
import org.basex.query.item.Str;
import org.basex.query.item.Uri;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.ByteList;

public final class FNPat
extends FuncCall {
    private static final Uri U_FN = Uri.uri(QueryText.FNURI);
    private static final QNm ANALYZE = new QNm(Token.token("fn:analyze-string-result"), U_FN);
    private static final QNm MATCH = new QNm(Token.token("fn:match"), U_FN);
    private static final QNm NONMATCH = new QNm(Token.token("fn:non-match"), U_FN);
    private static final QNm MGROUP = new QNm(Token.token("fn:group"), U_FN);
    private static final QNm NR = new QNm(Token.token("nr"));
    private static final Pattern CLASSES = Pattern.compile(".*?\\[([a-zA-Z])-([a-zA-Z]).*");
    private static final Pattern EX = Pattern.compile(".*?\\[(.*?)-\\[(.*?)\\].*");

    public FNPat(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case TOKEN: {
                return this.tokenize(this.checkEStr(this.expr[0], ctx), ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case MATCH: {
                return this.matches(this.checkEStr(this.expr[0], ctx), ctx);
            }
            case REPLACE: {
                return this.replace(this.checkEStr(this.expr[0], ctx), ctx);
            }
            case ANALZYE: {
                return this.analyzeString(this.checkEStr(this.expr[0], ctx), ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Item matches(byte[] val, QueryContext ctx) throws QueryException {
        Pattern p = this.pattern(this.expr[1], this.expr.length == 3 ? this.expr[2] : null, ctx);
        return Bln.get(p.matcher(Token.string(val)).find());
    }

    private Item analyzeString(byte[] val, QueryContext ctx) throws QueryException {
        Pattern p = this.pattern(this.expr[1], this.expr.length == 3 ? this.expr[2] : null, ctx);
        if (p.matcher("").matches()) {
            Err.REGROUP.thrw(this.input, new Object[0]);
        }
        String str = Token.string(val);
        Matcher m = p.matcher(str);
        FElem root = new FElem(ANALYZE, new Atts().add(QueryText.FN, QueryText.FNURI), Token.EMPTY);
        int s = 0;
        while (m.find()) {
            if (s != m.start()) {
                this.nonmatch(str.substring(s, m.start()), root);
            }
            this.match(m, str, root, 0);
            s = m.end();
        }
        if (s != str.length()) {
            this.nonmatch(str.substring(s), root);
        }
        return root;
    }

    private int[] match(Matcher m, String str, FElem par, int g) {
        FElem nd = new FElem(g == 0 ? MATCH : MGROUP);
        if (g > 0) {
            nd.add(new FAttr(NR, Token.token(g)));
        }
        int start = m.start(g);
        int end = m.end(g);
        int gc = m.groupCount();
        int[] pos = new int[]{g + 1, start};
        while (pos[0] <= gc && m.end(pos[0]) <= end) {
            int st = m.start(pos[0]);
            if (st >= 0) {
                if (pos[1] < st) {
                    nd.add(new FTxt(Token.token(str.substring(pos[1], st))));
                }
                pos = this.match(m, str, nd, pos[0]);
                continue;
            }
            pos[0] = pos[0] + 1;
        }
        if (pos[1] < end) {
            nd.add(new FTxt(Token.token(str.substring(pos[1], end))));
            pos[1] = end;
        }
        par.add(nd);
        return pos;
    }

    private void nonmatch(String text, FElem par) {
        FElem sub = new FElem(NONMATCH);
        sub.add(new FTxt(Token.token(text)));
        par.add(sub);
    }

    private Item replace(byte[] val, QueryContext ctx) throws QueryException {
        byte[] rep = this.checkStr(this.expr[2], ctx);
        int i = 0;
        while (i < rep.length) {
            if (rep[i] == 92) {
                if (i + 1 == rep.length || rep[i + 1] != 92 && rep[i + 1] != 36) {
                    Err.FUNREGREP.thrw(this.input, new Object[0]);
                }
                ++i;
            }
            ++i;
        }
        Pattern p = this.pattern(this.expr[1], this.expr.length == 4 ? this.expr[3] : null, ctx);
        String r = Token.string(rep);
        if ((p.flags() & 0x10) != 0) {
            r = r.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$");
        }
        try {
            return Str.get(p.matcher(Token.string(val)).replaceAll(r));
        }
        catch (Exception ex) {
            String m = ex.getMessage();
            if (m.contains("No group")) {
                Err.REGROUP.thrw(this.input, new Object[0]);
            }
            throw Err.REGERR.thrw(this.input, m);
        }
    }

    private Iter tokenize(byte[] val, QueryContext ctx) throws QueryException {
        Pattern p = this.pattern(this.expr[1], this.expr.length == 3 ? this.expr[2] : null, ctx);
        if (p.matcher("").matches()) {
            Err.REGROUP.thrw(this.input, new Object[0]);
        }
        ItemCache ic = new ItemCache();
        String str = Token.string(val);
        if (!str.isEmpty()) {
            Matcher m = p.matcher(str);
            int s = 0;
            while (m.find()) {
                ic.add(Str.get(str.substring(s, m.start())));
                s = m.end();
            }
            ic.add(Str.get(str.substring(s, str.length())));
        }
        return ic;
    }

    private Pattern pattern(Expr pattern, Expr mod, QueryContext ctx) throws QueryException {
        byte[] pt = this.checkStr(pattern, ctx);
        int m = 1;
        if (mod != null) {
            byte[] byArray = this.checkStr(mod, ctx);
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                if (b == 105) {
                    m |= 0x42;
                } else if (b == 109) {
                    m |= 8;
                } else if (b == 115) {
                    m |= 0x20;
                } else if (b == 113 && ctx.xquery3) {
                    m |= 0x10;
                } else if (b == 120) {
                    boolean cc = false;
                    ByteList bl = new ByteList();
                    byte[] byArray2 = pt;
                    int n3 = pt.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        byte p = byArray2[n4];
                        if (cc || p < 0 || p > 32) {
                            bl.add(p);
                        }
                        cc |= p == 91;
                        cc &= p != 93;
                        ++n4;
                    }
                    pt = bl.toArray();
                } else {
                    Err.REGMOD.thrw(this.input, Character.valueOf((char)b));
                }
                ++n2;
            }
        }
        ByteList bl = new ByteList();
        int i = 0;
        while (i < pt.length) {
            byte b = pt[i];
            bl.add(b);
            if (b == 92 && i + 1 != pt.length && pt[i + 1] == 32) {
                bl.add(b);
            }
            ++i;
        }
        try {
            String str = bl.toString();
            if ((m & 0x10) == 0 && str.indexOf(91) != -1 && str.indexOf(45) != -1) {
                Matcher mt;
                Matcher mt2;
                while ((mt2 = CLASSES.matcher(str)).matches()) {
                    char c1 = mt2.group(1).charAt(0);
                    char c2 = mt2.group(2).charAt(0);
                    TokenBuilder tb2 = new TokenBuilder("[");
                    char c = c1;
                    while (c <= c2) {
                        tb2.add(c);
                        c = (char)(c + '\u0001');
                    }
                    str = str.replaceAll("\\[" + c1 + "-" + c2, tb2.toString());
                }
                String old = "";
                while ((mt = EX.matcher(str)).matches() && !old.equals(str)) {
                    old = str;
                    String in = mt.group(1);
                    String ex = mt.group(2);
                    String out = in;
                    int e = 0;
                    while (e < ex.length()) {
                        out = out.replaceAll(ex.substring(e, e + 1), "");
                        ++e;
                    }
                    str = str.replaceAll("\\[" + in + "-\\[.*?\\]", "[" + out);
                }
            }
            return Pattern.compile(str, m);
        }
        catch (Exception ex) {
            throw Err.REGINV.thrw(this.input, new Object[]{pt});
        }
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 && this.def == Function.ANALZYE || super.uses(u);
    }
}

