/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.AtomType;
import org.basex.query.item.Bln;
import org.basex.query.item.FAttr;
import org.basex.query.item.FElem;
import org.basex.query.item.FTxt;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Uri;
import org.basex.query.item.map.Map;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeCache;
import org.basex.query.util.Err;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;

public final class FNSql
extends FuncCall {
    private static final byte[] INT = AtomType.INT.nam();
    private static final byte[] STRING = AtomType.STR.nam();
    private static final byte[] BOOL = AtomType.BLN.nam();
    private static final byte[] DATE = AtomType.DAT.nam();
    private static final byte[] DOUBLE = AtomType.DBL.nam();
    private static final byte[] FLOAT = AtomType.FLT.nam();
    private static final byte[] SHORT = AtomType.SHR.nam();
    private static final byte[] TIME = AtomType.TIM.nam();
    private static final byte[] TIMESTAMP = Token.token("timestamp");
    private static final QNm Q_ROW = new QNm(Token.token("sql:row"), QueryText.SQLURI);
    private static final QNm Q_COLUMN = new QNm(Token.token("sql:column"), QueryText.SQLURI);
    private static final QNm Q_NAME = new QNm(Token.token("name"), Token.EMPTY);
    private static final QNm E_OPS = new QNm(Token.token("options"), QueryText.SQLURI);
    private static final QNm E_PARAMS = new QNm(Token.token("parameters"), QueryText.SQLURI);
    private static final QNm E_PARAM = new QNm(Token.token("parameter"), QueryText.SQLURI);
    private static final byte[] AUTO_COMM = Token.token("autocommit");
    private static final String USER = "user";
    private static final String PASS = "password";
    private static final Atts NS_SQL = new Atts().add(QueryText.SQL, QueryText.SQLURI);
    private static final byte[] TYPE = Token.token("type");

    public FNSql(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        this.checkAdmin(ctx);
        switch (this.def) {
            case SQLEXECUTE: {
                return this.execute(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkAdmin(ctx);
        switch (this.def) {
            case SQLINIT: {
                return this.init(ctx);
            }
            case SQLCONNECT: {
                return this.connect(ctx);
            }
            case SQLPREPARE: {
                return this.prepare(ctx);
            }
            case SQLCLOSE: {
                return this.close(ctx);
            }
            case SQLCOMMIT: {
                return this.commit(ctx);
            }
            case SQLROLLBACK: {
                return this.rollback(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Item init(QueryContext ctx) throws QueryException {
        String driver = Token.string(this.checkStr(this.expr[0], ctx));
        if (Reflect.find(driver) == null) {
            Err.SQLINIT.thrw(this.input, driver);
        }
        return null;
    }

    private Itr connect(QueryContext ctx) throws QueryException {
        String url = Token.string(this.checkStr(this.expr[0], ctx));
        try {
            if (this.expr.length > 2) {
                String user = Token.string(this.checkStr(this.expr[1], ctx));
                String pass = Token.string(this.checkStr(this.expr[2], ctx));
                if (this.expr.length == 4) {
                    TokenObjMap<Object> options = this.options(3, E_OPS, ctx);
                    boolean autoCommit = true;
                    Object commit = options.get(AUTO_COMM);
                    if (commit != null) {
                        autoCommit = Boolean.parseBoolean(commit.toString());
                        options.delete(AUTO_COMM);
                    }
                    Properties props = this.connProps(this.options(3, E_OPS, ctx));
                    props.setProperty(USER, user);
                    props.setProperty(PASS, pass);
                    Connection conn = DriverManager.getConnection(url, props);
                    conn.setAutoCommit(autoCommit);
                    return Itr.get(ctx.jdbc.add(conn));
                }
                return Itr.get(ctx.jdbc.add(DriverManager.getConnection(url, user, pass)));
            }
            return Itr.get(ctx.jdbc.add(DriverManager.getConnection(url)));
        }
        catch (SQLException ex) {
            throw Err.SQLEXC.thrw(this.input, ex.getMessage());
        }
    }

    private Properties connProps(TokenObjMap<Object> options) {
        Properties props = new Properties();
        byte[][] byArray = options.keys();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] next = byArray[n2];
            if (next != null) {
                props.setProperty(Token.string(next), options.get(next).toString());
            }
            ++n2;
        }
        return props;
    }

    private Itr prepare(QueryContext ctx) throws QueryException {
        Connection conn = this.connection(ctx, false);
        byte[] prepStmt = this.checkStr(this.expr[1], ctx);
        try {
            PreparedStatement prep = conn.prepareStatement(Token.string(prepStmt));
            return Itr.get(ctx.jdbc.add(prep));
        }
        catch (SQLException ex) {
            throw Err.SQLEXC.thrw(this.input, ex.getMessage());
        }
    }

    private Iter execute(QueryContext ctx) throws QueryException {
        int id = (int)this.checkItr(this.expr[0].item(ctx, this.input));
        Object obj = ctx.jdbc.get(id);
        if (obj == null) {
            throw Err.NOCONN.thrw(this.input, id);
        }
        return obj instanceof Connection ? this.executeQuery((Connection)obj, ctx) : this.executePrepStmt((PreparedStatement)obj, ctx);
    }

    private NodeCache executeQuery(Connection conn, QueryContext ctx) throws QueryException {
        String query = Token.string(this.checkStr(ctx.iter(this.expr[1]).next(), ctx));
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            boolean result = stmt.execute(query);
            NodeCache nodeCache = result ? this.buildResult(stmt.getResultSet()) : new NodeCache();
            return nodeCache;
        }
        catch (SQLException ex) {
            throw Err.SQLEXC.thrw(this.input, ex.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private NodeCache executePrepStmt(PreparedStatement stmt, QueryContext ctx) throws QueryException {
        ANode params = (ANode)this.checkType(this.expr[1].item(ctx, this.input), NodeType.ELM);
        if (!params.qname().eq(E_PARAMS)) {
            Err.PARWHICH.thrw(this.input, params.qname());
        }
        try {
            int placeCount = stmt.getParameterMetaData().getParameterCount();
            if ((long)placeCount != this.countParams(params)) {
                Err.PARAMS.thrw(this.input, new Object[0]);
            } else {
                this.setParameters(params.children(), stmt);
            }
            boolean result = stmt.execute();
            return result ? this.buildResult(stmt.getResultSet()) : new NodeCache();
        }
        catch (SQLException ex) {
            throw Err.SQLEXC.thrw(this.input, ex.getMessage());
        }
    }

    private long countParams(ANode params) {
        AxisMoreIter ch = params.children();
        long c = ch.size();
        if (c == -1L) {
            do {
                ++c;
            } while (ch.next() != null);
        }
        return c;
    }

    private void setParameters(AxisMoreIter params, PreparedStatement stmt) throws QueryException {
        ANode next;
        int i = 0;
        while ((next = params.next()) != null) {
            byte[] v;
            ANode attr;
            if (!next.qname().eq(E_PARAM)) {
                Err.PARWHICH.thrw(this.input, next.qname());
            }
            AxisIter attrs = next.attributes();
            byte[] paramType = null;
            boolean isNull = false;
            while ((attr = attrs.next()) != null) {
                if (Token.eq(attr.nname(), TYPE)) {
                    paramType = attr.atom();
                    continue;
                }
                if (Token.eq(attr.nname(), Token.NULL)) {
                    isNull = attr.atom() != null && Bln.parse(attr.atom(), this.input);
                    continue;
                }
                throw Err.NOTEXPATTR.thrw(this.input, Token.string(attr.nname()));
            }
            if (paramType == null) {
                Err.NOPARAMTYPE.thrw(this.input, new Object[0]);
            }
            this.setParam(++i, stmt, paramType, (isNull |= (v = next.atom()).length == 0) ? null : Token.string(v), isNull);
        }
    }

    private void setParam(int index, PreparedStatement stmt, byte[] paramType, String value, boolean isNull) throws QueryException {
        block30: {
            try {
                if (Token.eq(BOOL, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 16);
                    } else {
                        stmt.setBoolean(index, Boolean.parseBoolean(value));
                    }
                    break block30;
                }
                if (Token.eq(DATE, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 91);
                    } else {
                        stmt.setDate(index, Date.valueOf(value));
                    }
                    break block30;
                }
                if (Token.eq(DOUBLE, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 8);
                    } else {
                        stmt.setDouble(index, Double.parseDouble(value));
                    }
                    break block30;
                }
                if (Token.eq(FLOAT, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 6);
                    } else {
                        stmt.setFloat(index, Float.parseFloat(value));
                    }
                    break block30;
                }
                if (Token.eq(INT, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 4);
                    } else {
                        stmt.setInt(index, Integer.parseInt(value));
                    }
                    break block30;
                }
                if (Token.eq(SHORT, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 5);
                    } else {
                        stmt.setShort(index, Short.parseShort(value));
                    }
                    break block30;
                }
                if (Token.eq(STRING, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 12);
                    } else {
                        stmt.setString(index, value);
                    }
                    break block30;
                }
                if (Token.eq(TIME, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 92);
                    } else {
                        stmt.setTime(index, Time.valueOf(value));
                    }
                    break block30;
                }
                if (Token.eq(TIMESTAMP, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 93);
                    } else {
                        stmt.setTimestamp(index, Timestamp.valueOf(value));
                    }
                    break block30;
                }
                throw Err.SQLEXC.thrw(this.input, "unsupported type: " + Token.string(paramType));
            }
            catch (SQLException ex) {
                throw Err.SQLEXC.thrw(this.input, ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                throw Err.ILLFORMAT.thrw(this.input, Token.string(paramType));
            }
        }
    }

    private NodeCache buildResult(ResultSet rs) throws QueryException {
        try {
            ResultSetMetaData metadata = rs.getMetaData();
            int columnCount = metadata.getColumnCount();
            NodeCache rows = new NodeCache();
            while (rs.next()) {
                NodeCache columns = new NodeCache();
                int k = 1;
                while (k <= columnCount) {
                    String label = metadata.getColumnLabel(k);
                    Object value = rs.getObject(label);
                    if (value != null) {
                        FAttr columnName = new FAttr(Q_NAME, Token.token(label));
                        NodeCache attr = new NodeCache();
                        attr.add(columnName);
                        FTxt columnValue = new FTxt(Token.token(value.toString()));
                        NodeCache ch = new NodeCache();
                        ch.add(columnValue);
                        columns.add(new FElem(Q_COLUMN, ch, attr, NS_SQL, null));
                    }
                    ++k;
                }
                rows.add(new FElem(Q_ROW, columns, null, NS_SQL, null));
            }
            return rows;
        }
        catch (SQLException ex) {
            throw Err.SQLEXC.thrw(this.input, ex.getMessage());
        }
    }

    private Item close(QueryContext ctx) throws QueryException {
        try {
            this.connection(ctx, true).close();
            return null;
        }
        catch (SQLException ex) {
            throw Err.SQLEXC.thrw(this.input, ex.getMessage());
        }
    }

    private Item commit(QueryContext ctx) throws QueryException {
        try {
            this.connection(ctx, false).commit();
            return null;
        }
        catch (SQLException ex) {
            throw Err.SQLEXC.thrw(this.input, ex.getMessage());
        }
    }

    private Item rollback(QueryContext ctx) throws QueryException {
        try {
            this.connection(ctx, false).rollback();
            return null;
        }
        catch (SQLException ex) {
            throw Err.SQLEXC.thrw(this.input, ex.getMessage());
        }
    }

    private Connection connection(QueryContext ctx, boolean del) throws QueryException {
        int id = (int)this.checkItr(this.expr[0].item(ctx, this.input));
        Object obj = ctx.jdbc.get(id);
        if (obj == null || !(obj instanceof Connection)) {
            Err.NOCONN.thrw(this.input, id);
        }
        if (del) {
            ctx.jdbc.remove(id);
        }
        return (Connection)obj;
    }

    private TokenObjMap<Object> options(int arg, QNm root, QueryContext ctx) throws QueryException {
        TokenObjMap<Object> tm = new TokenObjMap<Object>();
        if (arg >= this.expr.length) {
            return tm;
        }
        Item it = this.expr[arg].item(ctx, this.input);
        if (it == null) {
            return tm;
        }
        if (it instanceof Map) {
            return ((Map)it).tokenJavaMap(this.input);
        }
        if (!it.type().eq(SeqType.ELM)) {
            throw Err.NODFUNTYPE.thrw(this.input, this, it.type);
        }
        ANode node = (ANode)it;
        if (!node.qname().eq(root)) {
            Err.PARWHICH.thrw(this.input, node.qname());
        }
        AxisMoreIter ai = node.children();
        while ((node = ai.next()) != null) {
            QNm qn = node.qname();
            if (!qn.uri().eq(Uri.uri(QueryText.SQLURI))) {
                Err.PARWHICH.thrw(this.input, qn);
            }
            tm.add(qn.ln(), node.children().next());
        }
        return tm;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.CTX || super.uses(u);
    }
}

