/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.text.Normalizer;
import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.AtomType;
import org.basex.query.item.Bln;
import org.basex.query.item.Empty;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.ItrSeq;
import org.basex.query.item.Str;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

public final class FNStr
extends FuncCall {
    public FNStr(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Expr e = this.expr[0];
        switch (this.def) {
            case STCODE: {
                return this.str2cp(e.item(ctx, this.input));
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case STCODE: {
                int[] tmp = Token.cps(this.checkEStr(this.expr[0], ctx));
                long[] vals = new long[tmp.length];
                int i = 0;
                while (i < tmp.length) {
                    vals[i] = tmp[i];
                    ++i;
                }
                return ItrSeq.get(vals, AtomType.ITR);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Expr e = this.expr[0];
        switch (this.def) {
            case CODESTR: {
                return this.cp2str(ctx.iter(e));
            }
            case COMPARE: {
                if (this.expr.length == 3) {
                    this.checkColl(this.expr[2], ctx);
                }
                Item it1 = e.item(ctx, this.input);
                Item it2 = this.expr[1].item(ctx, this.input);
                if (it1 == null || it2 == null) {
                    return null;
                }
                int d = Token.diff(this.checkEStr(it1), this.checkEStr(it2));
                return Itr.get(Math.max(-1, Math.min(1, d)));
            }
            case CODEPNT: {
                Item it1 = e.item(ctx, this.input);
                Item it2 = this.expr[1].item(ctx, this.input);
                if (it1 == null || it2 == null) {
                    return null;
                }
                return Bln.get(Token.eq(this.checkEStr(it1), this.checkEStr(it2)));
            }
            case STRJOIN: {
                return this.strjoin(ctx);
            }
            case SUBSTR: {
                return this.substr(ctx);
            }
            case NORMUNI: {
                return this.normuni(ctx);
            }
            case UPPER: {
                return Str.get(Token.uc(this.checkEStr(e, ctx)));
            }
            case LOWER: {
                return Str.get(Token.lc(this.checkEStr(e, ctx)));
            }
            case TRANS: {
                return this.trans(ctx);
            }
            case ENCURI: {
                return Str.get(Token.uri(this.checkEStr(e, ctx), false));
            }
            case IRIURI: {
                return Str.get(Token.uri(this.checkEStr(e, ctx), true));
            }
            case ESCURI: {
                return Str.get(Token.escape(this.checkEStr(e, ctx)));
            }
            case CONCAT: {
                return this.concat(ctx);
            }
            case CONTAINS: {
                Item it;
                if (this.expr.length == 3) {
                    this.checkColl(this.expr[2], ctx);
                }
                if ((it = this.expr[1].item(ctx, this.input)) == null) {
                    return Bln.TRUE;
                }
                return Bln.get(Token.contains(this.checkEStr(e, ctx), this.checkEStr(it)));
            }
            case STARTS: {
                Item it;
                if (this.expr.length == 3) {
                    this.checkColl(this.expr[2], ctx);
                }
                if ((it = this.expr[1].item(ctx, this.input)) == null) {
                    return Bln.TRUE;
                }
                return Bln.get(Token.startsWith(this.checkEStr(e, ctx), this.checkEStr(it)));
            }
            case ENDS: {
                Item it;
                if (this.expr.length == 3) {
                    this.checkColl(this.expr[2], ctx);
                }
                if ((it = this.expr[1].item(ctx, this.input)) == null) {
                    return Bln.TRUE;
                }
                return Bln.get(Token.endsWith(this.checkEStr(e, ctx), this.checkEStr(it)));
            }
            case SUBAFTER: {
                byte[] sa;
                byte[] str;
                int pa;
                if (this.expr.length == 3) {
                    this.checkColl(this.expr[2], ctx);
                }
                return (pa = Token.indexOf(str = this.checkEStr(e, ctx), sa = this.checkEStr(this.expr[1], ctx))) != -1 ? Str.get(Token.substring(str, pa + sa.length)) : Str.ZERO;
            }
            case SUBBEFORE: {
                byte[] sb;
                int pb;
                if (this.expr.length == 3) {
                    this.checkColl(this.expr[2], ctx);
                }
                return (pb = Token.indexOf(sb = this.checkEStr(e, ctx), this.checkEStr(this.expr[1], ctx))) > 0 ? Str.get(Token.substring(sb, 0, pb)) : Str.ZERO;
            }
        }
        return super.item(ctx, ii);
    }

    private Item cp2str(Iter iter) throws QueryException {
        Item i;
        TokenBuilder tb = new TokenBuilder();
        while ((i = iter.next()) != null) {
            long n = this.checkItr(i);
            if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE || !XMLToken.valid((int)n)) {
                Err.INVCODE.thrw(this.input, i);
            }
            tb.add((int)n);
        }
        return Str.get(tb.finish());
    }

    private Iter str2cp(Item it) throws QueryException {
        if (it == null) {
            return Empty.ITER;
        }
        final byte[] s = this.checkEStr(it);
        return new Iter(){
            int l;

            @Override
            public Item next() {
                if (this.l == s.length) {
                    return null;
                }
                int i = Token.cp(s, this.l);
                this.l += Token.cl(s, this.l);
                return Itr.get(i);
            }
        };
    }

    private Item substr(QueryContext ctx) throws QueryException {
        int e;
        double ds = this.checkDbl(this.expr[1], ctx);
        byte[] str = this.checkEStr(this.expr[0], ctx);
        if (Double.isNaN(ds)) {
            return Str.ZERO;
        }
        boolean end = this.expr.length == 3;
        int l = Token.len(str);
        int s = this.subPos(ds);
        int n = e = end ? this.subPos(this.checkDbl(this.expr[2], ctx) + 1.0) : l;
        if (s < 0) {
            e += s;
            s = 0;
        }
        if (s >= (e = Math.min(l, end ? s + e : Integer.MAX_VALUE))) {
            return Str.ZERO;
        }
        if (Token.ascii(str)) {
            return Str.get(Token.substring(str, s, e));
        }
        int ss = s;
        int ee = e;
        int p = 0;
        l = 0;
        while (l < str.length) {
            if (p == s) {
                ss = l;
            }
            if (p == e) {
                ee = l;
            }
            l += Token.cl(str, l);
            ++p;
        }
        if (p == e) {
            ee = l;
        }
        return Str.get(Arrays.copyOfRange(str, ss, ee));
    }

    private int subPos(double d) {
        int i = (int)d;
        return d == (double)i ? i - 1 : (int)StrictMath.floor(d - 0.5);
    }

    private Item trans(QueryContext ctx) throws QueryException {
        int[] tok = Token.cps(this.checkEStr(this.expr[0], ctx));
        int[] srch = Token.cps(this.checkStr(this.expr[1], ctx));
        int[] rep = Token.cps(this.checkStr(this.expr[2], ctx));
        TokenBuilder tmp = new TokenBuilder(tok.length);
        int i = 0;
        while (i < tok.length) {
            int j = -1;
            while (++j < srch.length && tok[i] != srch[j]) {
            }
            if (j < srch.length) {
                if (j < rep.length) {
                    tmp.add(rep[j]);
                }
            } else {
                tmp.add(tok[i]);
            }
            ++i;
        }
        return Str.get(tmp.finish());
    }

    private Item strjoin(QueryContext ctx) throws QueryException {
        Item i;
        byte[] sep = this.expr.length == 2 ? this.checkStr(this.expr[1], ctx) : Token.EMPTY;
        TokenBuilder tb = new TokenBuilder();
        Iter iter = ctx.iter(this.expr[0]);
        int c = 0;
        while ((i = iter.next()) != null) {
            tb.add(this.checkEStr(i));
            tb.add(sep);
            ++c;
        }
        byte[] v = tb.finish();
        return Str.get(c == 0 ? v : Token.substring(v, 0, v.length - sep.length));
    }

    private Item normuni(QueryContext ctx) throws QueryException {
        byte[] str = this.checkEStr(this.expr[0], ctx);
        Normalizer.Form form = Normalizer.Form.NFC;
        if (this.expr.length == 2) {
            byte[] n = Token.uc(Token.trim(this.checkStr(this.expr[1], ctx)));
            if (n.length == 0) {
                return Str.get(str);
            }
            try {
                form = Normalizer.Form.valueOf(Token.string(n));
            }
            catch (IllegalArgumentException ex) {
                Err.NORMUNI.thrw(this.input, new Object[]{n});
            }
        }
        return Token.ascii(str) ? Str.get(str) : Str.get(Normalizer.normalize(Token.string(str), form));
    }

    private Item concat(QueryContext ctx) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        Expr[] exprArray = this.expr;
        int n = this.expr.length;
        int n2 = 0;
        while (n2 < n) {
            Expr a = exprArray[n2];
            Item it = a.item(ctx, this.input);
            if (it != null) {
                tb.add(it.atom(this.input));
            }
            ++n2;
        }
        return Str.get(tb.finish());
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 && this.def == Function.STRJOIN && this.expr.length == 1 || super.uses(u);
    }
}

