/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import org.basex.query.QueryException;
import org.basex.query.item.AtomType;
import org.basex.query.item.Bin;
import org.basex.query.item.Item;
import org.basex.query.util.Err;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class B64
extends Bin {
    public B64(byte[] d) {
        super(d, AtomType.B64);
    }

    public B64(byte[] v, InputInfo ii) throws QueryException {
        super(B64.decode(v, ii), AtomType.B64);
    }

    B64(Bin b, InputInfo ii) throws QueryException {
        this(b.val(ii));
    }

    @Override
    public byte[] atom(InputInfo ii) {
        return Base64.encode(this.val);
    }

    @Override
    public boolean eq(InputInfo ii, Item it) throws QueryException {
        return Token.eq(this.val(ii), it instanceof Bin ? ((Bin)it).val(ii) : B64.decode(it.atom(ii), ii));
    }

    private static byte[] decode(byte[] d, InputInfo ii) throws QueryException {
        try {
            return Base64.decode(d);
        }
        catch (IllegalArgumentException ex) {
            String chars = ex.getMessage().replaceAll(".*?: |\\.$", "");
            throw Err.FUNCAST.thrw(ii, AtomType.B64, chars);
        }
    }

    @Override
    public String toString() {
        return Util.info("\"%\"", new Object[]{this.atom(null)});
    }
}

