/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.DynFuncCall;
import org.basex.query.expr.Expr;
import org.basex.query.expr.VarRef;
import org.basex.query.item.FItem;
import org.basex.query.item.FuncType;
import org.basex.query.item.Item;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.query.util.VarList;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class FuncItem
extends FItem {
    private final Var[] vars;
    private final Expr expr;
    private final QNm name;
    private final SeqType cast;
    private final VarList closure = new VarList();

    public FuncItem(QNm n, Var[] arg, Expr body, FuncType t, boolean cst) {
        super(t);
        this.name = n;
        this.vars = arg;
        this.expr = body;
        this.cast = cst && t.ret != null ? t.ret : null;
    }

    public FuncItem(Var[] arg, Expr body, FuncType t, VarList cl, boolean cst) {
        this(null, arg, body, t, cst);
        if (cl != null) {
            int i = cl.size;
            while (--i >= 0) {
                Var v = cl.vars[i];
                if (body.count(v) == 0 || this.closure.contains(v)) continue;
                this.closure.set(v.copy());
            }
        }
    }

    @Override
    public int arity() {
        return this.vars.length;
    }

    @Override
    public QNm fName() {
        return this.name;
    }

    private int bindVars(QueryContext ctx, Value[] args) throws QueryException {
        int s = ctx.vars.size();
        int i = this.closure.size;
        while (--i >= 0) {
            ctx.vars.add(this.closure.vars[i].copy());
        }
        int a = this.vars.length;
        while (--a >= 0) {
            ctx.vars.add(this.vars[a].bind(args[a], ctx).copy());
        }
        return s;
    }

    @Override
    public Value invValue(QueryContext ctx, InputInfo ii, Value ... args) throws QueryException {
        int s = this.bindVars(ctx, args);
        Value cv = ctx.value;
        ctx.value = null;
        Value v = ctx.value(this.expr);
        ctx.value = cv;
        ctx.vars.reset(s);
        return this.cast != null ? this.cast.promote(v, ctx, ii) : v;
    }

    @Override
    public Iter invIter(QueryContext ctx, InputInfo ii, Value ... args) throws QueryException {
        return this.invValue(ctx, ii, args).iter();
    }

    @Override
    public Item invItem(QueryContext ctx, InputInfo ii, Value ... args) throws QueryException {
        int s = this.bindVars(ctx, args);
        Value cv = ctx.value;
        ctx.value = null;
        Item it = this.expr.item(ctx, ii);
        ctx.value = cv;
        ctx.vars.reset(s);
        return this.cast != null ? this.cast.cast(it, this.expr, false, ctx, ii) : it;
    }

    @Override
    public String toString() {
        FuncType ft = (FuncType)this.type;
        StringBuilder sb = new StringBuilder("function").append('(');
        Var[] varArray = this.vars;
        int n = this.vars.length;
        int n2 = 0;
        while (n2 < n) {
            Var v = varArray[n2];
            sb.append(v).append(v == this.vars[this.vars.length - 1] ? "" : ", ");
            ++n2;
        }
        return sb.append(")").append(ft.ret != null ? " as " + ft.ret : "").append(" { ").append(this.expr).append(" }").toString();
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.expr.uses(u);
    }

    @Override
    public int count(Var v) {
        return this.expr.count(v);
    }

    public static FuncItem coerce(QueryContext ctx, InputInfo ii, FuncItem fun, FuncType t) {
        Var[] vars = new Var[fun.vars.length];
        Expr[] refs = new Expr[vars.length];
        int i = vars.length;
        while (i-- > 0) {
            vars[i] = ctx.uniqueVar(ii, t.args[i]);
            refs[i] = new VarRef(ii, vars[i]);
        }
        return new FuncItem(fun.name, vars, new DynFuncCall(ii, (Expr)fun, refs), t, fun.cast != null);
    }

    @Override
    public FItem coerceTo(FuncType ft, QueryContext ctx, InputInfo ii) throws QueryException {
        if (this.vars.length != ft.args.length) {
            throw Err.cast(ii, ft, this);
        }
        return this.type.instance(ft) ? this : FuncItem.coerce(ctx, ii, this, ft);
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(Token.token(Util.name(this)), (byte[][])new byte[][]{Token.token("type"), Token.token(this.type.toString())});
        Var[] varArray = this.vars;
        int n = this.vars.length;
        int n2 = 0;
        while (n2 < n) {
            Var v = varArray[n2];
            v.plan(ser);
            ++n2;
        }
        this.expr.plan(ser);
        ser.closeElement();
    }
}

