/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.Seq;
import org.basex.query.item.SeqType;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class RangeSeq
extends Seq {
    private final long start;

    public RangeSeq(long s, long sz) {
        super(sz);
        this.start = s;
    }

    @Override
    public Object toJava() {
        Object[] obj = new Object[(int)this.size];
        int s = 0;
        while ((long)s < this.size) {
            obj[s] = Itr.get(this.start + (long)s);
            ++s;
        }
        return obj;
    }

    @Override
    public Item ebv(QueryContext ctx, InputInfo ii) throws QueryException {
        throw Err.CONDTYPE.thrw(ii, this);
    }

    @Override
    public SeqType type() {
        return SeqType.ITR_OM;
    }

    @Override
    public boolean iterable() {
        return true;
    }

    @Override
    public int writeTo(Item[] arr, int pos) {
        int i = 0;
        while ((long)i < this.size) {
            arr[pos + i] = this.itemAt(i);
            ++i;
        }
        return (int)this.size;
    }

    @Override
    public Item itemAt(long pos) {
        return Itr.get(this.start + pos);
    }

    @Override
    public boolean homogenous() {
        return true;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.emptyElement(Token.token(Util.name(this)), (byte[][])new byte[][]{QueryText.MIN, Token.token(this.start), QueryText.MAX, Token.token(this.start + this.size - 1L)});
    }

    @Override
    public String toString() {
        return "(" + this.start + ' ' + "to" + ' ' + (this.start + this.size - 1L) + ")";
    }
}

