/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.item.ANode;
import org.basex.query.item.AtomType;
import org.basex.query.item.FuncType;
import org.basex.query.item.Item;
import org.basex.query.item.MapType;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.item.Type;
import org.basex.query.item.Value;
import org.basex.query.item.map.Map;
import org.basex.query.iter.ItemCache;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;

public final class SeqType {
    public static final SeqType EMP = new SeqType(AtomType.EMP, Occ.Z);
    public static final SeqType ITEM = AtomType.ITEM.seq();
    public static final SeqType ITEM_ZO = new SeqType(AtomType.ITEM, Occ.ZO);
    public static final SeqType ITEM_ZM = new SeqType(AtomType.ITEM, Occ.ZM);
    public static final SeqType ITEM_OM = new SeqType(AtomType.ITEM, Occ.OM);
    public static final SeqType AAT = AtomType.AAT.seq();
    public static final SeqType AAT_ZO = new SeqType(AtomType.AAT, Occ.ZO);
    public static final SeqType AAT_ZM = new SeqType(AtomType.AAT, Occ.ZM);
    public static final SeqType BLN = AtomType.BLN.seq();
    public static final SeqType BLN_ZO = new SeqType(AtomType.BLN, Occ.ZO);
    public static final SeqType DBL = AtomType.DBL.seq();
    public static final SeqType DBL_ZM = new SeqType(AtomType.DBL, Occ.ZM);
    public static final SeqType DBL_ZO = new SeqType(AtomType.DBL, Occ.ZO);
    public static final SeqType DEC_ZO = new SeqType(AtomType.DEC, Occ.ZO);
    public static final SeqType ITR = AtomType.ITR.seq();
    public static final SeqType ITR_ZO = new SeqType(AtomType.ITR, Occ.ZO);
    public static final SeqType ITR_ZM = new SeqType(AtomType.ITR, Occ.ZM);
    public static final SeqType ITR_OM = new SeqType(AtomType.ITR, Occ.OM);
    public static final SeqType NOD = NodeType.NOD.seq();
    public static final SeqType NOD_ZO = new SeqType(NodeType.NOD, Occ.ZO);
    public static final SeqType NOD_ZM = new SeqType(NodeType.NOD, Occ.ZM);
    public static final SeqType NOD_OM = new SeqType(NodeType.NOD, Occ.OM);
    public static final SeqType QNM = AtomType.QNM.seq();
    public static final SeqType QNM_ZO = new SeqType(AtomType.QNM, Occ.ZO);
    public static final SeqType URI = AtomType.URI.seq();
    public static final SeqType URI_ZO = new SeqType(AtomType.URI, Occ.ZO);
    public static final SeqType URI_ZM = new SeqType(AtomType.URI, Occ.ZM);
    public static final SeqType STR = AtomType.STR.seq();
    public static final SeqType STR_ZO = new SeqType(AtomType.STR, Occ.ZO);
    public static final SeqType STR_ZM = new SeqType(AtomType.STR, Occ.ZM);
    public static final SeqType NCN_ZO = new SeqType(AtomType.NCN, Occ.ZO);
    public static final SeqType DAT = AtomType.DAT.seq();
    public static final SeqType DAT_ZO = new SeqType(AtomType.DAT, Occ.ZO);
    public static final SeqType DTD = AtomType.DTD.seq();
    public static final SeqType DTD_ZO = new SeqType(AtomType.DTD, Occ.ZO);
    public static final SeqType DTM = AtomType.DTM.seq();
    public static final SeqType DTM_ZO = new SeqType(AtomType.DTM, Occ.ZO);
    public static final SeqType TIM = AtomType.TIM.seq();
    public static final SeqType TIM_ZO = new SeqType(AtomType.TIM, Occ.ZO);
    public static final SeqType DUR_ZO = new SeqType(AtomType.DUR, Occ.ZO);
    public static final SeqType FUN_O = FuncType.ANY_FUN.seq();
    public static final SeqType BYT_ZM = new SeqType(AtomType.BYT, Occ.ZM);
    public static final SeqType DOC_O = NodeType.DOC.seq();
    public static final SeqType DOC_ZO = new SeqType(NodeType.DOC, Occ.ZO);
    public static final SeqType DOC_ZM = new SeqType(NodeType.DOC, Occ.ZM);
    public static final SeqType ELM = NodeType.ELM.seq();
    public static final SeqType ELM_ZM = new SeqType(NodeType.ELM, Occ.ZM);
    public static final MapType ANY_MAP = new MapType(AtomType.AAT, ITEM_ZM);
    public static final SeqType MAP_ZM = new SeqType(ANY_MAP, Occ.ZM);
    public static final SeqType MAP_O = new SeqType(MapType.get(AtomType.AAT, ITEM_ZM));
    public static final SeqType RAW = AtomType.RAW.seq();
    public static final SeqType HEX = AtomType.HEX.seq();
    public static final SeqType B64 = AtomType.B64.seq();
    public final Type type;
    public final Occ occ;
    public final QNm ext;

    private SeqType(Type t, Occ o) {
        this(t, o, null);
    }

    SeqType(Type t) {
        this(t, Occ.O);
    }

    private SeqType(Type t, Occ o, QNm e) {
        this.type = t;
        this.occ = t == AtomType.EMP ? Occ.Z : (t == AtomType.SEQ ? Occ.OM : o);
        this.ext = e;
    }

    public static SeqType get(Type t, Occ o) {
        return SeqType.get(t, o, null);
    }

    public static SeqType get(Type t, long o) {
        return SeqType.get(t, o == 0L ? Occ.Z : (o == 1L ? Occ.O : (o > 1L ? Occ.OM : Occ.ZM)));
    }

    public static SeqType get(Type t, Occ o, QNm e) {
        return o == Occ.O && e == null ? t.seq() : new SeqType(t, o, e);
    }

    public boolean instance(Value val) {
        long size = val.size();
        if (!this.occ.check(size)) {
            return false;
        }
        if (size == 0L) {
            return true;
        }
        MapType mt = this.type.map() ? (MapType)this.type : null;
        long i = 0L;
        while (i < size) {
            if (!this.check(val.itemAt(i), mt)) {
                return false;
            }
            if (i == 0L && val.homogenous()) break;
            ++i;
        }
        return true;
    }

    private boolean check(Item it, MapType mt) {
        return mt != null ? it.map() && ((Map)it).hasType(mt) : it.type.instance(this.type) && this.checkExt(it);
    }

    public Item cast(Item it, Expr e, boolean cast, QueryContext ctx, InputInfo ii) throws QueryException {
        if (it == null) {
            if (this.occ == Occ.O) {
                Err.XPEMPTY.thrw(ii, e.desc());
            }
            return null;
        }
        boolean correct = cast ? it.type == this.type : this.instance(it, ii);
        return this.check(correct ? it : this.type.e(it, ctx, ii), ii);
    }

    public Value promote(Value val, QueryContext ctx, InputInfo ii) throws QueryException {
        long size = val.size();
        if (!this.occ.check(size)) {
            Err.promote(ii, this.type, val);
        }
        if (size == 0L) {
            return val;
        }
        Item f = val.itemAt(0L);
        if (size == 1L) {
            return this.check(this.instance(f, ii) ? f : this.type.e(f, ctx, ii), ii);
        }
        if (val.homogenous() && this.instance(f, ii) && this.checkExt(f)) {
            return val;
        }
        ItemCache ic = new ItemCache((int)size);
        long i = 0L;
        while (i < size) {
            Item n = val.itemAt(i);
            ic.add(this.check(this.instance(n, ii) ? n : this.type.e(n, ctx, ii), ii));
            ++i;
        }
        return ic.value();
    }

    private boolean instance(Item it, InputInfo ii) throws QueryException {
        Type t = it.type;
        boolean ins = it.type.instance(this.type);
        if (!(ins || t.unt() || t.func() || t == AtomType.FLT && this.type == AtomType.DBL || t == AtomType.URI && this.type == AtomType.STR || (this.type == AtomType.FLT || this.type == AtomType.DBL) && t.instance(AtomType.DEC))) {
            Err.promote(ii, this.type, it);
        }
        return ins;
    }

    public SeqType intersect(SeqType t) {
        Type tp;
        Type type = tp = this.type == t.type ? this.type : AtomType.ITEM;
        Occ oc = this.occ == t.occ ? this.occ : (this.zeroOrOne() && t.zeroOrOne() ? Occ.ZO : Occ.ZM);
        return new SeqType(tp, oc);
    }

    public long occ() {
        return this.occ == Occ.Z ? 0 : (this.occ == Occ.O ? 1 : -1);
    }

    public boolean zeroOrOne() {
        return this.occ.max <= 1;
    }

    public boolean one() {
        return this.occ == Occ.O;
    }

    public boolean mayBeZero() {
        return this.occ.min == 0;
    }

    public boolean num() {
        return this.one() && this.type.num();
    }

    public boolean mayBeNum() {
        return this.type.num() || this.type == AtomType.ITEM;
    }

    private Item check(Item it, InputInfo ii) throws QueryException {
        if (!this.checkExt(it)) {
            Err.XPCAST.thrw(ii, it.type, this.ext);
        }
        return it;
    }

    private boolean checkExt(Item it) {
        return this.ext == null || this.ext.eq(((ANode)it).qname());
    }

    public boolean eq(SeqType t) {
        return this.type == t.type && this.occ == t.occ;
    }

    public String toString() {
        String str = this.type.toString();
        return String.valueOf(str.contains(" ") && this.occ != Occ.O ? String.valueOf('(') + str + ')' : str) + (Object)((Object)this.occ);
    }

    public boolean instance(SeqType t) {
        return this.type.instance(t.type) && this.occ.instance(t.occ);
    }

    public static enum Occ {
        Z(0, 0, ""),
        ZO(0, 1, "?"),
        O(1, 1, ""),
        OM(1, Integer.MAX_VALUE, "+"),
        ZM(0, Integer.MAX_VALUE, "*");

        private final String str;
        public final int min;
        public final int max;

        private Occ(int mn, int mx, String s) {
            this.min = mn;
            this.max = mx;
            this.str = s;
        }

        public boolean instance(Occ o) {
            return this.min >= o.min && this.max <= o.max;
        }

        public boolean check(long c) {
            return (long)this.min <= c && c <= (long)this.max;
        }

        public String toString() {
            return this.str;
        }
    }
}

