/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.index.path.PathNode;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Preds;
import org.basex.query.item.ANode;
import org.basex.query.item.Empty;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.SeqType;
import org.basex.query.item.Type;
import org.basex.query.item.Value;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.NodeCache;
import org.basex.query.iter.NodeIter;
import org.basex.query.path.Axis;
import org.basex.query.path.IterPosStep;
import org.basex.query.path.IterStep;
import org.basex.query.path.NameTest;
import org.basex.query.path.Test;
import org.basex.query.util.Err;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.ObjList;

public class AxisStep
extends Preds {
    Axis axis;
    public Test test;

    public static AxisStep get(AxisStep s) {
        return AxisStep.get(s.input, s.axis, s.test, s.preds);
    }

    public static AxisStep get(InputInfo ii, Axis a, Test t, Expr ... p) {
        boolean num = false;
        Expr[] exprArray = p;
        int n = p.length;
        int n2 = 0;
        while (n2 < n) {
            Expr pr = exprArray[n2];
            num |= pr.type().mayBeNum() || pr.uses(Expr.Use.POS);
            ++n2;
        }
        return num ? new AxisStep(ii, a, t, p) : new IterStep(ii, a, t, p);
    }

    protected AxisStep(InputInfo ii, Axis a, Test t, Expr ... p) {
        super(ii, p);
        this.axis = a;
        this.test = t;
        this.type = SeqType.NOD_ZM;
    }

    @Override
    public final Expr comp(QueryContext ctx) throws QueryException {
        Type ct;
        if (!this.test.comp(ctx)) {
            return Empty.SEQ;
        }
        Data data = ctx.data();
        ctx.leaf = data != null && this.test.test == Test.Name.NAME && this.test.type != NodeType.ATT && this.axis.down && data.meta.uptodate && data.ns.size() == 0 && data.tagindex.stat((int)data.tagindex.id((byte[])((NameTest)this.test).ln)).leaf;
        Type type = ct = ctx.value != null ? ctx.value.type : null;
        if (ct == NodeType.DOC) {
            ctx.value.type = NodeType.NOD;
        }
        Expr e = super.comp(ctx);
        if (ct == NodeType.DOC) {
            ctx.value.type = ct;
        }
        ctx.leaf = false;
        if (e != this || e instanceof IterStep) {
            return e;
        }
        if (!this.uses(Expr.Use.POS)) {
            return new IterStep(this.input, this.axis, this.test, this.preds);
        }
        if (this instanceof IterPosStep) {
            return this;
        }
        return this.useIterator() ? new IterPosStep(this) : this;
    }

    @Override
    public NodeIter iter(QueryContext ctx) throws QueryException {
        ANode n;
        Value v = this.checkCtx(ctx);
        if (!v.node()) {
            Err.NODESPATH.thrw(this.input, this, v.type);
        }
        AxisIter ai = this.axis.iter((ANode)v);
        NodeCache nc = new NodeCache();
        while ((n = ai.next()) != null) {
            if (!this.test.eval(n)) continue;
            nc.add(n.finish());
        }
        Expr[] exprArray = this.preds;
        int n2 = this.preds.length;
        int n3 = 0;
        while (n3 < n2) {
            Expr p = exprArray[n3];
            ctx.size = nc.size();
            ctx.pos = 1L;
            int c = 0;
            int n4 = 0;
            while ((long)n4 < nc.size()) {
                ctx.value = nc.get(n4);
                Item i = p.test(ctx, this.input);
                if (i != null) {
                    nc.get(n4).score(i.score());
                    nc.item[c++] = nc.get(n4);
                }
                ++ctx.pos;
                ++n4;
            }
            nc.size(c);
            ++n3;
        }
        return nc;
    }

    public final boolean simple(Axis ax, boolean name) {
        return this.axis == ax && this.preds.length == 0 && (name ? this.test.test == Test.Name.NAME : this.test == Test.NOD);
    }

    final ObjList<PathNode> size(ObjList<PathNode> nodes, Data data) {
        boolean desc;
        if (this.preds.length != 0 || data.ns.globalNS() == null) {
            return null;
        }
        int kind = -1;
        int name = 0;
        if (this.test.type != null) {
            kind = ANode.kind(this.test.type);
            if (kind == 5 || kind == 3) {
                return null;
            }
            if (this.test.test == Test.Name.NAME) {
                name = data.tagindex.id(((NameTest)this.test).ln);
            } else if (this.test.test != null && this.test.test != Test.Name.ALL) {
                return null;
            }
        }
        boolean bl = desc = this.axis == Axis.DESC;
        if (!desc && this.axis != Axis.CHILD) {
            return null;
        }
        ObjList<PathNode> out = new ObjList<PathNode>();
        for (PathNode pn : nodes) {
            data.pthindex.add(pn, out, name, kind, desc);
        }
        return out;
    }

    final AxisStep addPreds(Expr ... prds) {
        Expr[] exprArray = prds;
        int n = prds.length;
        int n2 = 0;
        while (n2 < n) {
            Expr p = exprArray[n2];
            this.preds = Array.add(this.preds, p);
            ++n2;
        }
        return AxisStep.get(this.input, this.axis, this.test, this.preds);
    }

    @Override
    public final boolean sameAs(Expr cmp) {
        if (!(cmp instanceof AxisStep)) {
            return false;
        }
        AxisStep st = (AxisStep)cmp;
        if (this.preds.length != st.preds.length || this.axis != st.axis || !this.test.sameAs(st.test)) {
            return false;
        }
        int p = 0;
        while (p < this.preds.length) {
            if (!this.preds[p].sameAs(st.preds[p])) {
                return false;
            }
            ++p;
        }
        return true;
    }

    @Override
    public final void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[0][]);
        ser.attribute(QueryText.AXIS, Token.token(this.axis.name));
        ser.attribute(QueryText.TEST, Token.token(this.test.toString()));
        super.plan(ser);
        ser.closeElement();
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.test == Test.NOD) {
            if (this.axis == Axis.PARENT) {
                sb.append("..");
            }
            if (this.axis == Axis.SELF) {
                sb.append(".");
            }
        }
        if (sb.length() == 0) {
            if (this.axis == Axis.ATTR) {
                sb.append("@");
            } else if (this.axis != Axis.CHILD) {
                sb.append((Object)((Object)this.axis) + "::");
            }
            sb.append(this.test);
        }
        return sb.append(super.toString()).toString();
    }
}

