/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.io.IOException;
import java.util.Iterator;
import org.basex.build.DirParser;
import org.basex.build.MemBuilder;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryException;
import org.basex.query.item.ANode;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.up.primitives.InsertBase;
import org.basex.query.up.primitives.PrimitiveType;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.ObjList;
import org.basex.util.list.TokenList;

public final class DBAdd
extends InsertBase {
    private final ObjList<Item> docs = new ObjList();
    private final TokenList paths = new TokenList();
    private final Context ctx;

    public DBAdd(Data d, InputInfo i, Item it, String p, Context c) {
        super(PrimitiveType.INSERTAFTER, -1, d, i, null);
        this.docs.add(it);
        this.paths.add(Token.token(p));
        this.ctx = c;
    }

    @Override
    public boolean adjacentTexts(int c) {
        return false;
    }

    @Override
    public void merge(UpdatePrimitive u) {
        DBAdd a = (DBAdd)u;
        Iterator<Item> d = a.docs.iterator();
        Iterator<byte[]> p = a.paths.iterator();
        while (d.hasNext()) {
            this.docs.add(d.next());
            this.paths.add(p.next());
        }
    }

    @Override
    public void apply() {
        super.apply();
        this.data.insert(this.data.meta.size, -1, this.md);
    }

    @Override
    public void prepare() throws QueryException {
        this.md = new MemData(this.data);
        Iterator<Item> d = this.docs.iterator();
        Iterator<byte[]> p = this.paths.iterator();
        while (d.hasNext()) {
            this.md.insert(this.md.meta.size, -1, this.docData(d.next(), p.next()));
        }
    }

    private Data docData(Item doc, byte[] pth) throws QueryException {
        MemData mdata;
        String name = Token.string(pth);
        if (name.endsWith(".")) {
            Err.RESINV.thrw(this.input, new Object[]{pth});
        }
        IO io = null;
        if (doc.str()) {
            io = IO.get(Token.string(doc.atom(this.input)));
            if (!io.exists()) {
                Err.RESFNF.thrw(this.input, new Object[]{pth});
            }
            if (!name.endsWith("/") && (io.isDir() || io.isArchive())) {
                name = String.valueOf(name) + "/";
            }
        }
        String target = "";
        int s = name.lastIndexOf(47);
        if (s != -1) {
            target = name.substring(0, s);
            name = name.substring(s + 1);
        }
        if (doc.str()) {
            if (!name.isEmpty()) {
                io.name(name);
            } else if (!(io instanceof IOContent)) {
                name = io.name();
            }
        }
        if (name.isEmpty()) {
            Err.RESINV.thrw(this.input, new Object[]{pth});
        }
        if (doc.node()) {
            ANode nd = (ANode)doc;
            if (nd.ndType() != NodeType.DOC) {
                Err.UPDOCTYPE.thrw(this.input, nd);
            }
            mdata = new MemData(this.data);
            new DataBuilder(mdata).build(nd);
            mdata.update(0, 0, pth);
        } else if (doc.str()) {
            DirParser p = new DirParser(io, target, this.ctx.prop);
            MemBuilder b = new MemBuilder(this.data.meta.name, p, this.ctx.prop);
            try {
                mdata = b.build();
            }
            catch (IOException ex) {
                throw Err.IOERR.thrw(this.input, ex);
            }
        } else {
            throw Err.STRNODTYPE.thrw(this.input, this, doc.type);
        }
        return mdata;
    }

    public String toString() {
        return String.valueOf(Util.name(this)) + "[" + this.docs.get(0) + "]";
    }
}

