/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.PrimitiveType;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;

public final class DBStore
extends UpdatePrimitive {
    private final TokenMap map = new TokenMap();

    public DBStore(Data d, byte[] path, byte[] val, InputInfo info) {
        super(PrimitiveType.DBSTORE, -1, d, info);
        this.map.add(path, val);
    }

    @Override
    public void merge(UpdatePrimitive p) {
        DBStore put = (DBStore)p;
        for (byte[] path : put.map) {
            this.map.add(path, put.map.get(path));
        }
    }

    @Override
    public void apply() throws QueryException {
        for (byte[] path : this.map) {
            try {
                IOFile file = this.data.meta.binary(Token.string(path));
                if (file == null) {
                    Err.UPDBPUTERR.thrw(this.input, new Object[]{path});
                }
                new IOFile(file.dir()).md();
                file.write(this.map.get(path));
            }
            catch (IOException ex) {
                Util.debug(ex);
                Err.UPDBPUTERR.thrw(this.input, new Object[]{path});
            }
        }
    }
}

