/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.data.FTPosData;
import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.item.ANode;
import org.basex.query.item.DBNode;
import org.basex.query.item.DBNodeSeq;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.item.Value;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.NodeCache;
import org.basex.query.util.DataFTBuilder;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class DataBuilder {
    private final MemData data;
    private DataFTBuilder ftbuilder;
    private int marker;
    private boolean preserve = true;
    private final boolean inherit = true;

    public DataBuilder(MemData md) {
        this.data = md;
    }

    public DataBuilder context(QueryContext ctx) {
        this.preserve = ctx.nsPreserve;
        return this;
    }

    private DataBuilder ftpos(byte[] tag, FTPosData pos, int len) {
        this.ftbuilder = new DataFTBuilder(pos, len);
        this.marker = this.data.tagindex.index(tag, null, false);
        return this;
    }

    public static Value mark(ANode node, byte[] tag, int len, QueryContext ctx) {
        MemData md = new MemData(ctx.context.prop);
        new DataBuilder(md).ftpos(tag, ctx.ftpos, len).build(node);
        IntList il = new IntList();
        int p = 0;
        while (p < md.meta.size) {
            il.add(p);
            p += md.size(p, md.kind(p));
        }
        return DBNodeSeq.get(il, md, false, false);
    }

    public void build(ANode n) {
        this.build(new NodeCache(new ANode[]{n}, 1));
    }

    public void build(NodeCache nc) {
        ANode n;
        int pre = 1;
        while ((n = nc.next()) != null) {
            pre = this.addNode(n, pre, 0, null);
        }
    }

    private int addNode(ANode nd, int pre, int par, ANode ndPar) {
        switch (nd.ndType()) {
            case DOC: {
                return this.addDoc(nd, pre);
            }
            case ELM: {
                return this.addElem(nd, pre, par, ndPar);
            }
            case TXT: {
                return pre + this.addText(nd, pre, par, ndPar);
            }
            case ATT: {
                return pre + this.addAttr(nd, pre, par);
            }
            case COM: {
                return pre + this.addComm(nd, pre, par);
            }
        }
        return pre + this.addPI(nd, pre, par);
    }

    private int addDoc(ANode nd, int pre) {
        ANode ch;
        int ms = this.data.meta.size;
        this.data.doc(ms, DataBuilder.size(nd, false), nd.base());
        this.data.insert(ms);
        int p = pre + 1;
        AxisMoreIter ai = nd.children();
        while ((ch = ai.next()) != null) {
            p = this.addNode(ch, p, pre, null);
        }
        return p;
    }

    private int addAttr(ANode nd, int pre, int par) {
        boolean ne;
        int ms = this.data.meta.size;
        QNm q = nd.qname();
        byte[] uri = q.uri().atom();
        int u = 0;
        boolean bl = ne = uri.length != 0;
        if (ne) {
            if (par == 0) {
                this.data.ns.add(ms, pre - par, q.pref(), uri);
            }
            u = this.data.ns.addURI(uri);
        }
        int n = this.data.atnindex.index(q.atom(), null, false);
        this.data.attr(ms, pre - par, n, nd.atom(), u, ne);
        this.data.insert(ms);
        return 1;
    }

    private int addText(ANode nd, int pre, int par, ANode ndPar) {
        TokenList tl;
        int dist = pre - par;
        TokenList tokenList = tl = this.ftbuilder != null ? this.ftbuilder.build(nd) : null;
        if (tl == null) {
            return this.addText(nd.atom(), dist);
        }
        int u = ndPar != null ? this.data.ns.uri(ndPar.nname(), true) : 0;
        int i = 0;
        while (i < tl.size()) {
            boolean elem;
            byte[] text = tl.get(i);
            boolean bl = elem = text == null;
            if (elem) {
                this.data.elem(dist + i, this.marker, 1, 2, u, false);
                this.data.insert(this.data.meta.size);
                text = tl.get(++i);
            }
            this.addText(text, elem ? 1 : dist + i);
            ++i;
        }
        return tl.size();
    }

    private int addText(byte[] txt, int dist) {
        int ms = this.data.meta.size;
        this.data.text(ms, dist, txt, 2);
        this.data.insert(ms);
        return 1;
    }

    private int addPI(ANode nd, int pre, int par) {
        int ms = this.data.meta.size;
        byte[] v = Token.trim(Token.concat(nd.nname(), Token.SPACE, nd.atom()));
        this.data.text(ms, pre - par, v, 5);
        this.data.insert(ms);
        return 1;
    }

    private int addComm(ANode nd, int pre, int par) {
        int ms = this.data.meta.size;
        this.data.text(ms, pre - par, nd.atom(), 4);
        this.data.insert(ms);
        return 1;
    }

    private int addElem(ANode nd, int pre, int par, ANode ndPar) {
        ANode ch;
        byte[] uri;
        int ms = this.data.meta.size;
        QNm q = nd.qname();
        this.data.ns.open();
        boolean ne = false;
        Atts ns = null;
        if (!this.preserve) {
            ns = nd.ns();
            Atts ns2 = nd.nsScope(true);
            int uid = ns2.get(Token.EMPTY);
            if (uid != -1) {
                ns.add(ns2.key[uid], ns2.val[uid]);
            }
        } else {
            Atts atts = ns = par == 0 ? nd.nsScope(true) : nd.ns();
        }
        if (ns != null) {
            if (ns.size > 0 && ndPar != null && this.preserve) {
                Atts nsPar = ndPar.nsScope(true);
                int j = 0;
                while (j < nsPar.size) {
                    byte[] key = nsPar.key[j];
                    int ki = ns.get(key);
                    if (ki > -1 && Token.eq(nsPar.val[j], ns.val[ki])) {
                        ns.delete(ki);
                    }
                    ++j;
                }
            }
            ne = ns.size > 0;
            int a = 0;
            while (ne && a < ns.size) {
                this.data.ns.add(ns.key[a], ns.val[a], ms);
                ++a;
            }
        }
        int u = (uri = q.uri().atom()).length != 0 ? this.data.ns.addURI(uri) : 0;
        int tn = this.data.tagindex.index(q.atom(), null, false);
        int s = DataBuilder.size(nd, false);
        this.data.elem(pre - par, tn, DataBuilder.size(nd, true), s, u, ne);
        this.data.insert(ms);
        int pp = pre;
        int p = pre + 1;
        AxisIter ai = nd.attributes();
        while ((ch = ai.next()) != null) {
            p = this.addNode(ch, p, pre, nd);
        }
        ai = nd.children();
        while ((ch = ai.next()) != null) {
            p = this.addNode(ch, p, pre, nd);
        }
        this.data.ns.close(ms);
        if (s != p - pp) {
            this.data.size(ms, 1, p - pp);
        }
        return p;
    }

    private static int size(ANode n, boolean a) {
        if (n instanceof DBNode) {
            DBNode dbn = (DBNode)n;
            int k = ANode.kind(n.ndType());
            return a ? dbn.data.attSize(dbn.pre, k) : dbn.data.size(dbn.pre, k);
        }
        int s = 1;
        AxisIter ai = n.attributes();
        while (ai.next() != null) {
            ++s;
        }
        if (!a) {
            ANode i;
            ai = n.children();
            while ((i = ai.next()) != null) {
                s += DataBuilder.size(i, a);
            }
        }
        return s;
    }

    public static ANode stripNS(ANode node, byte[] ns, QueryContext ctx) {
        if (node.type != NodeType.ELM) {
            return node;
        }
        MemData md = new MemData(ctx.context.prop);
        DataBuilder db = new DataBuilder(md);
        db.build(node);
        boolean del = true;
        int pre = 0;
        while (pre < md.meta.size) {
            byte[] uri;
            int kind = md.kind(pre);
            if ((kind == 1 || kind == 3) && (uri = md.ns.uri(md.uri(pre, kind))) != null && Token.eq(uri, ns)) {
                byte[] name = md.name(pre, kind);
                if (Token.pref(name).length == 0) {
                    if (kind == 1) {
                        md.update(pre, kind, name, Token.EMPTY);
                        md.nsFlag(pre, false);
                    }
                } else {
                    del = false;
                }
            }
            ++pre;
        }
        if (del) {
            md.ns.delete(ns);
        }
        return new DBNode(md, 0);
    }
}

