/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.core.Text;
import org.basex.io.serial.SerializerException;
import org.basex.query.QueryException;
import org.basex.query.expr.ParseExpr;
import org.basex.query.item.Item;
import org.basex.query.item.Type;
import org.basex.query.item.Value;
import org.basex.util.InputInfo;

public enum Err {
    NOIDX(ErrType.BASX, 1, "Unknown index '%'."),
    NODBCTX(ErrType.BASX, 2, "%: database context needed."),
    NODB(ErrType.BASX, 3, "Database '%' not found."),
    IDINVALID(ErrType.BASX, 4, "%: value '%' out of range."),
    PERMNO(ErrType.BASX, 5, Text.PERMNO),
    QUERYNODES(ErrType.BASX, 7, Text.QUERYNODESERR),
    EXPSINGLE(ErrType.BASX, 8, "Database '%' contains more than one document."),
    NOEVENT(ErrType.BASX, 9, "Event '%' is unknown."),
    NOOPTION(ErrType.BASX, 10, "Unknown database option '%'."),
    PARWHICH(ErrType.BASX, 11, "Unknown element: %."),
    DOCTRGMULT(ErrType.BASX, 12, "Single document is expected as replace target."),
    EMPTYPATH(ErrType.BASX, 13, "%: Empty path specified."),
    DBERR(ErrType.BASX, 14, "%"),
    JSONPARSE(ErrType.BASX, 15, "JSON parser (%:%): %."),
    JSONMLPARSE(ErrType.BASX, 15, "JsonML converter: %."),
    JSONSER(ErrType.BASX, 16, "JSON serialization: %."),
    INVPOS(ErrType.BASX, 17, "Illegal argument position for %: %."),
    CONVERT(ErrType.BASX, 18, "String conversion: %."),
    DIVZERO(ErrType.FOAR, 1, "'%' was divided by zero."),
    DIVFLOW(ErrType.FOAR, 2, "Invalid division result: % / %."),
    RANGE(ErrType.FOAR, 2, "Value out of range: %."),
    INVALUE(ErrType.FOCA, 2, "Invalid value for %: %."),
    INTRANGE(ErrType.FOCA, 3, "Integer value out of range: %."),
    DATECALC(ErrType.FOCA, 5, "Invalid % calculation: %."),
    INVCODE(ErrType.FOCH, 1, "Invalid codepoint '%'."),
    IMPLCOL(ErrType.FOCH, 2, "Unknown collation %."),
    NORMUNI(ErrType.FOCH, 3, "Unsupported normalization form (%)."),
    IDDOC(ErrType.FODC, 1, "Root must be a document node."),
    UNDOC(ErrType.FODC, 2, "Document node could not be created (%)."),
    COLLINV(ErrType.FODC, 2, "Invalid collection \"%\"."),
    NODEFCOLL(ErrType.FODC, 2, "No default collection available."),
    IOERR(ErrType.FODC, 2, "%"),
    RESFNF(ErrType.FODC, 2, "Resource \"%\" does not exist."),
    NOCOLL(ErrType.FODC, 4, "%"),
    SAXERR(ErrType.FODC, 6, "SAX: %."),
    BASEINV(ErrType.FODC, 7, "Base URI % is invalid."),
    RESINV(ErrType.FODC, 7, "Resource path \"%\" is invalid."),
    INVDB(ErrType.FODC, 7, "Invalid database name: \"%\"."),
    FORMNUM(ErrType.FODF, 1280, "Unknown decimal format: %."),
    PICNUM(ErrType.FODF, 1310, "Invalid picture string: \"%\"."),
    DATEZERO(ErrType.FODT, 2, "Invalid % calculation: infinity/zero."),
    INVALZONE(ErrType.FODT, 3, "Invalid timezone: %."),
    FUNERR1(ErrType.FOER, 0, "Halted on error()."),
    PATHNOTEXISTS(ErrType.FOFL, 1, "Path '%' does not exist."),
    FILEEXISTS(ErrType.FOFL, 2, "File '%' already exists."),
    NOTDIR(ErrType.FOFL, 3, "Path '%' is not a directory."),
    PATHISDIR(ErrType.FOFL, 4, "Path '%' is a directory."),
    ENCNOTEXISTS(ErrType.FOFL, 5, "Encoding '%' is not supported."),
    FILEERROR(ErrType.FOFL, 9999, "Operation failed: %."),
    CANNOTCREATE(ErrType.FOFL, 9999, "Directory '%' cannot be created."),
    CANNOTDEL(ErrType.FOFL, 9999, "Path '%' cannot be deleted."),
    CANNOTMOVE(ErrType.FOFL, 9999, "Moving '%' to '%' failed."),
    CANNOTLIST(ErrType.FOFL, 9999, "Files of '%' cannot be accessed."),
    PATHINVALID(ErrType.FOFL, 9999, "Invalid file path: '%'."),
    ZIPNOTFOUND(ErrType.FOZP, 1, "Path '%' is not found."),
    ZIPINVALID(ErrType.FOZP, 2, "% element: % attribute expected."),
    ZIPUNKNOWN(ErrType.FOZP, 2, "ZIP Definition: unknown element %."),
    ZIPFAIL(ErrType.FOZP, 3, "Operation failed: %."),
    HTTPERR(ErrType.FOHC, 1, "An HTTP error occurred: %."),
    HTMLERR(ErrType.FOHC, 2, "Error parsing entity as XML or HTML."),
    SRCATTR(ErrType.FOHC, 3, "No attribute beside 'src' and 'media-type' allowed."),
    REQINV(ErrType.FOHC, 4, "The request element is invalid: %."),
    NOURL(ErrType.FOHC, 5, "No URL specified."),
    NOPARAMS(ErrType.FOHC, 6, "Specify request element or HTTP URI."),
    PKGNOTEXIST(ErrType.PACK, 1, "Package '%' does not exist."),
    PKGINST(ErrType.PACK, 2, "Package '%' is already installed."),
    NECPKGNOTINST(ErrType.PACK, 3, "Necessary package '%' is not installed."),
    PKGDESCINV(ErrType.PACK, 4, "Package descriptor: %."),
    MODISTALLED(ErrType.PACK, 5, "Module % is already installed within another package."),
    PKGREADFAIL(ErrType.PACK, 6, "Package '%' could not be parsed: %."),
    PKGREADFNF(ErrType.PACK, 6, "Package '%' could not be parsed: '%' not found."),
    CANNOTDELPKG(ErrType.PACK, 7, "Package cannot be deleted."),
    PKGDEP(ErrType.PACK, 8, "Package '%' depends on package '%'."),
    PKGNOTSUPP(ErrType.PACK, 9, "Package is not supported by database version."),
    JARDESCINV(ErrType.PACK, 10, "Jar descriptor: %."),
    JARREADFAIL(ErrType.PACK, 11, "Reading jar descriptor failed: %."),
    NSDECL(ErrType.FONS, 4, "Namespace prefix not declared: \"%\"."),
    INVALIDZONE(ErrType.FORG, 1, "Invalid timezone: %."),
    FUNCAST(ErrType.FORG, 1, "Invalid % cast: %."),
    DATERANGE(ErrType.FORG, 1, "%(\"%\") out of range."),
    DATEFORMAT(ErrType.FORG, 1, "Wrong % format: \"%\" (try: \"%\")."),
    QNMINV(ErrType.FORG, 1, "Invalid QName: \"%\"."),
    URIINV(ErrType.FORG, 2, "Invalid URI: %."),
    EXPECTZ0(ErrType.FORG, 3, "Zero or one value expected."),
    EXPECTOM(ErrType.FORG, 4, "One or more values expected."),
    EXPECTO(ErrType.FORG, 5, "Exactly one value expected."),
    FUNCMP(ErrType.FORG, 6, "%: % expected, % found."),
    CONDTYPE(ErrType.FORG, 6, "% not allowed as condition type."),
    SUMTYPE(ErrType.FORG, 6, "%: % not allowed as input type."),
    FUNNUM(ErrType.FORG, 6, "%: number expected, % found."),
    FUNDUR(ErrType.FORG, 6, "%: duration expected, % found."),
    TYPECMP(ErrType.FORG, 6, "% is not comparable."),
    FUNJAVA(ErrType.FORG, 6, "Invalid arguments for %: %."),
    INVBASE(ErrType.FORG, 6, "Unsupported base: %."),
    INVDIG(ErrType.FORG, 6, "Invalid digit for base %: %."),
    JAVAERR(ErrType.FORG, 6, "Java call failed: %."),
    ERRFORM(ErrType.FORG, 6, "%: %."),
    FUNZONE(ErrType.FORG, 8, "% and % have different timezones."),
    REGMOD(ErrType.FORX, 1, "Invalid regular modifier: '%'."),
    REGINV(ErrType.FORX, 2, "Invalid regular expression: '%'."),
    REGROUP(ErrType.FORX, 3, "Pattern matches empty string."),
    FUNREGREP(ErrType.FORX, 4, "Invalid replacement expression."),
    REGERR(ErrType.FORX, 4, "Regular expression: '%'."),
    SQLEXC(ErrType.FOSQ, 1, "An SQL exception occurred: '%'"),
    NOCONN(ErrType.FOSQ, 2, "No opened connection with id %"),
    PARAMS(ErrType.FOSQ, 3, "Number of parameters differs from number of placeholders"),
    NOPARAMTYPE(ErrType.FOSQ, 4, "No parameter type specified."),
    NOTEXPATTR(ErrType.FOSQ, 5, "Not expected attribute: %"),
    ILLFORMAT(ErrType.FOSQ, 6, "Illegal % format"),
    SQLINIT(ErrType.FOSQ, 7, "Could not initialize specified driver: '%'"),
    NOTYP(ErrType.FOTY, 12, "Item has no typed value: %."),
    FNATM(ErrType.FOTY, 13, "Function items cannot be atomized: %."),
    FNEQ(ErrType.FOTY, 13, "Function items have no defined equality: %."),
    FNSTR(ErrType.FOTY, 14, "Function items have no string representation: %."),
    FNCMP(ErrType.FOTY, 15, "Function items cannot be compared: %."),
    UPFOTYPE(ErrType.FOUP, 1, "Document or element expected, % found."),
    UPDOCTYPE(ErrType.FOUP, 1, "Document expected, % found."),
    UPFOURI(ErrType.FOUP, 2, "No valid URI: \"%\"."),
    UPPUTERR(ErrType.FOUP, 2, "\"%\" could not be written."),
    UPDBPUTERR(ErrType.FOUP, 2, "Resource \"%\" could not be written."),
    UPDBDELERR(ErrType.FOUP, 2, "Resource \"%\" could not be deleted."),
    UPDBRENAMEERR(ErrType.FOUP, 2, "Resource \"%\" could not be renamed."),
    FTWEIGHT(ErrType.FTDY, 16, "Weight value out of range: %."),
    FTMILD(ErrType.FTDY, 17, "Invalid 'mild not' selection."),
    FTREG(ErrType.FTDY, 20, "Invalid wildcard syntax: '%'."),
    FTFZWC(ErrType.FTST, 0, "Either wildcards or fuzzy search supported."),
    FTIGNORE(ErrType.FTST, 7, "Ignore option not supported."),
    NOSTOPFILE(ErrType.FTST, 8, "Stop word file not found: \"%\"."),
    FTNOSTEM(ErrType.FTST, 9, "No stemmer available for language '%'."),
    FTNOTOK(ErrType.FTST, 9, "No tokenizer available for language '%'."),
    NOTHES(ErrType.FTST, 18, "Thesaurus not found: \"%\"."),
    FTDUP(ErrType.FTST, 19, "Match option '%' was declared twice."),
    SERENCODING(ErrType.SESU, 7, "Encoding not supported: \"%\"."),
    SERSTAND(ErrType.SEPM, 9, "Invalid combination of \"omit-xml-declaration\"."),
    SERUNDECL(ErrType.SEPM, 10, "XML 1.0: undeclaring prefixes not allowed."),
    SERILL(ErrType.SERE, 14, "Illegal HTML character found: #x%."),
    SERPI(ErrType.SERE, 15, "Processing construction contains \">\"."),
    SERINVALID(ErrType.SEPM, 16, "Parameter \"%\" is unknown."),
    SERMAP(ErrType.SEPM, 16, "Character map \"%\" is not defined."),
    SERANY(ErrType.SEPM, 16, "%."),
    SERUNKNOWN(ErrType.SEPM, 17, "Serialization: unknown element %."),
    SERNOVAL(ErrType.SEPM, 17, "Serialization: missing 'value' attribute."),
    VAREMPTY(ErrType.XPDY, 2, "No value assigned to %."),
    XPNOCTX(ErrType.XPDY, 2, "No context item set for '%'."),
    CTXNODE(ErrType.XPDY, 50, "Root of the context item must be a document node."),
    NOTREAT(ErrType.XPDY, 50, "%: % expected, % found."),
    NOTREATS(ErrType.XPDY, 50, "%: % expected, sequence found."),
    QUERYEMPTY(ErrType.XPST, 3, "Empty query."),
    QUERYINV(ErrType.XPST, 3, "Query contains an illegal character (#%)."),
    NOQUOTE(ErrType.XPST, 3, "Expecting quote%."),
    NOVALIDATE(ErrType.XPST, 3, "Invalid validation expression."),
    NUMBERWS(ErrType.XPST, 3, "Expecting separator after number."),
    NUMBERINC(ErrType.XPST, 3, "Incomplete double value."),
    NUMBERITR(ErrType.XPST, 3, "Unexpected decimal point."),
    QUERYEND(ErrType.XPST, 3, "Unexpected end of query: '%'."),
    CMPEXPR(ErrType.XPST, 3, "Comparison is incomplete."),
    NOTAGNAME(ErrType.XPST, 3, "Expecting tag name."),
    NOATTNAME(ErrType.XPST, 3, "Expecting attribute name."),
    NOLOCSTEP(ErrType.XPST, 3, "Incomplete location step."),
    NOEXPR(ErrType.XPST, 3, "Expecting expression."),
    WRONGCHAR(ErrType.XPST, 3, "Expecting \"%\"%."),
    INVENTITY(ErrType.XPST, 3, "Invalid entity \"%\"."),
    INCOMPLETE(ErrType.XPST, 3, "Incomplete expression."),
    EVALUNARY(ErrType.XPST, 3, "Unary operator expects a numeric value."),
    PATHMISS(ErrType.XPST, 3, "Expecting location path."),
    DECLINCOMPLETE(ErrType.XPST, 3, "Incomplete declaration; expecting 'function', 'variable', ..."),
    FUNCNAME(ErrType.XPST, 3, "Expecting function name."),
    PREDMISSING(ErrType.XPST, 3, "Expecting expression before predicate."),
    NOVARNAME(ErrType.XPST, 3, "Expecting variable name."),
    NOVARDECL(ErrType.XPST, 3, "Expecting variable declaration."),
    TAGWRONG(ErrType.XPST, 3, "Start and end tag are different (%/%)."),
    PIWRONG(ErrType.XPST, 3, "Expecting name of processing-instruction."),
    NOENCLEXPR(ErrType.XPST, 3, "Expecting valid expression after \"{\"."),
    NODOCCONS(ErrType.XPST, 3, "Expecting document construction."),
    NOTXTCONS(ErrType.XPST, 3, "Expecting text construction."),
    NOCOMCONS(ErrType.XPST, 3, "Expecting comment construction."),
    NOFUNBODY(ErrType.XPST, 3, "Expecting function body."),
    FUNCMISS(ErrType.XPST, 3, "Expecting closing bracket for \"%(...\"."),
    MAPTKV(ErrType.XPST, 3, "Expecting '*' or key and value type for \"%(...\"."),
    MAPTAAT(ErrType.XPST, 3, "Expecting atomic key type for map(...), found \"%\"."),
    TYPEINVALID(ErrType.XPST, 3, "Expecting type declaration."),
    NODECLFORM(ErrType.XPST, 3, "Expecting decimal-format property declaration."),
    NOTYPESWITCH(ErrType.XPST, 3, "Incomplete typeswitch expression."),
    NOSWITCH(ErrType.XPST, 3, "Incomplete switch expression."),
    TYPEPAR(ErrType.XPST, 3, "Expecting '(' after 'switch' or 'typeswitch'."),
    PRAGMAINV(ErrType.XPST, 3, "Invalid pragma expression."),
    TESTINCOMPLETE(ErrType.XPST, 3, "Incomplete node test."),
    CALCEXPR(ErrType.XPST, 3, "Calculation is incomplete."),
    INVMAPKEY(ErrType.XPST, 3, "Invalid key, simple expression expected."),
    INVMAPVAL(ErrType.XPST, 3, "Invalid value, simple expression expected."),
    NORETURN(ErrType.XPST, 3, "Expecting return value."),
    NOWHERE(ErrType.XPST, 3, "Expecting valid expression after 'where'."),
    ORDERBY(ErrType.XPST, 3, "Expecting valid expression after 'order by'."),
    GRPBY(ErrType.XPST, 3, "Expecting valid expression after 'group by'."),
    FLWORWHERE(ErrType.XPST, 3, "Expecting 'where', 'order' or 'return' expression."),
    FLWORORD(ErrType.XPST, 3, "Expecting 'order' or 'return' expression."),
    FLWORRET(ErrType.XPST, 3, "Expecting 'return' expression."),
    NOSOME(ErrType.XPST, 3, "Incomplete quantifier expression."),
    IFPAR(ErrType.XPST, 3, "Expecting '(' after 'if' expression."),
    NOIF(ErrType.XPST, 3, "Incomplete 'if' expression."),
    NOFOR(ErrType.XPST, 3, "Incomplete 'for' expression."),
    NOLET(ErrType.XPST, 3, "Incomplete 'let' expression."),
    NOCLOSING(ErrType.XPST, 3, "Expecting closing tag </%>."),
    COMCLOSE(ErrType.XPST, 3, "Unclosed XQuery comment (: ..."),
    EXPREMPTY(ErrType.XPST, 3, "Unknown function or expression."),
    NOTYPE(ErrType.XPST, 3, "Unknown type \"%\"."),
    PIXML(ErrType.XPST, 3, "Illegal PI name: \"%\"."),
    EMPTYSEQOCC(ErrType.XPST, 3, "No occurrence indicator defined for %."),
    TESTINVALID(ErrType.XPST, 3, "Invalid % test: %."),
    QNAMEINV(ErrType.XPST, 3, "Expecting QName."),
    PROLOGORDER(ErrType.XPST, 3, "Default declaration must be declared first."),
    FTRANGE(ErrType.XPST, 3, "Expecting full-text range."),
    FTSTOP(ErrType.XPST, 3, "Stop words expected."),
    FTMATCH(ErrType.XPST, 3, "Unknown match option '%...'."),
    INVALPI(ErrType.XPST, 3, "Invalid PI name: \"%\"."),
    INTEXP(ErrType.XPST, 3, "Integer expected."),
    INVIN(ErrType.XPST, 3, "Invalid input: % found."),
    COMPSELF(ErrType.XPST, 5, "Warning: '%' will never yield results."),
    VARUNDEF(ErrType.XPST, 8, "Undefined variable %."),
    TYPEUNDEF(ErrType.XPST, 8, "Undefined type %."),
    XPARGS(ErrType.XPST, 17, "Wrong arguments: % expected."),
    FUNSIMILAR(ErrType.XPST, 17, "Unknown function \"%\"; similar: \"%\"."),
    FUNCTYPE(ErrType.XPST, 17, "Wrong arguments: %(value) expected."),
    FEATURE11(ErrType.XPST, 17, "Feature not available in XQuery 1.0."),
    FUNCUNKNOWN(ErrType.XPST, 17, "Unknown function \"%(...)\"."),
    FUNCJAVA(ErrType.XPST, 17, "Unknown Java function \"%(...)\"."),
    TYPEUNKNOWN(ErrType.XPST, 51, "Unknown type %."),
    CASTUNKNOWN(ErrType.XPST, 80, "Invalid cast type %."),
    PREFUNKNOWN(ErrType.XPST, 81, "Unknown prefix: \"%\"."),
    NSMISS(ErrType.XPST, 81, "% must be prefixed."),
    XPSEQ(ErrType.XPTY, 4, "No sequence % allowed."),
    XPINVCAST(ErrType.XPTY, 4, "Invalid cast from % to %: %."),
    XPINVPROM(ErrType.XPTY, 4, "Cannot promote type % to %: %."),
    XPCAST(ErrType.XPTY, 4, "Invalid %(%) cast."),
    XPTYPE(ErrType.XPTY, 4, "%: % expected, % found."),
    STRNODTYPE(ErrType.XPTY, 4, "%: xs:string or node() expected, % found."),
    NODFUNTYPE(ErrType.XPTY, 4, "%: node() or map expected, % found."),
    SIMPLDUR(ErrType.XPTY, 4, "%: only supported on subtypes of xs:duration, not %."),
    XPEMPTY(ErrType.XPTY, 4, "%: no empty sequence allowed."),
    XPEMPTYPE(ErrType.XPTY, 4, "%: % expected, empty sequence found."),
    XPDUR(ErrType.XPTY, 4, "%: duration expected, % found."),
    XPTYPECMP(ErrType.XPTY, 4, "% and % cannot be compared."),
    XPTYPENUM(ErrType.XPTY, 4, "%: number expected, % found."),
    XPINVNAME(ErrType.XPTY, 4, "Invalid name: \"%\"."),
    XPNAME(ErrType.XPTY, 4, "Expecting name."),
    XPATT(ErrType.XPTY, 4, "Cannot add attributes to a document node."),
    CPIWRONG(ErrType.XPTY, 4, "% not allowed as PI name: \"%\"."),
    INVQNAME(ErrType.XPTY, 4, "Invalid QName: \"%\"."),
    EVALNODESVALS(ErrType.XPTY, 18, "Result yields both nodes and atomic values."),
    NODESPATH(ErrType.XPTY, 19, "Context node required for %; % found."),
    CATTDUPL(ErrType.XQDY, 25, "Duplicate attribute \"%\"."),
    CPICONT(ErrType.XQDY, 26, "Invalid PI content: \"%\"."),
    CPIINVAL(ErrType.XQDY, 41, "Invalid PI name: \"%\"."),
    CAINS(ErrType.XQDY, 44, "Invalid attribute namespace %{\"%\"}."),
    CPIXML(ErrType.XQDY, 64, "Illegal PI name: \"%\"."),
    COMINVALID(ErrType.XQDY, 72, "Invalid comment."),
    INVNAME(ErrType.XQDY, 74, "Invalid name: \"%\"."),
    INVPREF(ErrType.XQDY, 74, "Unknown prefix: \"%\"."),
    XGRP(ErrType.XQDY, 95, "No sequence allowed as grouping variable."),
    CEINS(ErrType.XQDY, 96, "Invalid element namespace: %{\"%\"}."),
    IMPLSCHEMA(ErrType.XQST, 9, "Schema import not supported."),
    NSCONS(ErrType.XQST, 22, "Constant namespace value expected."),
    XQUERYVER(ErrType.XQST, 31, "XQuery version \"%\" not supported."),
    DUPLBASE(ErrType.XQST, 32, "Duplicate 'base-uri' declaration."),
    DUPLNSDECL(ErrType.XQST, 33, "Duplicate declaration of namespace %."),
    FUNCDEFINED(ErrType.XQST, 34, "Duplicate declaration of function \"%\"."),
    DUPLCOLL(ErrType.XQST, 38, "Duplicate 'collation' declaration."),
    COLLWHICH(ErrType.XQST, 38, "Unknown collation \"%\"."),
    FUNCDUPL(ErrType.XQST, 39, "Duplicate function argument %."),
    ATTDUPL(ErrType.XQST, 40, "Duplicate attribute \"%\"."),
    NAMERES(ErrType.XQST, 45, "Function %(...) uses reserved namespace."),
    DUPLMODULE(ErrType.XQST, 47, "Module is declared twice: \"%\"."),
    MODNS(ErrType.XQST, 48, "Declaration % does not match the module namespace."),
    VARDEFINE(ErrType.XQST, 49, "Duplicate declaration of %."),
    XPSTACK(ErrType.XQST, 54, "Stack Overflow: circular variable declaration?"),
    DUPLCOPYNS(ErrType.XQST, 55, "Duplicate 'copy-namespace' declaration."),
    NSEMPTY(ErrType.XQST, 57, "Namespace URI cannot be empty."),
    NOMODULE(ErrType.XQST, 59, "Unknown module for namespace \"%\"."),
    NOMODULEFILE(ErrType.XQST, 59, "Module not found: \"%\"."),
    WRONGMODULE(ErrType.XQST, 59, "Wrong uri % in imported module \"%\"."),
    FUNNONS(ErrType.XQST, 60, "Namespace needed for function %(...)."),
    DUPLORD(ErrType.XQST, 65, "Duplicate 'ordering' declaration."),
    DUPLNS(ErrType.XQST, 66, "Duplicate 'default namespace' declaration."),
    DUPLCONS(ErrType.XQST, 67, "Duplicate 'construction' declaration."),
    DUPLBOUND(ErrType.XQST, 68, "Duplicate 'boundary-space' declaration."),
    DUPLORDEMP(ErrType.XQST, 69, "Duplicate 'order empty' declaration."),
    NSDEF(ErrType.XQST, 70, "Cannot overwrite namespace %."),
    NOXMLNS(ErrType.XQST, 70, "Cannot declare % namespace."),
    DUPLNSDEF(ErrType.XQST, 71, "Duplicate declaration of namespace \"%\"."),
    IMPLVAL(ErrType.XQST, 75, "Validation not supported yet."),
    INVCOLL(ErrType.XQST, 76, "Unknown collation \"%\"."),
    NOPRAGMA(ErrType.XQST, 79, "Expecting pragma expression."),
    NSEMPTYURI(ErrType.XQST, 85, "Namespace URI cannot be empty."),
    XQUERYENC2(ErrType.XQST, 87, "Unknown encoding \"%\"."),
    NSMODURI(ErrType.XQST, 88, "Module namespace cannot be empty."),
    DUPLVAR(ErrType.XQST, 89, "Duplicate declaration of %."),
    INVCHARREF(ErrType.XQST, 90, "Invalid character reference \"%\"."),
    CIRCMODULE(ErrType.XQST, 93, "Circular module declaration."),
    GVARNOTDEFINED(ErrType.XQST, 94, "Undeclared grouping variable \"%\"."),
    INVDECFORM(ErrType.XQST, 97, "Invalid decimal-format property: %=\"%\"."),
    DUPLDECFORM(ErrType.XQST, 98, "Duplicate use of decimal-format \"%\"."),
    DUPLITEM(ErrType.XQST, 99, "Duplicate declaration of context item."),
    CTXINIT(ErrType.XQST, 107, "Context item depends on itself."),
    MODOUT(ErrType.XQST, 108, "No output declarations allowed in modules."),
    OUTWHICH(ErrType.XQST, 109, "Unknown serialization parameter: \"%\"."),
    OUTDUPL(ErrType.XQST, 110, "Duplicate declaration of \"output:%\"."),
    DECDUPL(ErrType.XQST, 111, "Duplicate decimal-format declaration."),
    DECITEM(ErrType.XQST, 113, "Context item cannot be specified in module."),
    DECDUPLPROP(ErrType.XQST, 114, "Duplicate decimal-format property \"%\"."),
    NOATTALL(ErrType.XQTY, 24, "Attribute must follow the root element."),
    WRONGINT(ErrType.FOFD, 1340, "Wrong integer format: \"%\"."),
    OPTAFTER(ErrType.FOFD, 1340, "Optional digit follows mandatory digits: \"%\"."),
    DIFFMAND(ErrType.FOFD, 1340, "Mandatory digits must be of the same group: \"%\"."),
    GROUPADJ(ErrType.FOFD, 1340, "Adjacent grouping separators: \"%\"."),
    GROUPSTART(ErrType.FOFD, 1340, "Picture begins with grouping separator: \"%\"."),
    GROUPEND(ErrType.FOFD, 1340, "Picture ends with grouping separator: \"%\"."),
    NOMAND(ErrType.FOFD, 1340, "No mandatory digit specified: \"%\"."),
    PICDATE(ErrType.FOFD, 1340, "Invalid picture string: \"%\"."),
    ORDCLOSED(ErrType.FOFD, 1340, "Ordinal is not closed: \"%\"."),
    PICCOMP(ErrType.FOFD, 1350, "Invalid component in string: \"%\"."),
    WRONGINPUT(ErrType.FOUT, 1170, "Failed to read \"%\": %."),
    WHICHENC(ErrType.FOUT, 1190, "Encoding '%' is not supported."),
    UPNOPAR(ErrType.XUDY, 9, "Target % has no parent."),
    UPNOTCOPIED(ErrType.XUDY, 14, "% was not copied by copy clause."),
    UPMULTREN(ErrType.XUDY, 15, "Multiple renames on %."),
    UPPATHREN(ErrType.XUDY, 15, "Multiple renames on path \"%\"."),
    UPMULTREPL(ErrType.XUDY, 16, "Multiple replaces on %."),
    UPMULTREPV(ErrType.XUDY, 17, "Multiple replaces on %."),
    UPATTDUPL(ErrType.XUDY, 21, "Duplicate attribute %."),
    UPNSCONFL(ErrType.XUDY, 23, "Conflicts with existing namespaces."),
    UPNSCONFL2(ErrType.XUDY, 24, "New namespaces conflict with each other."),
    UPSEQEMP(ErrType.XUDY, 27, "% target must not be empty."),
    UPPAREMPTY(ErrType.XUDY, 29, "Target has no parent node."),
    UPATTELM(ErrType.XUDY, 30, "Attributes cannot be inserted as child of a document."),
    UPURIDUP(ErrType.XUDY, 31, "URI \"%\" is addressed multiple times."),
    UPNOT(ErrType.XUST, 1, "%: no updating expression allowed."),
    UPEXPECTT(ErrType.XUST, 2, "Updating expression expected in modify clause."),
    UPEXPECTF(ErrType.XUST, 2, "Updating expression expected in function declaration."),
    DUPLREVAL(ErrType.XUST, 3, "Duplicate 'revalidation' declaration."),
    NOREVAL(ErrType.XUST, 26, "Revalidation mode not supported."),
    UPFUNCTYPE(ErrType.XUST, 28, "No return type allowed in updating functions."),
    UPNOATTRPER(ErrType.XUTY, 4, "Attribute must follow the root element."),
    UPTRGTYP(ErrType.XUTY, 5, "Single element or document expected as insert target."),
    UPTRGTYP2(ErrType.XUTY, 6, "Single element, text, comment or pi expected as insert target."),
    UPTRGDELEMPT(ErrType.XUTY, 7, "Only nodes can be deleted."),
    UPTRGMULT(ErrType.XUTY, 8, "Single element, text, attribute, comment or pi expected as replace target."),
    UPWRELM(ErrType.XUTY, 10, "Replacing nodes must be no attribute nodes."),
    UPWRATTR(ErrType.XUTY, 11, "Replacing nodes must be attribute nodes."),
    UPWRTRGTYP(ErrType.XUTY, 12, "Single element, attribute or pi expected as rename target."),
    UPCOPYMULT(ErrType.XUTY, 13, "Source expression in copy clause must return a single node."),
    UPATTELM2(ErrType.XUTY, 22, "Insert target must be an element."),
    CRYPTOCANINV(ErrType.CX, 1, "Canonicalization algorithm is not supported."),
    CRYPTODIGINV(ErrType.CX, 2, "Digest algorithm is not supported."),
    CRYPTOSIGINV(ErrType.CX, 3, "Signature algorithm is not supported."),
    CRYPTOXPINV(ErrType.CX, 4, "XPath expression is invalid."),
    CRYPTOINVNM(ErrType.CX, 5, "Invalid name for $digital-certificate root."),
    CRYPTOINVCH(ErrType.CX, 6, "Invalid child element of $digital-certificate."),
    CRYPTOKSNULL(ErrType.CX, 7, "Key store is null."),
    CRYPTOIOERR(ErrType.CX, 8, "I/O error while reading keystore."),
    CRYPTOPERMDEN(ErrType.CX, 9, "Permission denied to read keystore."),
    CRYPTOKSURLINV(ErrType.CX, 10, "Keystore URL is invalid."),
    CRYPTOKSTYPE(ErrType.CX, 11, "Keystore type is not supported."),
    CRYPTONOKEY(ErrType.CX, 12, "Cannot find key for alias in given keystore."),
    CRYPTOINVHASH(ErrType.CX, 13, "Hashing algorithm is not supported."),
    CRYPTOENC(ErrType.CX, 14, "The encoding method is not supported."),
    CRYPTONOSIG(ErrType.CX, 15, "Cannot find signature element."),
    CRYPTONOPAD(ErrType.CX, 16, "No such padding."),
    CRYPTOBADPAD(ErrType.CX, 17, "Incorrect padding."),
    CRYPTOENCTYP(ErrType.CX, 18, "Encryption type is not supported."),
    CRYPTOKEYINV(ErrType.CX, 19, "Secret key is invalid."),
    CRYPTOILLBLO(ErrType.CX, 20, "Illegal block size."),
    CRYPTOINVALGO(ErrType.CX, 21, "Algorithm is not supported."),
    CRYPTODECTYP(ErrType.CX, 22, "Decryption type is not supported."),
    CRYPTOSIGTYPINV(ErrType.CX, 999, "Signature type is not supported."),
    CRYPTONOTSUPP(ErrType.CX, 998, "Operation not (yet) supported."),
    CRYPTOSYMERR(ErrType.CX, 997, "Algorithm not compatible with encryption type."),
    CRYPTOIOEXC(ErrType.CX, 996, "IO Exception."),
    CRYPTOKSEXC(ErrType.CX, 995, "Keystore exception."),
    CRYPTOSIGEXC(ErrType.CX, 994, "Signature exception."),
    CRYPTOALGEXC(ErrType.CX, 993, "Invalid algorithm."),
    CRYPTOALINV(ErrType.CX, 992, "Invalid certificate alias %.");

    public final ErrType type;
    public final int num;
    public final String desc;

    private Err(ErrType t, int n2, String d) {
        this.type = t;
        this.num = n2;
        this.desc = d;
    }

    public QueryException thrw(InputInfo ii, Object ... ext) throws QueryException {
        throw new QueryException(ii, this, ext);
    }

    public SerializerException thrwSerial(Object ... ext) throws SerializerException {
        throw new SerializerException(this, ext);
    }

    public String code() {
        return String.format("%s%04d", new Object[]{this.type, this.num});
    }

    public static QueryException diff(InputInfo ii, Item it1, Item it2) throws QueryException {
        throw (it1 == it2 ? TYPECMP : XPTYPECMP).thrw(ii, it1.type, it2.type);
    }

    public static QueryException cast(InputInfo ii, Type t, Value v) throws QueryException {
        throw XPINVCAST.thrw(ii, v.type, t, v);
    }

    public static QueryException promote(InputInfo ii, Type t, Value v) throws QueryException {
        throw XPINVPROM.thrw(ii, v.type, t, v);
    }

    public static QueryException type(InputInfo ii, String inf, Type t, Item it) throws QueryException {
        throw XPTYPE.thrw(ii, inf, t, it.type);
    }

    public static QueryException type(ParseExpr e, Type t, Item it) throws QueryException {
        throw Err.type(e.input, e.desc(), t, it);
    }

    public static QueryException number(ParseExpr e, Item it) throws QueryException {
        throw XPTYPENUM.thrw(e.input, e.desc(), it.type);
    }

    public static QueryException value(InputInfo ii, Type t, Object v) throws QueryException {
        throw INVALUE.thrw(ii, t, v);
    }

    public String toString() {
        return String.format("%s%04d", new Object[]{this.type, this.num});
    }

    public static enum ErrType {
        BASX,
        CX,
        FOAR,
        FOCA,
        FOCH,
        FODC,
        FODF,
        FODT,
        FOFD,
        FOER,
        FOFL,
        FOHC,
        FONS,
        FORG,
        FORX,
        FOSQ,
        FOTY,
        FOUP,
        FOUT,
        FOZP,
        FTDY,
        FTST,
        PACK,
        SEPM,
        SERE,
        SESU,
        XPDY,
        XPST,
        XPTY,
        XQDY,
        XQST,
        XQTY,
        XUDY,
        XUST,
        XUTY;

    }
}

