/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.item.Item;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class Var
extends ParseExpr {
    public final QNm name;
    public final int id;
    public SeqType ret;
    public boolean global;
    public boolean declared;
    private Value value;
    private Expr expr;

    private Var(InputInfo ii, QNm n, SeqType t, int i) {
        super(ii);
        this.name = n;
        this.type = t;
        this.id = i;
    }

    public static Var create(QueryContext ctx, InputInfo ii, QNm n, SeqType t) {
        return new Var(ii, n, t, ctx.varIDs++);
    }

    public static Var create(QueryContext ctx, InputInfo ii, QNm n) {
        return Var.create(ctx, ii, n, null);
    }

    public static Var create(QueryContext ctx, InputInfo ii, QNm n, Value v) {
        Var var = Var.create(ctx, ii, n, v.type());
        var.expr = v;
        var.value = v;
        return var;
    }

    public void check() throws QueryException {
        if (this.expr != null && this.expr.uses(Expr.Use.UPD)) {
            Err.UPNOT.thrw(this.input, this.desc());
        }
    }

    @Override
    public Var comp(QueryContext ctx) throws QueryException {
        if (this.expr != null) {
            this.bind(this.checkUp(this.expr, ctx).comp(ctx), ctx);
        }
        return this;
    }

    public void reset(SeqType t, QueryContext ctx) throws QueryException {
        this.type = t;
        if (this.value != null && !this.value.type.instance(t.type) && this.value instanceof Item) {
            this.value = this.type.type.e((Item)this.value, ctx, this.input);
        }
    }

    public Var bind(Expr e, QueryContext ctx) throws QueryException {
        this.expr = e;
        return e.value() ? this.bind((Value)e, ctx) : this;
    }

    public Expr expr() {
        return this.expr;
    }

    public Var bind(Value v, QueryContext ctx) throws QueryException {
        this.expr = v;
        this.value = this.cast(v, ctx);
        return this;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.value(ctx).item(ctx, ii);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        if (this.value == null) {
            if (this.expr == null) {
                Err.VAREMPTY.thrw(this.input, this);
            }
            Value v = ctx.value;
            ctx.value = null;
            this.value = this.cast(this.expr.comp(ctx).value(ctx), ctx);
            ctx.value = v;
        }
        return this.value;
    }

    public boolean is(Var v) {
        return this.id == v.id;
    }

    private Value cast(Value v, QueryContext ctx) throws QueryException {
        return this.type == null ? v : this.type.promote(v, ctx, this.input);
    }

    public Var copy() {
        Var v = new Var(this.input, this.name, this.type, this.id);
        v.global = this.global;
        v.value = this.value;
        v.expr = this.expr;
        v.type = this.type;
        v.ret = this.ret;
        return v;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.VAR;
    }

    @Override
    public int count(Var v) {
        return this.is(v) ? 1 : 0;
    }

    @Override
    public boolean removable(Var v) {
        return false;
    }

    @Override
    public Var remove(Var v) {
        return this;
    }

    @Override
    public SeqType type() {
        return this.ret != null ? this.ret : (this.type != null ? this.type : (this.expr != null ? this.expr.type() : SeqType.ITEM_ZM));
    }

    @Override
    public boolean sameAs(Expr cmp) {
        if (!(cmp instanceof Var)) {
            return false;
        }
        Var v = (Var)cmp;
        return this.name.eq(v.name) && this.type().eq(v.type());
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.NAM, Token.token(this.toString())});
        if (this.expr != null) {
            this.expr.plan(ser);
        }
        ser.closeElement();
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        if (this.name != null) {
            tb.add("$").add(this.name.atom());
            if (this.type != null) {
                tb.add(" as");
            }
        }
        if (this.type != null) {
            tb.add(" " + this.type);
        }
        return tb.toString();
    }
}

