/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.build.SingleParser;
import org.basex.core.Prop;
import org.basex.data.MemData;
import org.basex.io.IO;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryException;
import org.basex.query.item.ANode;
import org.basex.query.item.Bln;
import org.basex.query.item.DBNode;
import org.basex.query.item.Item;
import org.basex.query.util.Err;
import org.basex.query.util.crypto.MyKeySelector;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DigitalSignature {
    private static final TokenMap CANONICALIZATIONS = new TokenMap();
    private static final TokenMap DIGESTS = new TokenMap();
    private static final TokenMap SIGNATURES = new TokenMap();
    private static final TokenSet TYPES = new TokenSet();
    private static final byte[] DEFC = Token.token("inclusive-with-comments");
    private static final byte[] DEFD = Token.token("SHA1");
    private static final byte[] DEFS = Token.token("RSA_SHA1");
    private static final byte[] DEFT = Token.token("enveloped");
    private static final byte[] ENVT = Token.token("enveloping");
    private final InputInfo input;

    static {
        CANONICALIZATIONS.add(DEFC, Token.token("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments"));
        CANONICALIZATIONS.add(Token.token("exclusive-with-comments"), Token.token("http://www.w3.org/2001/10/xml-exc-c14n#WithComments"));
        CANONICALIZATIONS.add(Token.token("inclusive"), Token.token("http://www.w3.org/TR/2001/REC-xml-c14n-20010315"));
        CANONICALIZATIONS.add(Token.token("exclusive"), Token.token("http://www.w3.org/2001/10/xml-exc-c14n#"));
        DIGESTS.add(DEFD, Token.token("http://www.w3.org/2000/09/xmldsig#sha1"));
        DIGESTS.add(Token.token("SHA256"), Token.token("http://www.w3.org/2001/04/xmlenc#sha256"));
        DIGESTS.add(Token.token("SHA512"), Token.token("http://www.w3.org/2001/04/xmlenc#sha512"));
        SIGNATURES.add(DEFS, Token.token("http://www.w3.org/2000/09/xmldsig#rsa-sha1"));
        SIGNATURES.add(Token.token("DSA_SHA1"), Token.token("http://www.w3.org/2000/09/xmldsig#dsa-sha1"));
        TYPES.add(DEFT);
        TYPES.add(ENVT);
    }

    public DigitalSignature(InputInfo ii) {
        this.input = ii;
    }

    public ANode generateSignature(ANode node, byte[] c, byte[] d, byte[] sig, byte[] ns, byte[] t, byte[] expr, ANode ce) throws QueryException {
        int ti;
        byte[] b = c;
        if (b.length == 0) {
            b = DEFC;
        }
        if ((b = CANONICALIZATIONS.get(b)) == null) {
            Err.CRYPTOCANINV.thrw(this.input, new Object[]{b});
        }
        String canonicalization = Token.string(b);
        b = d;
        if (b.length == 0) {
            b = DEFD;
        }
        if ((b = DIGESTS.get(b)) == null) {
            Err.CRYPTODIGINV.thrw(this.input, new Object[]{b});
        }
        String digest = Token.string(b);
        b = sig;
        if (b.length == 0) {
            b = DEFS;
        }
        byte[] tsig = b;
        if ((b = SIGNATURES.get(b)) == null) {
            Err.CRYPTOSIGINV.thrw(this.input, new Object[]{b});
        }
        String signature = Token.string(b);
        String keytype = Token.string(tsig).substring(0, 3);
        b = t;
        if (b.length == 0) {
            b = DEFT;
        }
        if ((ti = TYPES.id(b)) == 0) {
            Err.CRYPTOSIGTYPINV.thrw(this.input, new Object[]{b});
        }
        byte[] type = b;
        ANode signedNode = null;
        try {
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            PrivateKey pk = null;
            PublicKey puk = null;
            KeyInfo ki = null;
            if (ce != null) {
                String ksTY = null;
                String ksPW = null;
                String kAlias = null;
                String pkPW = null;
                String ksURI = null;
                Document ceDOM = DigitalSignature.toDOMNode(ce);
                if (!ceDOM.getDocumentElement().getNodeName().equals("digital-certificate")) {
                    Err.CRYPTOINVNM.thrw(this.input, ceDOM);
                }
                NodeList ceChilds = ceDOM.getDocumentElement().getChildNodes();
                int s = ceChilds.getLength();
                int ci = 0;
                while (ci < s) {
                    Node cn;
                    String name;
                    if ((name = (cn = ceChilds.item(ci++)).getNodeName()).equals("keystore-type")) {
                        ksTY = cn.getTextContent();
                        continue;
                    }
                    if (name.equals("keystore-password")) {
                        ksPW = cn.getTextContent();
                        continue;
                    }
                    if (name.equals("key-alias")) {
                        kAlias = cn.getTextContent();
                        continue;
                    }
                    if (name.equals("private-key-password")) {
                        pkPW = cn.getTextContent();
                        continue;
                    }
                    if (!name.equals("keystore-uri")) continue;
                    ksURI = cn.getTextContent();
                }
                KeyStore ks = KeyStore.getInstance(ksTY);
                if (ks == null) {
                    Err.CRYPTOKSNULL.thrw(this.input, ks);
                }
                ks.load(new FileInputStream(ksURI), ksPW.toCharArray());
                pk = (PrivateKey)ks.getKey(kAlias, pkPW.toCharArray());
                X509Certificate x509ce = (X509Certificate)ks.getCertificate(kAlias);
                if (x509ce == null) {
                    Err.CRYPTOALINV.thrw(this.input, kAlias);
                }
                puk = x509ce.getPublicKey();
                KeyInfoFactory kifactory = fac.getKeyInfoFactory();
                KeyValue keyValue = kifactory.newKeyValue(puk);
                Vector<XMLStructure> kiCont = new Vector<XMLStructure>();
                kiCont.add(keyValue);
                ArrayList<Object> x509Content = new ArrayList<Object>();
                X509IssuerSerial issuer = kifactory.newX509IssuerSerial(x509ce.getIssuerX500Principal().getName(), x509ce.getSerialNumber());
                x509Content.add(x509ce.getSubjectX500Principal().getName());
                x509Content.add(issuer);
                x509Content.add(x509ce);
                X509Data x509Data = kifactory.newX509Data(x509Content);
                kiCont.add(x509Data);
                ki = kifactory.newKeyInfo(kiCont);
            } else {
                KeyPairGenerator gen = KeyPairGenerator.getInstance(keytype);
                gen.initialize(512);
                KeyPair kp = gen.generateKeyPair();
                KeyInfoFactory kif = fac.getKeyInfoFactory();
                KeyValue kv = kif.newKeyValue(kp.getPublic());
                ki = kif.newKeyInfo(Collections.singletonList(kv));
                pk = kp.getPrivate();
            }
            Document inputNode = DigitalSignature.toDOMNode(node);
            List<Transform> tfList = null;
            if (expr.length > 0) {
                XPathFactory xpf = XPathFactory.newInstance();
                XPathExpression xExpr = xpf.newXPath().compile(Token.string(expr));
                NodeList xRes = (NodeList)xExpr.evaluate(inputNode, XPathConstants.NODESET);
                if (xRes.getLength() < 1) {
                    Err.CRYPTOXPINV.thrw(this.input, new Object[]{expr});
                }
                tfList = new ArrayList<Transform>(2);
                tfList.add(fac.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", new XPathFilterParameterSpec(Token.string(expr))));
                tfList.add(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            } else {
                tfList = Collections.singletonList(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            }
            Reference ref = fac.newReference("", fac.newDigestMethod(digest, null), tfList, null, null);
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod(canonicalization, (C14NMethodParameterSpec)null), fac.newSignatureMethod(signature, null), Collections.singletonList(ref));
            DOMSignContext signContext = null;
            XMLSignature xmlSig = null;
            if (Token.eq(type, DEFT)) {
                signContext = new DOMSignContext(pk, (Node)inputNode.getDocumentElement());
                xmlSig = fac.newXMLSignature(si, ki);
            } else {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DOMStructure cont = new DOMStructure(inputNode.getDocumentElement());
                XMLObject obj = fac.newXMLObject(Collections.singletonList(cont), "", null, null);
                xmlSig = fac.newXMLSignature(si, ki, Collections.singletonList(obj), null, null);
                signContext = new DOMSignContext(pk, (Node)inputNode);
            }
            if (ns.length > 0) {
                signContext.setDefaultNamespacePrefix(new String(ns));
            }
            xmlSig.sign(signContext);
            signedNode = this.toDBNode(inputNode);
        }
        catch (XPathExpressionException e) {
            Err.CRYPTOXPINV.thrw(this.input, e);
        }
        catch (SAXException e) {
            Err.CRYPTOIOEXC.thrw(this.input, e);
        }
        catch (IOException e) {
            Err.CRYPTOIOEXC.thrw(this.input, e);
        }
        catch (ParserConfigurationException e) {
            Err.CRYPTOIOEXC.thrw(this.input, e);
        }
        catch (KeyStoreException e) {
            Err.CRYPTOKSEXC.thrw(this.input, e);
        }
        catch (MarshalException e) {
            Err.CRYPTOSIGEXC.thrw(this.input, e);
        }
        catch (XMLSignatureException e) {
            Err.CRYPTOSIGEXC.thrw(this.input, e);
        }
        catch (NoSuchAlgorithmException e) {
            Err.CRYPTOALGEXC.thrw(this.input, e);
        }
        catch (CertificateException e) {
            Err.CRYPTOALGEXC.thrw(this.input, e);
        }
        catch (UnrecoverableKeyException e) {
            Err.CRYPTONOKEY.thrw(this.input, e);
        }
        catch (KeyException e) {
            Err.CRYPTONOKEY.thrw(this.input, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            Err.CRYPTOALGEXC.thrw(this.input, e);
        }
        return signedNode;
    }

    public Item validateSignature(ANode node) throws QueryException {
        boolean coreVal = false;
        try {
            Document doc = DigitalSignature.toDOMNode(node);
            DOMValidateContext valContext = new DOMValidateContext(new MyKeySelector(), (Node)doc);
            NodeList signl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (signl.getLength() < 1) {
                Err.CRYPTONOSIG.thrw(this.input, node);
            }
            valContext.setNode(signl.item(0));
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            coreVal = signature.validate(valContext);
            return Bln.get(coreVal);
        }
        catch (XMLSignatureException e) {
            Err.CRYPTOIOEXC.thrw(this.input, e);
        }
        catch (SAXException e) {
            Err.CRYPTOIOEXC.thrw(this.input, e);
        }
        catch (ParserConfigurationException e) {
            Err.CRYPTOIOEXC.thrw(this.input, e);
        }
        catch (IOException e) {
            Err.CRYPTOIOEXC.thrw(this.input, e);
        }
        catch (MarshalException e) {
            Err.CRYPTOSIGEXC.thrw(this.input, e);
        }
        return Bln.get(coreVal);
    }

    private ANode toDBNode(Node n) throws QueryException {
        String xmlString = null;
        DBNode dbn = null;
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(n);
            trans.transform(source, result);
            xmlString = sw.toString();
            SingleParser parser = Parser.xmlParser(IO.get(xmlString), new Prop());
            MemBuilder builder = new MemBuilder("", parser, new Prop());
            MemData mem = builder.build();
            dbn = new DBNode(mem, 1);
        }
        catch (IOException e) {
            Err.CRYPTOIOEXC.thrw(this.input, e);
        }
        catch (TransformerException e) {
            Err.CRYPTOIOEXC.thrw(this.input, e);
        }
        return dbn;
    }

    private static byte[] nodeToBytes(ANode n) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        Serializer s = Serializer.get(b, new SerializerProp("format=no"));
        n.serialize(s);
        s.close();
        return b.toByteArray();
    }

    private static Document toDOMNode(ANode n) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder().parse(new ByteArrayInputStream(DigitalSignature.nodeToBytes(n)));
    }
}

