/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.crypto;

import java.security.Key;
import java.security.KeyException;
import java.security.PublicKey;
import java.util.List;
import javax.security.cert.X509Certificate;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;

public class MyKeySelector
extends KeySelector {
    @Override
    public KeySelectorResult select(KeyInfo ki, KeySelector.Purpose p, AlgorithmMethod m, XMLCryptoContext c) throws KeySelectorException {
        if (ki == null) {
            throw new KeySelectorException("KeyInfo is null");
        }
        SignatureMethod sm = (SignatureMethod)m;
        List<XMLStructure> l = ki.getContent();
        int i = 0;
        while (i < l.size()) {
            XMLStructure s = l.get(i);
            PublicKey pk = null;
            if (s instanceof KeyValue) {
                try {
                    pk = ((KeyValue)s).getPublicKey();
                }
                catch (KeyException ke) {
                    throw new KeySelectorException(ke);
                }
            } else if (s instanceof X509Data) {
                for (Object d : ((X509Data)s).getContent()) {
                    if (!(d instanceof X509Certificate)) continue;
                    pk = ((X509Certificate)d).getPublicKey();
                }
            }
            if (pk != null) {
                String sa = sm.getAlgorithm();
                String ka = pk.getAlgorithm();
                if (ka.equalsIgnoreCase("DSA") && sa.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || ka.equalsIgnoreCase("RSA") && sa.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                    return new MyKeySelectorResult(pk);
                }
            }
            ++i;
        }
        throw new KeySelectorException("No KeyValue element found");
    }

    private static class MyKeySelectorResult
    implements KeySelectorResult {
        private final Key pk;

        @Override
        public Key getKey() {
            return this.pk;
        }

        MyKeySelectorResult(PublicKey key) {
            this.pk = key;
        }
    }
}

