/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Iterator;
import org.basex.core.Prop;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryException;
import org.basex.query.item.ANode;
import org.basex.query.item.B64;
import org.basex.query.item.Bln;
import org.basex.query.item.Hex;
import org.basex.query.item.Item;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Err;
import org.basex.query.util.http.Request;
import org.basex.query.util.http.RequestParser;
import org.basex.query.util.http.ResponseHandler;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenMap;

public final class HTTPClient {
    private static final byte[] METHOD = Token.token("method");
    private static final byte[] USRNAME = Token.token("username");
    private static final byte[] PASSWD = Token.token("password");
    private static final byte[] SENDAUTH = Token.token("send-authorization");
    private static final byte[] MEDIATYPE = Token.token("media-type");
    private static final byte[] HREF = Token.token("href");
    private static final byte[] STATUSONLY = Token.token("status-only");
    private static final byte[] OVERMEDIATYPE = Token.token("override-media-type");
    private static final byte[] REDIR = Token.token("follow-redirect");
    private static final byte[] TIMEOUT = Token.token("timeout");
    private static final byte[] BOUNDARY = Token.token("boundary");
    private static final byte[] CRLF = Token.token("\r\n");
    private static final String DEFAULT_BOUND = "1BEF0A57BE110FD467A";
    private static final byte[] SRC = Token.token("src");
    private static final byte[] APPL_XHTML = Token.token("application/html+xml");
    private static final byte[] APPL_XML = Token.token("application/xml");
    private static final byte[] APPL_EXT_XML = Token.token("application/xml-external-parsed-entity");
    private static final byte[] TXT_XML = Token.token("text/xml");
    private static final byte[] TXT_EXT_XML = Token.token("text/xml-external-parsed-entity");
    private static final byte[] MIME_XML_SUFFIX = Token.token("+xml");
    private static final byte[] TXT_HTML = Token.token("text/html");
    private static final byte[] MIME_TEXT_PREFIX = Token.token("text/");
    private static final byte[] BASE64 = Token.token("http:base64Binary");
    private static final byte[] HEXBIN = Token.token("http:hexBinary");
    private static final String CONT_TYPE = "Content-Type";
    private static final String AUTH = "Authorization";
    private static final String AUTH_BASIC = "Basic ";

    private HTTPClient() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Iter sendRequest(byte[] href, ANode request, ItemCache bodies, InputInfo ii, Prop prop) throws QueryException {
        try {
            byte[] dest;
            if (request == null) {
                if (href == null || href.length == 0) {
                    Err.NOPARAMS.thrw(ii, new Object[0]);
                }
                HttpURLConnection conn = HTTPClient.openConnection(Token.string(href), ii);
                try {
                    ValueIter valueIter = ResponseHandler.getResponse(conn, Bln.FALSE.atom(ii), Bln.FALSE.atom(ii), prop, ii);
                    return valueIter;
                }
                finally {
                    conn.disconnect();
                }
            }
            Request r = RequestParser.parse(request, bodies, ii);
            byte[] byArray = dest = href == null ? r.attrs.get(HREF) : href;
            if (dest == null) {
                Err.NOURL.thrw(ii, new Object[0]);
            }
            HttpURLConnection conn = HTTPClient.openConnection(Token.string(dest), ii);
            try {
                HTTPClient.setConnectionProps(conn, r, ii);
                HTTPClient.setRequestHeaders(conn, r, ii);
                if (r.bodyContent.size() != 0L || r.parts.size() != 0) {
                    HTTPClient.setContentType(conn, r);
                    HTTPClient.setRequestContent(conn.getOutputStream(), r, ii);
                }
                ValueIter valueIter = ResponseHandler.getResponse(conn, r.attrs.get(STATUSONLY), r.attrs.get(OVERMEDIATYPE), prop, ii);
                return valueIter;
            }
            finally {
                conn.disconnect();
            }
        }
        catch (MalformedURLException ex) {
            throw Err.HTTPERR.thrw(ii, "Invalid URL");
        }
        catch (ProtocolException ex) {
            throw Err.HTTPERR.thrw(ii, "Invalid HTTP method");
        }
        catch (IOException ex) {
            throw Err.HTTPERR.thrw(ii, ex);
        }
    }

    private static HttpURLConnection openConnection(String dest, InputInfo ii) throws QueryException, IOException {
        URL url = new URL(dest);
        String protocol = url.getProtocol();
        if (!protocol.equalsIgnoreCase("HTTP") && !protocol.equalsIgnoreCase("HTTPS")) {
            Err.HTTPERR.thrw(ii, "Invalid URL");
        }
        return (HttpURLConnection)url.openConnection();
    }

    private static void setConnectionProps(HttpURLConnection conn, Request r, InputInfo ii) throws ProtocolException, QueryException {
        byte[] redirect;
        if (r.bodyContent != null || r.parts.size() != 0) {
            conn.setDoOutput(true);
        }
        conn.setRequestMethod(Token.string(r.attrs.get(METHOD)).toUpperCase());
        byte[] timeout = r.attrs.get(TIMEOUT);
        if (timeout != null) {
            conn.setConnectTimeout(Integer.parseInt(Token.string(timeout)));
        }
        if ((redirect = r.attrs.get(REDIR)) != null) {
            HttpURLConnection.setFollowRedirects(Bln.parse(redirect, ii));
        }
    }

    private static void setContentType(HttpURLConnection conn, Request r) {
        byte[] contTypeHdr = r.headers.get(Token.lc(Token.token(CONT_TYPE)));
        if (contTypeHdr != null) {
            conn.setRequestProperty(CONT_TYPE, Token.string(contTypeHdr));
        } else {
            String mediaType = Token.string(r.payloadAttrs.get(MEDIATYPE));
            if (r.isMultipart) {
                byte[] b = r.payloadAttrs.get(BOUNDARY);
                String boundary = b != null ? Token.string(b) : DEFAULT_BOUND;
                StringBuilder sb = new StringBuilder();
                sb.append(mediaType).append("; ").append("boundary=").append(boundary);
                conn.setRequestProperty(CONT_TYPE, sb.toString());
            } else {
                conn.setRequestProperty(CONT_TYPE, mediaType);
            }
        }
    }

    private static void setRequestHeaders(HttpURLConnection conn, Request r, InputInfo ii) throws QueryException {
        byte[][] headerNames;
        byte[][] byArray = headerNames = r.headers.keys();
        int n = headerNames.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] headerName = byArray[n2];
            conn.addRequestProperty(Token.string(headerName), Token.string(r.headers.get(headerName)));
            ++n2;
        }
        byte[] sendAuth = r.attrs.get(SENDAUTH);
        if (sendAuth != null && Bln.parse(sendAuth, ii)) {
            conn.setRequestProperty(AUTH, HTTPClient.encodeCredentials(Token.string(r.attrs.get(USRNAME)), Token.string(r.attrs.get(PASSWD))));
        }
    }

    public static void setRequestContent(OutputStream out, Request r, InputInfo ii) throws IOException, QueryException {
        if (r.isMultipart) {
            HTTPClient.writeMultipart(r, out, ii);
        } else {
            HTTPClient.writePayload(r.bodyContent, r.payloadAttrs, out, ii);
        }
        out.close();
    }

    private static String encodeCredentials(String u, String p) {
        return AUTH_BASIC + Base64.encode(String.valueOf(u) + ':' + p);
    }

    private static void writePayload(ItemCache payload, TokenMap payloadAtts, OutputStream out, InputInfo ii) throws IOException, QueryException {
        byte[] mediaType = payloadAtts.get(MEDIATYPE);
        byte[] method = payloadAtts.get(METHOD);
        byte[] src = payloadAtts.get(SRC);
        if (src == null) {
            if (method == null) {
                method = Token.eq(mediaType, APPL_XHTML) ? Token.token("xhtml") : (Token.eq(mediaType, APPL_XML) || Token.eq(mediaType, APPL_EXT_XML) || Token.eq(mediaType, TXT_XML) || Token.eq(mediaType, TXT_EXT_XML) || Token.endsWith(mediaType, MIME_XML_SUFFIX) ? Token.token("xml") : (Token.eq(mediaType, TXT_HTML) ? Token.token("html") : (Token.startsWith(mediaType, MIME_TEXT_PREFIX) ? Token.token("text") : Token.token("xml"))));
            }
            if (Token.eq(method, BASE64)) {
                HTTPClient.writeBase64(payload, out, ii);
            } else if (Token.eq(method, HEXBIN)) {
                HTTPClient.writeHex(payload, out, ii);
            } else {
                HTTPClient.write(payload, payloadAtts, method, out);
            }
        } else {
            HTTPClient.writeResource(src, out);
        }
    }

    private static void writeBase64(ItemCache payload, OutputStream out, InputInfo ii) throws IOException, QueryException {
        int i = 0;
        while ((long)i < payload.size()) {
            Item item = payload.get(i);
            if (item instanceof B64) {
                out.write(((B64)item).toJava());
            } else {
                out.write(new B64(item.atom(ii)).toJava());
            }
            ++i;
        }
    }

    private static void writeHex(ItemCache payload, OutputStream out, InputInfo ii) throws IOException, QueryException {
        int i = 0;
        while ((long)i < payload.size()) {
            Item item = payload.get(i);
            if (item instanceof Hex) {
                out.write(((Hex)item).toJava());
            } else {
                out.write(new Hex(item.atom(ii)).toJava());
            }
            ++i;
        }
    }

    private static void write(ItemCache payload, TokenMap payloadAttrs, byte[] method, OutputStream out) throws IOException {
        byte[][] keys;
        TokenBuilder tb = new TokenBuilder();
        tb.add(Token.token("method=")).add(method);
        byte[][] byArray = keys = payloadAttrs.keys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] key = byArray[n2];
            if (!(Token.eq(key, SRC) || Token.eq(key, MEDIATYPE) || Token.eq(key, METHOD))) {
                tb.add(44).add(key).add(61).add(payloadAttrs.get(key));
            }
            ++n2;
        }
        SerializerProp prop = new SerializerProp(tb.toString());
        Serializer ser = Serializer.get(out, prop);
        try {
            payload.serialize(ser);
        }
        finally {
            ser.close();
        }
    }

    private static void writeResource(byte[] src, OutputStream out) throws IOException {
        InputStream bis = new URL(Token.string(src)).openStream();
        try {
            int len;
            byte[] buf = new byte[256];
            while ((len = bis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            bis.close();
        }
    }

    private static void writeMultipart(Request r, OutputStream out, InputInfo ii) throws IOException, QueryException {
        byte[] boundary = r.payloadAttrs.get(BOUNDARY);
        Iterator<Request.Part> i = r.parts.iterator();
        while (i.hasNext()) {
            HTTPClient.writePart(i.next(), out, boundary, ii);
        }
        out.write(new TokenBuilder().add("--").add(boundary).add("--").add(CRLF).finish());
    }

    private static void writePart(Request.Part part, OutputStream out, byte[] boundary, InputInfo ii) throws IOException, QueryException {
        TokenBuilder boundTb = new TokenBuilder();
        boundTb.add("--").add(boundary).add(CRLF);
        out.write(boundTb.finish());
        byte[][] byArray = part.headers.keys();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] headerName = byArray[n2];
            TokenBuilder hdrTb = new TokenBuilder();
            hdrTb.add(headerName).add(": ").add(part.headers.get(headerName)).add(CRLF);
            out.write(hdrTb.finish());
            ++n2;
        }
        out.write(CRLF);
        HTTPClient.writePayload(part.bodyContent, part.bodyAttrs, out, ii);
        out.write(CRLF);
    }
}

