/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.json;

import org.basex.data.DataText;
import org.basex.query.QueryException;
import org.basex.query.item.ANode;
import org.basex.query.item.FAttr;
import org.basex.query.item.FElem;
import org.basex.query.item.FTxt;
import org.basex.query.item.QNm;
import org.basex.query.util.json.JArray;
import org.basex.query.util.json.JAtom;
import org.basex.query.util.json.JBoolean;
import org.basex.query.util.json.JNull;
import org.basex.query.util.json.JNumber;
import org.basex.query.util.json.JObject;
import org.basex.query.util.json.JSONParser;
import org.basex.query.util.json.JString;
import org.basex.query.util.json.JStruct;
import org.basex.query.util.json.JValue;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenObjMap;

public final class JSONConverter {
    private static final byte[] S = new byte[]{115};
    private static final byte[][] ATTRS = new byte[][]{Token.concat(DataText.BOOL, S), Token.concat(DataText.NUM, S), Token.concat(Token.NULL, S), Token.concat(DataText.ARR, S), Token.concat(DataText.OBJ, S)};
    private static final Class<?>[] CLASSES = new Class[]{JBoolean.class, JNumber.class, JNull.class, JArray.class, JObject.class};
    private static final QNm Q_TYPE = new QNm(DataText.TYPE);
    private final TokenObjMap<QNm> qnames = new TokenObjMap();
    private final TokenObjMap<Class<?>> types = new TokenObjMap();
    private final InputInfo input;

    public JSONConverter(InputInfo ii) {
        this.input = ii;
    }

    public ANode parse(byte[] q) throws QueryException {
        JStruct node = new JSONParser(q, this.input).parse();
        this.types.add(DataText.JSON, node.getClass());
        this.analyze(node);
        FElem root = this.create(DataText.JSON, node);
        this.attach(root);
        return root;
    }

    private void analyze(JValue value) {
        if (value instanceof JStruct) {
            JStruct n = (JStruct)value;
            int s = 0;
            while (s < n.size()) {
                boolean obj = value instanceof JObject;
                byte[] name = this.convert(obj ? ((JObject)n).name(s) : DataText.VALUE);
                Class<?> clz = n.value(s).getClass();
                Class<?> type = this.types.get(name);
                if (type == null) {
                    this.types.add(name, clz);
                } else if (type != JValue.class && type != clz) {
                    this.types.add(name, JValue.class);
                }
                this.analyze(n.value(s));
                ++s;
            }
        }
    }

    private FElem create(byte[] name, JValue value) {
        boolean type;
        byte[] nm = this.convert(name);
        FElem root = new FElem(this.qname(nm));
        Class<?> clz = this.types.get(nm);
        boolean bl = type = clz == null || clz == JValue.class;
        if (value instanceof JStruct) {
            boolean obj = value instanceof JObject;
            if (type) {
                root.add(new FAttr(Q_TYPE, value.type()));
            }
            JStruct n = (JStruct)value;
            int s = 0;
            while (s < n.size()) {
                root.add(this.create(obj ? ((JObject)n).name(s) : DataText.VALUE, n.value(s)));
                ++s;
            }
        } else {
            byte[] v;
            JAtom a = (JAtom)value;
            if (type && !(a instanceof JString)) {
                root.add(new FAttr(Q_TYPE, a.type()));
            }
            if ((v = a.value()) != null && v.length != 0) {
                root.add(new FTxt(v));
            }
        }
        return root;
    }

    private void attach(FElem root) {
        TokenBuilder[] builders = new TokenBuilder[CLASSES.length];
        int b = 0;
        while (b < builders.length) {
            builders[b] = new TokenBuilder();
            ++b;
        }
        int i = 1;
        while (i <= this.types.size()) {
            Class<?> clz = this.types.value(i);
            int b2 = 0;
            while (b2 < builders.length) {
                if (clz == CLASSES[b2]) {
                    if (builders[b2].size() != 0) {
                        builders[b2].add(32);
                    }
                    builders[b2].add(this.types.key(i));
                    break;
                }
                ++b2;
            }
            ++i;
        }
        b = 0;
        while (b < builders.length) {
            if (builders[b].size() != 0) {
                root.add(new FAttr(this.qname(ATTRS[b]), builders[b].trim().finish()));
            }
            ++b;
        }
    }

    private byte[] convert(byte[] name) {
        TokenBuilder tb = new TokenBuilder();
        int n = 0;
        while (n < name.length) {
            int cp = Token.cp(name, n);
            if (cp == 95) {
                tb.add(95).add(95);
            } else if (n == 0 ? XMLToken.isNCStartChar(cp) : XMLToken.isNCChar(cp)) {
                tb.add(cp);
            } else {
                tb.add(95);
                byte[] buf = new byte[4];
                int p = buf.length;
                do {
                    int b = cp & 0xF;
                    buf[--p] = (byte)(b + (b > 9 ? 55 : 48));
                    cp >>>= 4;
                } while (p != 0);
                tb.add(buf);
            }
            n += Token.cl(name, n);
        }
        if (tb.size() == 0) {
            tb.add(95);
        }
        return tb.finish();
    }

    private QNm qname(byte[] name) {
        QNm qname = this.qnames.get(name);
        if (qname == null) {
            qname = new QNm(name);
            this.qnames.add(name, qname);
        }
        return qname;
    }
}

