/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import org.basex.core.Text;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.util.pkg.Package;
import org.basex.query.util.pkg.PkgParser;
import org.basex.query.util.pkg.Repo;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Version;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.ObjList;

public final class PkgValidator {
    private final Repo repo;
    private final InputInfo input;

    public PkgValidator(Repo r, InputInfo ii) {
        this.repo = r;
        this.input = ii;
    }

    public void check(Package pkg) throws QueryException {
        byte[] name = pkg.uniqueName();
        if (this.repo.pkgDict().get(name) != null) {
            Err.PKGINST.thrw(this.input, new Object[]{name});
        }
        this.checkDepends(pkg);
        this.checkComps(pkg);
    }

    private void checkDepends(Package pkg) throws QueryException {
        ObjList<Package.Dependency> procs = new ObjList<Package.Dependency>();
        for (Package.Dependency dep : pkg.dep) {
            if (dep.pkg == null && dep.processor == null) {
                Err.PKGDESCINV.thrw(this.input, "Dependency not completely specified.");
            }
            if (dep.pkg != null && this.depPkg(dep) == null) {
                Err.NECPKGNOTINST.thrw(this.input, new Object[]{dep.pkg});
            }
            if (dep.processor == null) continue;
            procs.add(dep);
        }
        if (procs.size() != 0) {
            this.checkProcs(procs);
        }
    }

    public byte[] depPkg(Package.Dependency dep) {
        TokenSet instVers = new TokenSet();
        byte[][] byArray = this.repo.pkgDict().keys();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] nextPkg = byArray[n2];
            if (nextPkg != null && Token.startsWith(nextPkg, dep.pkg)) {
                instVers.add(Package.version(nextPkg));
            }
            ++n2;
        }
        byte[] version = this.availVersion(dep, instVers);
        return version == null ? null : dep.name(version);
    }

    private void checkProcs(ObjList<Package.Dependency> procs) throws QueryException {
        boolean supported = false;
        for (Package.Dependency d : procs) {
            if (!Token.eq(Token.lc(d.processor), Token.token(Text.NAMELC))) {
                supported = false;
                break;
            }
            int i = "7.0 beta".indexOf(" ");
            String v = i == -1 ? "7.0 beta" : "7.0 beta".substring(0, i);
            boolean bl = supported = this.availVersion(d, new TokenSet(new byte[][]{Token.token(v)})) != null;
        }
        if (!supported) {
            Err.PKGNOTSUPP.thrw(this.input, new Object[0]);
        }
    }

    private byte[] availVersion(Package.Dependency dep, TokenSet currentVers) {
        if (currentVers.size() == 0) {
            return null;
        }
        if (dep.versions != null) {
            TokenSet versList = new TokenSet(Token.split(dep.versions, 32));
            for (byte[] v : versList) {
                if (currentVers.id(v) == 0) continue;
                return v;
            }
        } else if (dep.semver != null) {
            Version semVer = new Version(dep.semver);
            for (byte[] v : currentVers) {
                if (!new Version(v).isCompatible(semVer)) continue;
                return v;
            }
        } else if (dep.semverMin != null && dep.semverMax != null) {
            Version min = new Version(dep.semverMin);
            Version max = new Version(dep.semverMax);
            for (byte[] nextVer : currentVers) {
                Version v = new Version(nextVer);
                if (v.compareTo(min) < 0 || v.compareTo(max) >= 0) continue;
                return nextVer;
            }
        } else if (dep.semverMin != null) {
            Version semVer = new Version(dep.semverMin);
            for (byte[] nextVer : currentVers) {
                Version v = new Version(nextVer);
                if (!v.isCompatible(semVer) && v.compareTo(semVer) < 0) continue;
                return nextVer;
            }
        } else if (dep.semverMax != null) {
            Version semVer = new Version(dep.semverMax);
            for (byte[] nextVer : currentVers) {
                Version v = new Version(nextVer);
                if (!v.isCompatible(semVer) && v.compareTo(semVer) > 0) continue;
                return nextVer;
            }
        } else {
            return currentVers.keys()[0];
        }
        return null;
    }

    private void checkComps(Package pkg) throws QueryException {
        for (Package.Component comp : pkg.comps) {
            if (!this.isInstalled(comp, pkg.name)) continue;
            Err.MODISTALLED.thrw(this.input, comp.name());
        }
    }

    private boolean isInstalled(Package.Component comp, byte[] name) throws QueryException {
        TokenSet pkgs = this.repo.nsDict().get(comp.uri);
        if (pkgs == null) {
            return false;
        }
        for (byte[] nextPkg : pkgs) {
            if (nextPkg == null || Token.eq(Package.name(nextPkg), name)) continue;
            String pkgDir = Token.string(this.repo.pkgDict().get(nextPkg));
            IOFile pkgDesc = new IOFile(this.repo.path(pkgDir), "expath-pkg.xml");
            Package pkg = new PkgParser(this.repo, this.input).parse(pkgDesc);
            for (Package.Component nextComp : pkg.comps) {
                if (!nextComp.name().equals(comp.name())) continue;
                return true;
            }
        }
        return false;
    }
}

